; Tree Example

IncludeFile "Common.pb"
IncludeFile "X3D.pbi" 

hwnd.l=Open_Window_0()
If hwnd=0
End
EndIf 

; *************** Initialize 3D Engine ******************
x3d_start_(175,0,475,480,hwnd,#FALSE);
;x3d_sync_(#VSYNC)
x3d_lighting_(0)
x3d_setTexturePaths_("res")
x3d_BackgroundColor_($F08080)

; ************************ object sorting ********************
back.l=x3d_createObject_(#DUMMY,#NULL,""); 
front.l=x3d_createObject_(#DUMMY,#NULL,"");

; *************************** Camera **************************
d.l=x3d_createObject_(#DUMMY,#NULL,"") ; dummycube for mouselook
cam.l=x3d_createObject_(#CAMERA,d,"") ; camera is child of dummy
x3d_setCameraViewDepth_(cam,1200.0)
x3d_SetCamera_(cam); activate camera
x3d_RotateObject_(cam,0.0,180.0,0.0)
x3d_TranslateObject_(d,0.0,8.0,-20.0)

; ************************** Plane ****************************
floor.l=x3d_createObject_(#PLANE,back,"")
x3d_CreateMaterial_("mfloor","res\grass3.png",0)
x3d_setTextureScale_("mfloor",5.0,5.0)
x3d_setmaterial_(floor,"mfloor")
x3d_RotateObject_(floor,90.0,0.0,0.0);
x3d_setObjectScale_(floor,50.0,50.0,50.0)

; *************************** Tree *************************
tree.l=x3d_createObject_(#TREE,front,"")
x3d_CreateMaterial_("mbranch","res\zbark.jpg",#FALSE)
x3d_CreateMaterial_("mleaf","res\maple.tga",#FALSE)
x3d_setBlendingMode_("mleaf",#bmAlphaTest50)
x3d_RotateObject_(tree,90.0,0.0,0.0)
x3d_setTreeBranchSize_(tree,4.0)
x3d_setTreeBranchRadius_(tree,0.3)
x3d_setTreeDepth_(tree,8)
x3d_setTreeMaterials_(tree,"mleaf","mleaf","mbranch")


Repeat
  
  Event = WindowEvent()
  
  If Event = #PB_EventGadget
    
    GadgetID = EventGadgetID()
    
    If GadgetID = #TrackBar_0
      x3d_setTreeDepth_(tree,GetGadgetState(#TrackBar_0))
      
    ElseIf GadgetID = #TrackBar_1
      x3d_setTreeBranchFacets_(tree,GetGadgetState(#TrackBar_1))
      
    ElseIf GadgetID = #TrackBar_2
      x3d_setTreeBranchTwist_(tree,0.0+GetGadgetState(#TrackBar_2))
      
    ElseIf GadgetID = #TrackBar_3
      x3d_setTreeBranchAngle_(tree,0.0+GetGadgetState(#TrackBar_3)/100)
      
    ElseIf GadgetID = #TrackBar_4
      x3d_setTreeBranchSize_(tree,0.0+GetGadgetState(#TrackBar_4)/10)
      
    ElseIf GadgetID = #TrackBar_5
      x3d_setTreeBranchRadius_(tree,0.0+GetGadgetState(#TrackBar_5)/10)
      
    ElseIf GadgetID = #TrackBar_6
      x3d_setTreeBranchNoise_(tree,0.0+GetGadgetState(#TrackBar_6)/100)
      
    ElseIf GadgetID = #TrackBar_7
      x3d_setTreeLeafSize_(tree,0.0+GetGadgetState(#TrackBar_7)/100)
      
    ElseIf GadgetID = #TrackBar_8
      x3d_setTreeLeafThreshold_(tree,0.0+GetGadgetState(#TrackBar_8)/100)
      
    ElseIf GadgetID = #String_0
      x3d_setTreeSeed_(tree,Val(GetGadgetText(#String_0)))
      
    EndIf
    
  EndIf
 
  
fps=x3d_render_()
SetWindowTitle(0,"FPS: "+Str(fps))
  
  
Until Event = #PB_EventCloseWindow
x3d_end_(); close 3D scene 
End

; ExecutableFormat=
; DisableDebugger
; EOF