; Fire FX Example

IncludeFile "X3D.pbi" 

Declare updateFire()

hwnd.l=OpenWindow(1,50,50,640,480,#PB_Window_SystemMenu,"Xtreme3D")

If hwnd=0 Or InitSprite()=0 Or InitKeyboard()=0 Or InitMouse()=0 Or InitSound()=0
End
EndIf 

; we don't need a screen but without it we can't use 
; PB keyboard and mouse functions
; open the smallest screen possible, then you don't waste memory
ws.l=OpenWindowedScreen(WindowID(1),0,0,1,1,0,0,0)

; start engine in window(640x480)
x3d_start_(0,0,640,480,hwnd,#FALSE);
x3d_sync_(#VSYNC)
x3d_lighting_(0)
x3d_setTexturePaths_("res")
x3d_BackgroundColor_($000000)

; ************* objects sorting ******************************
objects.l=x3d_createObject_(#DUMMY,#NULL,"")
hud.l=x3d_createObject_(#DUMMY,#NULL,"")

; *************************** Camera **************************
d.l=x3d_createObject_(#DUMMY,#NULL,"") ; dummycube for mouselook
cam.l=x3d_createObject_(#CAMERA,d,"") ; camera is child of dummy
x3d_setCameraViewDepth_(cam,1200.0)
x3d_SetCamera_(cam); activate camera
x3d_RotateObject_(cam,0.0,180.0,0.0)
x3d_TranslateObject_(d,0.0,5.0,-20.0)

; ************************** Plane ****************************
floor.l=x3d_createObject_(#PLANE,objects,"")
x3d_CreateMaterial_("mfloor","res\grass3.png",0)
x3d_setTextureScale_("mfloor",5.0,5.0)
x3d_setmaterial_(floor,"mfloor")
x3d_RotateObject_(floor,90.0,0.0,0.0);
x3d_setObjectScale_(floor,50.0,50.0,50.0)

; ************************** crosshair ************************
x3d_createMaterial_("mcross","res\crosshair09.png",#TRUE) ; #TRUE for transparency
cross.l=x3d_createObject_(#SPRITE,hud,"mcross")
x3d_setObjectPosition_(cross,320.0,240.0,0.0)

; ************************** font+text *****************************
bfont.l=x3d_createBmpFont_(31,31,2,4,1,1,32,95) ; create font object
x3d_loadBmpFont_(bfont,"res\bfont.bmp") ; load bitmap font
txt.l=x3d_createObject_(#TEXT,hud,"PRESS SPACE") ; create text object
x3d_SetTextFont_(txt, bfont) ; set font for text

; *************************** Fire FX *************************
fm.l=x3d_createFXManager_(#FIRE)
fire.l=x3d_createFireFX_(fm,objects)
x3d_setObjectPosition_(fire,0.0,6.0,0.0)

Repeat
 EventID.l = WindowEvent()
  ExamineKeyboard();
    If KeyboardPushed(#PB_Key_Escape) ; If the user has pressed on the close button
      Quit = 1
    EndIf      
   
    If KeyboardPushed(#PB_KEY_A) 
    x3d_strafeObject_(d,-0.8)
EndIf
If KeyboardPushed(#PB_KEY_D) 
    x3d_strafeObject_(d,0.8)
EndIf
If KeyboardPushed(#PB_KEY_W) 
    x3d_moveObject_(d,0.8)
EndIf
If KeyboardPushed(#PB_KEY_S) 
    x3d_moveObject_(d,-0.8)
EndIf

If KeyboardReleased(#PB_KEY_SPACE)
  updateFire()   
EndIf

 ExamineMouse();
 Gosub mouselook

 fps=x3d_render_()
 SetWindowTitle(1,"FPS: "+Str(fps))

Until Quit = 1

x3d_end_(); close 3D scene 
End 

mouselook:
dx.f=-MouseDeltaX()/8
dy.f=-MouseDeltaY()/8
x3d_rotateObject_(d,0.0,dx,0.0);
pitch.f=PeekF(x3d_pitchAngle_(cam))+dy
If pitch<89 And pitch>-89
x3d_rotateObject_(cam,dy,0.0,0.0)
EndIf
Return

Procedure updateFire()
Shared fm, fire
 m.l=Random(256)+8
 x3d_Setfiremaxparticles_(fm,m)
 x3d_setfireparticlesize_(fm,0.4+Random(3));
 x3d_setfiredensity_(fm,0.2+Random(3));
 x3d_setfireEvaporation_(fm,0.1+Random(3));
 m.l=Random(9)+1
 x3d_setfireLife_(fm,m);
 x3d_setfireBurst_(fm,Random(5)+0.2);
 r.l=Random(150)+155
 g.l=Random(150)+155
 b.l=Random(150)+155
 color1=RGB(r,g,b)
 r.l=Random(150)+155
 g.l=Random(150)+155
 b.l=Random(150)+155
 color2=RGB(r,g,b)
 x3d_setfireColor_(fm,color1,1.0,color2,1.0)
EndProcedure

; ExecutableFormat=Windows
; Executable=D:\temp\Xtreme3D\Purebasic\fire.exe
; CPU=1
; DisableDebugger
; EOF