; Textured Lensflare Example

IncludeFile "X3D.pbi" 

Declare updateLensflare()

hwnd.l=OpenWindow(1,50,50,640,480,#PB_Window_SystemMenu,"Xtreme3D")

If hwnd=0 Or InitSprite()=0 Or InitKeyboard()=0 Or InitMouse()=0 Or InitSound()=0
End
EndIf 

ws.l=OpenWindowedScreen(WindowID(1),0,0,1,1,0,0,0)

x3d_start_(0,0,640,480,hwnd,#FALSE);
x3d_sync_(#VSYNC)
x3d_lighting_(0)
x3d_setTexturePaths_("res")
x3d_BackgroundColor_($000000)

; ************************ object sorting ********************
back.l=x3d_createObject_(#DUMMY,#NULL,""); 
front.l=x3d_createObject_(#DUMMY,#NULL,"");

; *************************** Camera **************************
d.l=x3d_createObject_(#DUMMY,#NULL,"") ; dummycube for mouselook
cam.l=x3d_createObject_(#CAMERA,d,"") ; camera is child of dummy
x3d_setCameraViewDepth_(cam,1200.0)
x3d_SetCamera_(cam); activate camera
x3d_RotateObject_(cam,0.0,180.0,0.0)
x3d_TranslateObject_(d,0.0,5.0,-20.0)

; ************************** Plane ****************************
floor.l=x3d_createObject_(#PLANE,back,"")
x3d_CreateMaterial_("mfloor","res\grass3.png",#FALSE)
x3d_setTextureScale_("mfloor",5.0,5.0)
x3d_setmaterial_(floor,"mfloor")
x3d_RotateObject_(floor,90.0,0.0,0.0);
x3d_setObjectScale_(floor,50.0,50.0,50.0)

; *************************** Lensflare *************************
x3d_CreateMaterial_("mglow","res\flame2.bmp",#TRUE)
x3d_CreateMaterial_("mo","res\bluspark.bmp",#TRUE)
x3d_CreateMaterial_("mr","res\Particle.jpg",#TRUE)
lens.l=x3d_createObject_(#TLENSFLARE,back,"")
x3d_setLensflareTextures_(lens,"mr", "mr", "mglow", "mo")
x3d_setObjectPosition_(lens,0.0,10.0,0.0)

; ************************** crosshair ************************
x3d_createMaterial_("mcross","res\crosshair09.png",1)
cross.l=x3d_createObject_(#SPRITE,front,"mcross")
x3d_setObjectPosition_(cross,320.0,240.0,0.0)


; ************************** font+text *****************************
bfont.l=x3d_createBmpFont_(31,31,2,4,1,1,32,95)
x3d_loadBmpFont_(bfont,"res\bfont.bmp")
txt.l=x3d_createObject_(#TEXT,#NULL,"PRESS SPACE")
x3d_SetTextFont_(txt, bfont)

Repeat
 EventID.l = WindowEvent()
  ExamineKeyboard();
    If KeyboardPushed(#PB_Key_Escape) ; If the user has pressed on the close button
      Quit = 1
    EndIf      
   
    If KeyboardPushed(#PB_KEY_A) 
    x3d_strafeObject_(d,-0.8)
EndIf
If KeyboardPushed(#PB_KEY_D) 
    x3d_strafeObject_(d,0.8)
EndIf
If KeyboardPushed(#PB_KEY_W) 
    x3d_moveObject_(d,0.8)
EndIf
If KeyboardPushed(#PB_KEY_S) 
    x3d_moveObject_(d,-0.8)
EndIf

If KeyboardReleased(#PB_KEY_SPACE)
  updateLensflare()   
EndIf

ExamineMouse();
Gosub mouselook

fps=x3d_render_()
SetWindowTitle(1,"FPS: "+Str(fps))
  Until Quit = 1

x3d_end_(); close 3D scene 
End 

mouselook:
dx.f=-MouseDeltaX()/8
dy.f=-MouseDeltaY()/8
x3d_rotateObject_(d,0.0,dx,0.0);
pitch.f=PeekF(x3d_pitchAngle_(cam))+dy
If pitch<89 And pitch>-89
x3d_rotateObject_(cam,dy,0.0,0.0)
EndIf
Return

Procedure updateLensflare()
Shared lens
size.l=Random(50)+1
seed.l=Random(60000)
secs.l=Random(8)+1
x3d_setTexLensflareOptions_(lens,size, seed, secs) 
EndProcedure

; ExecutableFormat=Windows
; Executable=D:\temp\Xtreme3D\Purebasic\fire.exe
; CPU=1
; DisableDebugger
; EOF