﻿--Создание и настройка окна программы
window_handle=WindowsCreate("Example: 'unicode'",WS_OVERLAPPED,WS_SYSMENU,0,32,32,1280,720,0)
WindowCenter(window_handle)
WindowSetIcon(window_handle,"Logo.ico")

--Инициализация движков программы
Init_xtreme3d("xtreme3d.dll")--Графический

--Настройка компонентов графического движка
xEngineCreate();
matlib=xMaterialLibraryCreate()
xMaterialLibraryActivate(matlib)

bgColor=cDkgray
view1=xViewerCreate(0,0,1280,720,window_handle)
xViewerSetBackgroundColor(view1,bgColor)
xViewerSetLighting(view1,True)
xViewerEnableFog(view1,True)
xViewerSetFogColor(view1,bgColor)
xViewerSetFogDistance(view1,50,100)
xViewerSetAntiAliasing(view1,aaNone)

back=xDummycubeCreate(0)
scene=xDummycubeCreate(0)
front=xDummycubeCreate(0)

camPos=xDummycubeCreate(scene)
xObjectSetPosition(camPos,0,0,10)

camera=xCameraCreate(camPos)
xObjectSetPosition(camPos,0,3,5)
xCameraSetViewDepth(camera,500)
xCameraSetFocal(camera,60)
xCameraSetNearPlaneBias(camera,0.2)
xViewerSetCamera(view1,camera)

light=xLightCreate(lsOmni,scene)
xLightSetAmbientColor(light,cGray,1.0)
xLightSetDiffuseColor(light,cWhite,1.0)
xLightSetSpecularColor(light,cWhite,1.0)
xObjectSetPosition(light,0,10,0)

xMaterialCreate('mWhite','')
xMaterialLoadTexture('mWhite','data/room/stone.png')
xMaterialSetAmbientColor('mWhite',cGray,1.0)

plane=xPlaneCreate(False,20,20,10,10,scene)
xObjectPitch(plane,90)
xObjectSetMaterial(plane,'mWhite')

mx=DisplayGetParemeter(0)/2
my=DisplayGetParemeter(1)/2
DisplayMouseSet(mx,my)

ftfont=xTTFontCreate('data/unicode/NotoSans-Regular.ttf',20)

font=xWindowsBitmapfontCreate('Arial',20,0,128)
text=xHUDTextCreate(ftfont,xTextRead('data/unicode/ut8-sample-text.txt'),front)
xHUDTextSetColor(text,cWhite,1.0)
xObjectSetPosition(text,20,100,0)

text2=xHUDTextCreate(ftfont,'Xtreme3D 3.5',front)
xHUDTextSetColor(text2,cYellow,0.7)
xObjectSetPosition(text2,20,20,0)

flatt=xFlatTextCreate(ftfont,xTextConvertANSIToUTF8('������!'),scene)
xObjectSetScale(flatt,0.05,0.05,0.05)
xObjectSetPosition(flatt,-5,2,0)

Run=true
while WindowsExists(window_handle) and Run do
	WindowsRefresh()
	KeyRefresh()
	fps=CallFps(60)
	dt=1/fps
	
	xUpdate(dt)
	xViewerRender(view1)
	
	deltax=(mx-DisplayMouseGet(0))/3
	deltay=(my-DisplayMouseGet(1))/3
	xObjectRotate(camera,deltay,0,0)
	xObjectRotate(camPos,0,-deltax,0)
	DisplayMouseSet(mx,my)
	
	if Key(string.byte('W')) then xObjectMove(camPos,-10*dt) end
	if Key(string.byte('A')) then xObjectStrafe(camPos,10*dt) end
	if Key(string.byte('D')) then xObjectStrafe(camPos,-10*dt) end
	if Key(string.byte('S')) then xObjectMove(camPos,10*dt) end
	
	framerate=math.floor(xViewerGetFramesPerSecond(view1))
	xHUDTextSetText(text2,'Xtreme3D 3.5'..string.char(13)..'FPS: '..framerate)
	
	if KeyReleased(VK_ESCAPE) then Run=false end
end

--EngineDestroy()