--    
window_handle = WindowsCreate("Example: 'thirdperson'",WS_OVERLAPPED,WS_SYSMENU,0,32,32,1280,720,0)
WindowCenter(window_handle)
WindowSetIcon(window_handle,"Logo.ico")

--  
Init_xtreme3d("xtreme3d.dll") --

xEngineCreate()

matlib=xMaterialLibraryCreate()
xMaterialLibraryActivate(matlib)

bgColor = RGB(177, 215, 252)
view1=xViewerCreate(0,0,1280,720,window_handle)
xViewerSetBackgroundColor(view1,bgColor)
xViewerSetLighting(view1,1)
xViewerEnableFog(view1,1)
xViewerSetFogColor(view1,bgColor)
xViewerSetFogDistance(view1,100,200)
xViewerSetAntiAliasing(view1, aa4xHQ)
xViewerSetAutoRender(view1, False)
rendering = True

back=xDummycubeCreate(0)
scene=xDummycubeCreate(0)
postscene=xDummycubeCreate(0)
front=xDummycubeCreate(0)

shadowCasters = xDummycubeCreate(scene)

actorPivot = xDummycubeCreate(shadowCasters)
xObjectSetPosition(actorPivot,0,0.5,0)
moving = False

camera = xCameraCreate(scene)
xCameraSetViewDepth(camera, 800)
xCameraSetFocal(camera, 80)
xViewerSetCamera(view1, camera)

actor = xCubeCreate(1, 1, 1, actorPivot)

target = xDummycubeCreate(actor)
xObjectSetPosition(target, 0, 1, -4)
xCameraSetTargetObject(camera, actor)

light=xLightCreate(lsOmni, scene)
xLightSetDiffuseColor(light,cWhite, 1.0)
xObjectSetPosition(light,0,5,0)

xMaterialCreate("mStone", "data/room/stone.png")
plane = xShadowplaneCreate(15, 15, 3, 3, shadowCasters, light, cBlack, 0.7, scene) 
xObjectPitch(plane, 90)
xObjectSetMaterial(plane, "mStone")

mx=DisplayGetParemeter(0)/2
my=DisplayGetParemeter(1)/2
DisplayMouseSet(mx,my)

font=xWindowsBitmapfontCreate("Arial",20,0,128)
text=xHUDTextCreate(font,"Xtreme3D 3.5"..string.char(13).."FPS: ",front)
xHUDTextSetColor(text,cBlack,0.5)
xObjectSetPosition(text,16,16,0)

paused=0
pressed_end=0

Run = true
while WindowsExists(window_handle) and Run do
	WindowsRefresh()
	KeyRefresh()
	Sleep(1)
	if KeyReleased(VK_ESCAPE) then Run = false end
	
	xUpdate(dt)
	xViewerRender(view1)
	
	framerate=math.floor(xViewerGetFramesPerSecond(view1))
	dt = 1/framerate
	
	if paused == 0 then
		if Key(VK_UP) then xObjectMove(actorPivot, 10 * dt) end
		if Key(VK_DOWN) then xObjectMove(actorPivot, -10 * dt) end
		if Key(VK_LEFT) then xObjectTurn(actorPivot, -200 * dt) end
		if Key(VK_RIGHT) then xObjectTurn(actorPivot, 200 * dt) end
	end
	
	cx = xObjectGetAbsolutePosition(camera, 0)
	cy = xObjectGetAbsolutePosition(camera, 1)
	cz = xObjectGetAbsolutePosition(camera, 2)
	tx = xObjectGetAbsolutePosition(target, 0)
	ty = xObjectGetAbsolutePosition(target, 1)
	tz = xObjectGetAbsolutePosition(target, 2)
	dx = tx - cx
	dy = ty - cy
	dz = tz - cz
	xObjectTranslate(camera, dx * 0.05, dy * 0.05, dz * 0.05)
	
	xHUDTextSetText(text,'Xtreme3D 3.5'..string.char(13).."FPS: "..framerate)
end