--    
window_handle = WindowsCreate("Example: 'shadows'",WS_OVERLAPPED,WS_SYSMENU,0,32,32,1280,720,0)
WindowCenter(window_handle)
WindowSetIcon(window_handle,"Logo.ico")

--  
Init_xtreme3d("xtreme3d.dll") --

--   
xEngineCreate()

matlib=xMaterialLibraryCreate()
xMaterialLibraryActivate(matlib)

bgColor=RGB(142,200,232)
view1=xViewerCreate(0,0,1280,720,window_handle)
xViewerSetBackgroundColor(view1,bgColor)
xViewerSetLighting(view1,1)
xViewerEnableFog(view1,1)
xViewerSetFogColor(view1,bgColor)
xViewerSetFogDistance(view1,50,100)
xViewerSetAntiAliasing(view1,aa4xHQ)
rendering=True

back=xDummycubeCreate(0)
scene=xDummycubeCreate(0)
front=xDummycubeCreate(0)

camPos=xDummycubeCreate(scene)
xObjectSetPosition(camPos,0,0,10)
moving=False

camera=xCameraCreate(camPos)
xObjectSetPosition(camPos,0,2,0)
xCameraSetViewDepth(camera,500)
xCameraSetFocal(camera,80)
xCameraSetNearPlaneBias(camera,0.2)
xViewerSetCamera(view1,camera)

cub1=xCubeCreate(1,1,1,scene)
xObjectSetPosition(cub1,0,0,0)

tree=xTreeCreate(scene)
xMaterialCreate('mleaf','data/tree/leaf.tga')
xMaterialSetBlendingMode('mleaf',bmTransparency)
xMaterialSetTextureFilter('mleaf',miNearest,maLinear)
xMaterialSetAmbientColor('mleaf',c_gray)
xMaterialCreate('mbranch','data/tree/bark.jpg')
xMaterialSetAmbientColor('mbranch',c_gray)
xTreeSetMaterials(tree,'mleaf','mleaf','mbranch')
xTreeSetLeafSize(tree,0.2)
xObjectSetPosition(tree,-8,-1,10)
xObjectPitch(tree,90)
xObjectSetScale(tree,2,2,2)

xMaterialCreate('mGround','data/b3d/ground.jpg')

center=xDummycubeCreate(scene)

shadowCam=xCameraCreate(scene)
xCameraSetViewDepth(shadowCam,100)
xObjectSetPosition(shadowCam,0,20,0)
xObjectPitch(shadowCam,-45)
xObjectTurn(shadowCam,30)
shadowRes=1024
sm=xShadowMapCreate(shadowRes,view1,scene)
xShadowMapSetCamera(sm,shadowCam)
xShadowMapSetProjectionSize(sm,30)
xShadowMapSetZClippingPlanes(sm,-50.0,100.0)

vp1=xTextRead('data/shaders/shadow/shadow-vp.glsl')
fp1=xTextRead('data/shaders/shadow/shadow-fp.glsl')
depthShader=xGLSLShaderCreate(vp1,fp1)
paramShadowMap=xGLSLShaderCreateParameter(depthShader,'shadowMap')
xGLSLShaderSetParameterShadowTexture(paramShadowMap,sm,7)
paramShadowMatrix=xGLSLShaderCreateParameter(depthShader,'shadowMatrix')
xGLSLShaderSetParameterShadowMatrix(paramShadowMatrix,sm)
paramTexture=xGLSLShaderCreateParameter(depthShader,'diffuseMap')
xGLSLShaderSetParameterTexture(paramTexture,'',0)
paramShadowMapSize=xGLSLShaderCreateParameter(depthShader,'shadowMapSize')
xGLSLShaderSetParameter1f(paramShadowMapSize,shadowRes)

--nCube=xCubeCreate(1,1,1,scene)
--xObjectSetPosition(nCube,0,2,0)

light=xLightCreate(lsParallel,scene)
xLightSetAmbientColor(light,cGray,1.0)
xLightSetDiffuseColor(light,cWhite,1.0)
xLightSetSpecularColor(light,cWhite,1.0)
xObjectPitch(light,-90-45)
xObjectTurn(light,-30)
xObjectSetPosition(light,0,5,2)

xMaterialCreate('mSkyTop','data/sky/sky_top.tga')
xMaterialCreate('mSkyBottom','data/sky/sky_bottom.tga')
xMaterialCreate('mSkyLeft','data/sky/sky_left.tga')
xMaterialCreate('mSkyRight','data/sky/sky_right.tga')
xMaterialCreate('mSkyFront','data/sky/sky_front.tga')
xMaterialCreate('mSkyBack','data/sky/sky_back.tga')
sky=xSkyboxCreate(back)
xSkyboxSetMaterial(sky,sbmTop,'mSkyTop')
xSkyboxSetMaterial(sky,sbmBottom,'mSkyBottom')
xSkyboxSetMaterial(sky,sbmLeft,'mSkyLeft')
xSkyboxSetMaterial(sky,sbmRight,'mSkyRight')
xSkyboxSetMaterial(sky,sbmFront,'mSkyFront')
xSkyboxSetMaterial(sky,sbmBack,'mSkyBack')

sceneObjects=xDummycubeCreate(scene)
xObjectSetPosition(sceneObjects,0,0,0)

levelMlib=xMaterialLibraryCreate()
levelLMMlib=xMaterialLibraryCreate()
xMaterialLibrarySetTexturePaths(levelMlib,'data/b3d')
xMaterialLibrarySetTexturePaths(levelLMMlib,'data/b3d')
ffm1=xFreeformCreate('data/b3d/level.b3d',levelMlib,levelMlib,scene)
xObjectSetPosition(ffm1,0,-0.5,0)
levelPivot=xDummycubeCreate(scene)
xObjectSetPosition(levelPivot,0,-0.5,0)
xFreeformToFreeforms(ffm1,levelPivot)
xObjectHide(ffm1)
xMaterialLibraryActivate(levelMlib)

mCount=xObjectGetChildCount(levelPivot)-1
for i=0, mCount do
	ch=xObjectGetChild(levelPivot,i)
	mat=xFreeformMeshFaceGroupGetMaterial(ch,0,0)
	xFreeformUseMeshMaterials(ch,False)
	mName='mShadow_'..i
	xMaterialCreate(mName,'')
	xMaterialSetTexture(mName,mat)
	xMaterialSetShader(mName,depthShader)
	xObjectSetMaterial(ch,mName)
end

xMaterialLibraryActivate(matlib)

matlib2=xMaterialLibraryCreate()
xMaterialLibrarySetTexturePaths(matlib2,'data/bob')
bob=xActorCreate('data/bob/bob.md5mesh',matlib2,scene)
xActorAddObject(bob,'data/bob/bob.md5anim')
xObjectSetPosition(bob,8,-0.5,10)
xObjectSetScale(bob,0.5,0.5,0.5)
xActorSetAnimationRange(bob,1,141)
xMaterialLibraryActivate(matlib2)
xMaterialCreate('mShadow','')
xMaterialSetShader('mShadow',depthShader)
xObjectSetMaterial(bob,'mShadow')
xMaterialLibraryActivate(matlib2)

mx=DisplayGetParemeter(0)/2
my=DisplayGetParemeter(1)/2
DisplayMouseSet(mx,my)

font=xWindowsBitmapfontCreate('Arial',20,0,128)
text=xHUDTextCreate(font,'Xtreme3D 3.5'..string.char(13)..'FPS:',front)
xHUDTextSetColor(text,cWhite,0.5)
xObjectSetPosition(text,16,16,0)

paused = 0
pressed_end = 0
screenNum = 0

Run = true
while WindowsExists(window_handle) and Run do
	WindowsRefresh()
	KeyRefresh()
	fps = CallFps(60)
	dt = 1/fps
	
	moving = false

	if paused == 0 then
		deltax=(mx-DisplayMouseGet(0))/3
		deltay=(my-DisplayMouseGet(1))/3
		xObjectRotate(camera,deltay,0,0)
		xObjectRotate(camPos,0,-deltax,0)
		DisplayMouseSet(mx,my)
		
		if Key(string.byte('W')) then xObjectMove(camPos,-10*dt) end
		if Key(string.byte('A')) then xObjectStrafe(camPos,10*dt) end
		if Key(string.byte('D')) then xObjectStrafe(camPos,-10*dt) end
		if Key(string.byte('S')) then xObjectMove(camPos,10*dt) end
	end
	
	xObjectSetPosition(shadowCam,xObjectGetAbsolutePosition(camPos, 0),10,xObjectGetAbsolutePosition(camPos, 2) + 10)
	
	framerate=math.floor(xViewerGetFramesPerSecond(view1))
	xHUDTextSetText(text,'Xtreme3D 3.5'..string.char(13)..'FPS: '..framerate)

	xUpdate(dt)
	
	xObjectHide(front)
	xShadowMapRender(sm)
	xObjectShow(front)
	
	xGLSLShaderSetParameterShadowMatrix(paramShadowMatrix,sm)
	xViewerRender(view1)
	
	if KeyReleased(VK_ESCAPE) then Run = false end
	
	if KeyReleased(VK_F12) then --  
		screenNum = screenNum + 1
		saved = false
		while not saved do
			str = 'screenshots/screenshot'..screenNum..'.bmp'
			if not FileExists(str) then
				xViewerRenderToFile(view1, str)
				saved = true
			else screenNum = screenNum + 1 end
		end
	end
end

--EngineDestroy()