--    
window_handle = WindowsCreate("Example: 'sea-water'",WS_OVERLAPPED,WS_SYSMENU,0,32,32,1280,720,0)
WindowCenter(window_handle)
WindowSetIcon(window_handle,"Logo.ico")

--  
Init_xtreme3d("xtreme3d.dll") --

--   
xEngineCreate()

matlib=xMaterialLibraryCreate()
xMaterialLibraryActivate(matlib)

bgColor = RGB(142, 200, 232)
view1 = xViewerCreate(0, 0, 1280, 720, window_handle)
xViewerSetBackgroundColor(view1, bgColor)
xViewerSetLighting(view1, True)
xViewerEnableFog(view1, True)
xViewerSetFogColor(view1, bgColor)
xViewerSetFogDistance(view1, 50, 100)
xViewerSetAntiAliasing(view1, aa4xHQ)

back=xDummycubeCreate(0)
scene=xDummycubeCreate(0)
front=xDummycubeCreate(0)

camPos=xDummycubeCreate(scene)
xObjectSetPosition(camPos,0,0,10)
moving = False

camera=xCameraCreate(camPos)
xObjectSetPosition(camPos,0,2,0)
xCameraSetViewDepth(camera,500)
xCameraSetFocal(camera, 80)
xCameraSetNearPlaneBias(camera, 0.2)
xViewerSetCamera(view1,camera)

cube1 = xCubeCreate(5, 5, 5, scene)
xObjectSetPosition(cube1, 0, 2.5, 10)

sph1 = xSphereCreate(2.5, 16, 16, scene)
xObjectSetPosition(sph1, -10, 2.5, 10)

light=xLightCreate(lsOmni, scene)
xLightSetAmbientColor(light,cGray, 1.0)
xLightSetDiffuseColor(light,cWhite, 1.0)
xLightSetSpecularColor(light,cWhite, 1.0)
xObjectSetPosition(light,0,10,-10)

xMaterialCreate('mSkyTop','data/sky/sky_top.tga')
xMaterialCreate('mSkyBottom','data/sky/sky_bottom.tga')
xMaterialCreate('mSkyLeft','data/sky/sky_left.tga')
xMaterialCreate('mSkyRight','data/sky/sky_right.tga')
xMaterialCreate('mSkyFront','data/sky/sky_front.tga')
xMaterialCreate('mSkyBack','data/sky/sky_back.tga')
sky=xSkyboxCreate(back)
xSkyboxSetMaterial(sky, sbmTop, 'mSkyTop')
xSkyboxSetMaterial(sky, sbmBottom, 'mSkyBottom')
xSkyboxSetMaterial(sky, sbmLeft, 'mSkyLeft')
xSkyboxSetMaterial(sky, sbmRight, 'mSkyRight')
xSkyboxSetMaterial(sky, sbmFront, 'mSkyFront')
xSkyboxSetMaterial(sky, sbmBack, 'mSkyBack')

water = xPlaneCreate(0, 200, 200, 100, 100, scene) 
xObjectPitch(water, 90)

xMaterialAddCubeMap('mWaterCubemap')
xMaterialCubeMapGenerate('mWaterCubemap', 128)

xMaterialCreate('mWaterNormal1','data/water/water-norm-001.tga')
xMaterialCreate('mWaterNormal2','data/water/water-norm-002.tga')

cubemapCam = xCameraCreate(scene)

xMaterialCreate('mWaterShader','')
xMaterialSetShininess('mWaterShader',32)
xMaterialSetAmbientColor('mWaterShader', cGray, 1)
xMaterialSetDiffuseColor('mWaterShader', cWhite, 1)
xMaterialSetSpecularColor('mWaterShader', cGray, 1)
xMaterialSetShininess('mWaterShader', 96)
xMaterialSetBlendingMode('mWaterShader', bmTransparency)

if xViewerGetGLSLSupported(view1) then
	vp = xTextRead('data/shaders/water/sea-water-vp.glsl')
    fp = xTextRead('data/shaders/water/sea-water-fp.glsl')
    glslShader=xGLSLShaderCreate(vp, fp)

    texture0 = xGLSLShaderCreateParameter(glslShader, 'texture0')
    xGLSLShaderSetParameterTexture(texture0, 'mWaterCubemap', 0)
    
    texture1 = xGLSLShaderCreateParameter(glslShader, 'texture1')
    xGLSLShaderSetParameterTexture(texture1, 'mWaterNormal1', 1)
    
    texture2 = xGLSLShaderCreateParameter(glslShader, 'texture2')
    xGLSLShaderSetParameterTexture(texture2, 'mWaterNormal2', 2)
    
    invViewMatrix = xGLSLShaderCreateParameter(glslShader, 'invViewMatrix')
    xGLSLShaderSetParameterMatrix(invViewMatrix, camera)
    
    viewMatrix = xGLSLShaderCreateParameter(glslShader, 'viewMatrix')
    xGLSLShaderSetParameterInvMatrix(viewMatrix, camera)
    
    scrollTime = xGLSLShaderCreateParameter(glslShader, 'scrollTime')
    xGLSLShaderSetParameter1f(scrollTime, 0)
    scrollTimeValue = 0

    xMaterialSetShader('mWaterShader',glslShader)
end

xObjectSetMaterial(water,'mWaterShader')

mx=DisplayGetParemeter(0)/2
my=DisplayGetParemeter(1)/2
DisplayMouseSet(mx,my)

font=xWindowsBitmapfontCreate('Arial',20,0,128)
text=xHUDTextCreate(font,'Xtreme3D 3.5'..string.char(13)..'FPS: ',front)
xHUDTextSetColor(text,cWhite,0.5)
xObjectSetPosition(text,20,20,0)

while WindowsExists(window_handle) do
	WindowsRefresh()
	KeyRefresh()
	fps = CallFps(60)
	dt = 1/fps
	
	deltax=(mx-DisplayMouseGet(0))/3
	deltay=(my-DisplayMouseGet(1))/3
	xObjectRotate(camera,deltay,0,0)
	xObjectRotate(camPos,0,-deltax,0)
	DisplayMouseSet(mx,my)
	
	if Key(string.byte('W')) then xObjectMove(camPos,-10*dt) end
	if Key(string.byte('A')) then xObjectStrafe(camPos,10*dt) end
	if Key(string.byte('D')) then xObjectStrafe(camPos,-10*dt) end
	if Key(string.byte('S')) then xObjectMove(camPos,10*dt) end
	
	camPosX = xObjectGetAbsolutePosition(camera, 0)
	camPosY = xObjectGetAbsolutePosition(camera, 1)
	camPosZ = xObjectGetAbsolutePosition(camera, 2)
	xObjectSetPosition(cubemapCam, camPosX, -camPosY, camPosZ)
	
	xGLSLShaderSetParameterMatrix(invViewMatrix, camera)
	xGLSLShaderSetParameterInvMatrix(viewMatrix, camera)
	scrollTimeValue = scrollTimeValue + 1/60
	xGLSLShaderSetParameter1f(scrollTime, scrollTimeValue)
	
	framerate=math.floor(xViewerGetFramesPerSecond(view1))
	xHUDTextSetText(text,'Xtreme3D 3.5'..string.char(13)..'FPS: '..framerate)
	
	xUpdate(dt)

	--Render the cubemap
	xObjectHide(front)
	xObjectHide(water)
	xMaterialCubeMapFromScene('mWaterCubemap', view1, cubemapCam, 128)
	xObjectShow(water)
	xObjectShow(front)
	
	xViewerRender(view1)
	
	if KeyReleased(VK_ESCAPE) then WindowsDestroy(window_handle) end
	
	if KeyReleased(VK_F12) then --  
		screenNum = screenNum + 1
		saved = false
		while not saved do
			str = 'screenshots/screenshot'..screenNum..'.bmp'
			if not FileExists(str) then
				xViewerRenderToFile(view1, str)
				saved = true
			else screenNum = screenNum + 1 end
		end
	end
end

--EngineDestroy()