--    
window_handle = WindowsCreate("Example: 'physics'",WS_OVERLAPPED,WS_SYSMENU,0,32,32,1280,720,0)
WindowCenter(window_handle)
WindowSetIcon(window_handle,"Logo.ico")

--  
Init_xtreme3d("xtreme3d.dll") --

--   
xEngineCreate()

matlib=xMaterialLibraryCreate()
xMaterialLibraryActivate(matlib)

bgColor = RGB(142, 200, 232)
view1=xViewerCreate(0,0,1280,720,window_handle)
xViewerSetBackgroundColor(view1,bgColor)
xViewerSetLighting(view1,1)
xViewerEnableFog(view1,1)
xViewerSetFogColor(view1,bgColor)
xViewerSetFogDistance(view1,50,100)
xViewerSetAntiAliasing(view1, aa4xHQ)
xViewerSetAutoRender(view1, False)
rendering = True

back=xDummycubeCreate(0)
scene=xDummycubeCreate(0)
front=xDummycubeCreate(0)

xOdeManagerCreate()
xOdeManagerSetGravity(0, -1, 0)
--OdeManagerSetVisible(true)
--OdeManagerSetGeomColor(c_white)

tab = xDummycubeCreate(scene)
table_part1 = xCubeCreate(2, 0.25, 2, tab)
table_part2 = xCubeCreate(0.25, 1.5, 0.25, tab)
xObjectSetPosition(table_part2, 0.875, -0.75, 0.875)
table_part3 = xCubeCreate(0.25, 1.5, 0.25, tab)
xObjectSetPosition(table_part3, -0.875, -0.75, 0.875)
table_part4 = xCubeCreate(0.25, 1.5, 0.25, tab)
xObjectSetPosition(table_part4, -0.875, -0.75, -0.875)
table_part5 = xCubeCreate(0.25, 1.5, 0.25, tab)
xObjectSetPosition(table_part5, 0.875, -0.75, -0.875)
xObjectSetPosition(tab, 0, 16, 0)
xOdeDynamicCreate(tab)
xOdeAddBox(tab, 0, 0, 0, 2, 0.25, 2)
xOdeAddBox(tab, 0.875, -0.75, 0.875, 0.25, 1.5, 0.25)
xOdeAddBox(tab, -0.875, -0.75, 0.875, 0.25, 1.5, 0.25)
xOdeAddBox(tab, -0.875, -0.75, -0.875, 0.25, 1.5, 0.25)
xOdeAddBox(tab, 0.875, -0.75, -0.875, 0.25, 1.5, 0.25)
xMaterialCreate('mOrange', '')
xMaterialSetAmbientColor('mOrange', cOlive, 1.0)
xMaterialSetDiffuseColor('mOrange', cOlive, 1.0)
xObjectSetMaterial(table_part1, 'mOrange')
xObjectSetMaterial(table_part2, 'mOrange')
xObjectSetMaterial(table_part3, 'mOrange')
xObjectSetMaterial(table_part4, 'mOrange')
xObjectSetMaterial(table_part5, 'mOrange')

cub1 = xCubeCreate(1, 1, 1, scene)
xObjectSetPosition(cub1, 0, 20, 0)
xOdeDynamicCreate(cub1)
b = xOdeAddBox(cub1, 0, 0, 0, 1, 1, 1)
xOdeDynamicCalculateMass(cub1)
xMaterialCreate('mRed', '')
xMaterialSetAmbientColor('mRed', cRed, 1.0)
xMaterialSetDiffuseColor('mRed', cRed, 1.0)
xObjectSetMaterial(cub1, 'mRed')

cub2 = xCubeCreate(1, 1, 1, scene)
xObjectSetPosition(cub2, 0.3, 23, 0)
xOdeDynamicCreate(cub2)
xOdeAddBox(cub2, 0, 0, 0, 1, 1, 1)
xMaterialCreate('mYellow', '')
xMaterialSetAmbientColor('mYellow', cYellow, 1.0)
xMaterialSetDiffuseColor('mYellow', cYellow, 1.0)
xObjectSetMaterial(cub2, 'mYellow')

cub4 = xCubeCreate(1, 1, 1, scene)
xObjectSetPosition(cub4, 0, 24, 0)
xOdeDynamicCreate(cub4)
xOdeAddBox(cub4, 0, 0, 0, 1, 1, 1)
xMaterialCreate('mGreen', '')
xMaterialSetAmbientColor('mGreen', cGreen, 1.0)
xMaterialSetDiffuseColor('mGreen', cGreen, 1.0)
xObjectSetMaterial(cub4, 'mGreen')

plane = xPlaneCreate(0, 20, 20, 10, 10, scene)
xObjectPitch(plane, 90)
xOdeStaticCreate(plane)
xOdeAddPlane(plane)
xMaterialCreate('mGround', 'data/b3d/ground.jpg')
xObjectSetMaterial(plane, 'mGround')

camPos=xDummycubeCreate(scene)
xObjectSetPosition(camPos,0,2,5)
moving = False

camera=xCameraCreate(camPos)
xCameraSetViewDepth(camera,500)
xCameraSetFocal(camera, 80)
xCameraSetNearPlaneBias(camera, 0.2)
xViewerSetCamera(view1,camera)

light=xLightCreate(lsParallel, scene)
xLightSetAmbientColor(light,cGray, 1.0)
xLightSetDiffuseColor(light,cWhite, 1.0)
xLightSetSpecularColor(light,cWhite, 1.0)
xObjectPitch(light, -90 - 45)
xObjectSetPosition(light,0,5,2)

mx=DisplayGetParemeter(0)/2
my=DisplayGetParemeter(1)/2
DisplayMouseSet(mx,my)

font=xWindowsBitmapfontCreate('Arial',20,0,128)
text=xHUDTextCreate(font,'Xtreme3D 3.5'..string.char(13)..'FPS: ',front)
xHUDTextSetColor(text,cWhite,0.5)
xObjectSetPosition(text,20,20,0)

paused=0
pressed_end=0

while WindowsExists(window_handle) do
	WindowsRefresh()
	KeyRefresh()
	fps = CallFps(120)
	dt = 1/fps
	
	if paused == 0 then
		deltax=(mx-DisplayMouseGet(0))/3
		deltay=(my-DisplayMouseGet(1))/3
		xObjectRotate(camera,deltay,0,0)
		xObjectRotate(camPos,0,-deltax,0)
		DisplayMouseSet(mx,my)
		
		if Key(string.byte('W')) then xObjectMove(camPos,-10*dt) end
		if Key(string.byte('A')) then xObjectStrafe(camPos,10*dt) end
		if Key(string.byte('D')) then xObjectStrafe(camPos,-10*dt) end
		if Key(string.byte('S')) then xObjectMove(camPos,10*dt) end
	end
	
	throwForce = 400.0
	if KeyPressed(1) then
		newCube = xCubeCreate(0.25, 0.25, 0.25, scene)
		xObjectSetPosition(newCube, 
			xObjectGetAbsolutePosition(camera, 0), 
			xObjectGetAbsolutePosition(camera, 1), 
			xObjectGetAbsolutePosition(camera, 2))
		xOdeDynamicCreate(newCube)
		xOdeSurfaceSetBounce(newCube, 0.01)
		sp = xOdeAddBox(newCube, 0, 0, 0, 0.25, 0.25, 0.25)
		xOdeDynamicAddForce(newCube,
			xObjectGetAbsoluteDirection(camera, 0) * throwForce,
			xObjectGetAbsoluteDirection(camera, 1) * throwForce,
			xObjectGetAbsoluteDirection(camera, 2) * throwForce)
	end
	
	framerate=math.floor(xViewerGetFramesPerSecond(view1))
	xHUDTextSetText(text,'Xtreme3D 3.5'..string.char(13)..'FPS: '..framerate)
	
	xOdeManagerStep(1/60)
	xUpdate(dt)
	
	xViewerRender(view1)
	
	if KeyReleased(VK_ESCAPE) then WindowsDestroy(window_handle) end
	
	if KeyReleased(VK_F12) then --  
		screenNum = screenNum + 1
		saved = false
		while not saved do
			str = 'screenshots/screenshot'..screenNum..'.bmp'
			if not FileExists(str) then
				xViewerRenderToFile(view1, str)
				saved = true
			else screenNum = screenNum + 1 end
		end
	end
end

--EngineDestroy()