--    
window_handle = WindowsCreate("Example: 'forest'",WS_OVERLAPPED,WS_SYSMENU,0,32,32,1280,720,0)
WindowCenter(window_handle)
WindowSetIcon(window_handle,"Logo.ico")

--  
Init_xtreme3d("xtreme3d.dll") --

--   
xEngineCreate()

matlib=xMaterialLibraryCreate()
xMaterialLibraryActivate(matlib)

bgColor = RGB(177, 215, 252)
view1=xViewerCreate(0,0,1280,720,window_handle)
xViewerSetBackgroundColor(view1,bgColor)
xViewerSetLighting(view1,1)
xViewerEnableFog(view1,1)
xViewerSetFogColor(view1,bgColor)
xViewerSetFogDistance(view1,100,200)
xViewerSetAntiAliasing(view1, aa4xHQ)
xViewerSetAutoRender(view1, False)
rendering = True

back=xDummycubeCreate(0)
scene=xDummycubeCreate(0)
postscene=xDummycubeCreate(0)
front=xDummycubeCreate(0)

camPos=xDummycubeCreate(scene)
xObjectSetPosition(camPos,20,2,-20)
moving = False

camera=xCameraCreate(camPos)
xCameraSetViewDepth(camera,500)
xCameraSetFocal(camera, 80)
xCameraSetNearPlaneBias(camera, 0.2)
xViewerSetCamera(view1,camera)

hds=xBmpHDSCreate('data/terrain/heightmap.bmp')
xBmpHDSSetInfiniteWarp(hds,0)
terrain=xTerrainCreate(scene)
xTerrainSetHeightData(terrain, hds)
xTerrainSetTileSize(terrain, 32)
xTerrainSetTilesPerTexture(terrain, 8)
xTerrainSetQualityDistance(terrain, 100)
xTerrainSetQualityStyle(terrain, hrsFullGeometry)
xTerrainSetMaxCLodTriangles(terrain, 10000)
xTerrainSetCLodPrecision(terrain, 50)
xTerrainSetOcclusionFrameSkip(terrain, 0)
xTerrainSetOcclusionTesselate(terrain, totTesselateIfVisible)
xObjectSetScale(terrain, 1, 1, 0.1)
xObjectRotate(terrain,90,0,0)
xMaterialCreate('mTerrain','data/terrain/autumn.jpg')
xMaterialSetOptions('mTerrain', False, True)
xMaterialCreate('detmap','data/terrain/detmap.jpg')
xMaterialSetTextureScale('detmap', 100, 100)
xMaterialSetSecondTexture('mTerrain','detmap')
xObjectSetMaterial(terrain,'mTerrain')

tree = xTreeCreate(scene)
xMaterialCreate('mleaf','data/tree/leaf.tga')
xMaterialSetBlendingMode('mleaf', bmTransparency)
xMaterialSetTextureFilter('mleaf', miNearest, maLinear)
xMaterialSetAmbientColor('mleaf', cGray)
xMaterialCreate('mbranch','data/tree/bark.jpg')
xMaterialSetAmbientColor('mbranch', cGray)
xTreeSetMaterials(tree,'mleaf','mleaf','mbranch')
xTreeSetLeafSize(tree, 0.2)
xObjectPitch(tree, 90)
xObjectSetScale(tree, 3, 3, 3)
xObjectHide(tree)

treeMesh = xTreeBuildMesh(tree, scene)
xObjectPitch(treeMesh, 90)
xObjectHide(treeMesh)

xMaterialCreate('mSprite','data/tree/tree-sprite.tga')
xMaterialSetBlendingMode('mSprite', bmTransparency)
xMaterialSetTextureFilter('mSprite', miNearest, maLinear)
xMaterialSetAmbientColor('mSprite', c_gray)
xMaterialSetOptions('mSprite', False, True)
treeSprite = xSpriteCreate('mSprite', 4, 4, scene)
xObjectSetPosition(treeSprite, 0, 2, 0)
xObjectHide(treeSprite)

treeProxies = xDummycubeCreate(scene)
regionX = 0
regionZ = -250
regionW = 250
regionH = 250
numTrees = 5000

for i=0,numTrees-1 do
	treeProxy = xMultiProxyObjectCreate(treeProxies)
	xMultiProxyObjectAddTarget(treeProxy, treeMesh, 0, 30)
	xMultiProxyObjectAddTarget(treeProxy, treeSprite, 30, 200)
	xObjectSetPosition(treeProxy, regionX + math.random(regionW), 0, regionZ + math.random(regionH))
	xObjectTurn(treeProxy, math.random(360))
	xObjectSetPositionY(treeProxy, xTerrainGetHeightAtObjectPosition(terrain, treeProxy))
end

light=xLightCreate(lsParallel, scene)
xLightSetAmbientColor(light,cGray, 1.0)
xLightSetDiffuseColor(light,cWhite, 1.0)
xLightSetSpecularColor(light,cWhite, 1.0)
xObjectPitch(light, -90 - 45)
xObjectSetPosition(light,0,5,2)

mx=DisplayGetParemeter(0)/2
my=DisplayGetParemeter(1)/2
DisplayMouseSet(mx,my)

font=xWindowsBitmapfontCreate('Arial',20,0,128)
text=xHUDTextCreate(font,'Xtreme3D 3.5'..string.char(13)..'FPS: ',front)
xHUDTextSetColor(text,cWhite,0.5)
xObjectSetPosition(text,20,20,0)

paused=0
pressed_end=0
screenNum = 0

while WindowsExists(window_handle) do
	WindowsRefresh()
	KeyRefresh()
	--fps = CallFps(1000)
	--dt = 1/fps
	Sleep(1) --  
	
	framerate=math.floor(xViewerGetFramesPerSecond(view1))
	dt = 1/framerate
	xHUDTextSetText(text,'Xtreme3D 3.5'..string.char(13)..'FPS: '..framerate)

	if paused == 0 then
		deltax=(mx-DisplayMouseGet(0))/3
		deltay=(my-DisplayMouseGet(1))/3
		xObjectRotate(camera,deltay,0,0)
		xObjectRotate(camPos,0,-deltax,0)
		DisplayMouseSet(mx,my)
		
		if Key(string.byte('W')) then xObjectMove(camPos,-10*dt) end
		if Key(string.byte('A')) then xObjectStrafe(camPos,10*dt) end
		if Key(string.byte('D')) then xObjectStrafe(camPos,-10*dt) end
		if Key(string.byte('S')) then xObjectMove(camPos,10*dt) end
		
		xObjectSetPositionY(camPos, xTerrainGetHeightAtObjectPosition(terrain, camPos) + 2)
	end
	
	xUpdate(dt)
	xViewerRender(view1)
	
	if KeyReleased(VK_ESCAPE) then WindowsDestroy(window_handle) end
	
	if KeyReleased(VK_F12) then --  
		screenNum = screenNum + 1
		saved = false
		while not saved do
			str = 'screenshots/screenshot'..screenNum..'.bmp'
			if not FileExists(str) then
				xViewerRenderToFile(view1, str)
				saved = true
			else screenNum = screenNum + 1 end
		end
	end
end

--EngineDestroy()