--Создание и настройка окна программы
window_handle = WindowsCreate("Example: 'fire'",WS_OVERLAPPED,WS_SYSMENU,0,32,32,1280,720,0)
WindowCenter(window_handle)
WindowSetIcon(window_handle,"Logo.ico")

--Инициализация движков программы
Init_xtreme3d("xtreme3d.dll") --Графический
Init_gmsquall("gmsquall.dll") --Звуковой

--Настройка компонентов графического движка
xEngineCreate()

matlib=xMaterialLibraryCreate()
xMaterialLibraryActivate(matlib)

bgColor = RGB(64, 64, 64)
view1 = xViewerCreate(0, 0, 1280, 720, window_handle)
xViewerSetBackgroundColor(view1, bgColor)
xViewerSetLighting(view1, True)
xViewerEnableFog(view1, True)
xViewerSetFogColor(view1, bgColor)
xViewerSetFogDistance(view1, 50, 100)

back=xDummycubeCreate(0)
scene=xDummycubeCreate(0)
front=xDummycubeCreate(0)

camPos=xDummycubeCreate(scene)
xObjectSetPosition(camPos,0,1,3)

camera=xCameraCreate(camPos)
xCameraSetViewDepth(camera,500)
xCameraSetFocal(camera, 80)
xViewerSetCamera(view1,camera)

light=xLightCreate(lsOmni, scene)
xLightSetAmbientColor(light,cGray, 1.0)
xLightSetDiffuseColor(light,cWhite, 1.0)
xLightSetSpecularColor(light,cWhite, 1.0)
xObjectSetPosition(light,5,10,0)

pl=xPlaneCreate(False, 10, 10, 5, 5, scene)
xObjectPitch(pl, 90)
xMaterialCreate('mGround', 'data/b3d/ground.jpg')
xObjectSetMaterial(pl, 'mGround')

xMaterialCreate('mTorch', '')
xMaterialSetDiffuseColor('mTorch', RGB(128, 64, 0), 1)

firefx = xFireFXManagerCreate()
xFireFXSetParticleSize(firefx, 0.3)
xFireFXSetRadius(firefx, 0.1)
xFireFXSetBurst(firefx, 2.0)
xFireFXSetDensity(firefx, 1)
xFireFXSetLife(firefx, 1)
xFireFXSetColor(firefx, cYellow, 1.0, cRed, 0.0)

torch1 = xCylinderCreate(0.05, 0.05, 1, 16, 1, 1, scene)
xObjectSetPosition(torch1, 0, 0.5, 0)
xObjectSetMaterial(torch1, 'mTorch')
fireobj1 = xDummycubeCreate(torch1)
xObjectSetPosition(fireobj1, 0, 0.5, 0)
xFireFXCreate(firefx, fireobj1)

torch2 = xCylinderCreate(0.05, 0.05, 1, 16, 1, 1, scene)
xObjectSetPosition(torch2, -2, 0.5, 0)
xObjectSetMaterial(torch2, 'mTorch')
fireobj2 = xDummycubeCreate(torch2)
xObjectSetPosition(fireobj2, 0, 0.5, 0)
xFireFXCreate(firefx, fireobj2)

torch3 = xCylinderCreate(0.05, 0.05, 1, 16, 1, 1, scene)
xObjectSetPosition(torch3, 2, 0.5, 0)
xObjectSetMaterial(torch3, 'mTorch')
fireobj3 = xDummycubeCreate(torch3)
xObjectSetPosition(fireobj3, 0, 0.5, 0)
xFireFXCreate(firefx, fireobj3)

mx=DisplayGetParemeter(0)/2
my=DisplayGetParemeter(1)/2
DisplayMouseSet(mx,my)

font=xWindowsBitmapfontCreate('Arial',20,0,128)
text=xHUDTextCreate(font,'Xtreme3D 3.5'..string.char(13)..'FPS: ',front)
xHUDTextSetColor(text,cWhite,0.5)
xObjectSetPosition(text,20,20,0)

--Настройка компонентов звукового движка
Init()
SoundFire = AddSound('data/Sounds/Fire.wav', 1, 0)

man = AddManager()
Manager_SetSample(man,SoundFire)
Manager_SetVolume(man,100)
Manager_SetProperties(man,1,32,8)
Manager_SetFrequency(man,Sample_GetFileFrequency(Manager_GetSample(man))*0.7)
PlayEx(man,1,0,0,0,1)
Manager_SetPosition(man,0,0.5,0);

Run = true
while WindowsExists(window_handle) and Run do
	WindowsRefresh()
	KeyRefresh()
	fps = CallFps(60)
	dt = 1/fps
	
	xUpdate(dt)
	xViewerRender(view1)
	
	framerate=math.floor(xViewerGetFramesPerSecond(view1))
	xHUDTextSetText(text,'Xtreme3D 3.5'..string.char(13)..'FPS: '..fps)
	
	deltax=(mx-DisplayMouseGet(0))/3
	deltay=(my-DisplayMouseGet(1))/3
	xObjectRotate(camera,deltay,0,0)
	xObjectRotate(camPos,0,-deltax,0)
	DisplayMouseSet(mx,my)
	
	if Key(string.byte('W')) then xObjectMove(camPos, -5 * dt) end
	if Key(string.byte('A')) then xObjectStrafe(camPos, 5 * dt) end
	if Key(string.byte('D')) then xObjectStrafe(camPos, -5 * dt) end
	if Key(string.byte('S')) then xObjectMove(camPos, 5 * dt) end
	
	SoundSystem_SetListinerPosition(xObjectGetPosition(camPos,0), xObjectGetPosition(camPos,1), xObjectGetPosition(camPos,2))
	
	if KeyReleased(VK_ESCAPE) then Run = false end
end

--EngineDestroy()
Manager_Free(man)
Free() --Удаление звукового движка