#define export extern "C" __declspec( dllexport )

#include "Main.h"

export double XmlDocumentCreate(char* filename)
{
    TiXmlDocument *XMLDoc = new TiXmlDocument(filename);
    bool loadfile = XMLDoc->LoadFile();
	if (!loadfile) 
    {
    char* error_text;
    sprintf(error_text,"PhantomXML:\nFailed to load file %s.",filename);
    MessageBox(GetActiveWindow(),error_text,"Error",MB_OK);
    return 1;
    }
    return (double)reinterpret_cast<int>(XMLDoc);
}

export double XmlDocumentGetFirstChildElement(double doc, char* name)
{
    TiXmlDocument *XMLDoc = reinterpret_cast<TiXmlDocument*>((int)doc);
    TiXmlElement *XMLElement = new TiXmlElement("");
    XMLElement = XMLDoc->FirstChildElement(name); 
    return (double)reinterpret_cast<int>(XMLElement);
}

export double XmlElementGetFirstChildElement(double element, char* name)
{
    TiXmlElement *XMLElementParent = reinterpret_cast<TiXmlElement*>((int)element);
    TiXmlElement *XMLElement = new TiXmlElement("");
    XMLElement = XMLElementParent->FirstChildElement(name); 
    return (double)reinterpret_cast<int>(XMLElement);
}

export double XmlElementGetNextSiblingElement(double element, char* name)
{
    TiXmlElement *XMLElementParent = reinterpret_cast<TiXmlElement*>((int)element);
    TiXmlElement *XMLElement = new TiXmlElement("");
    XMLElement = XMLElementParent->NextSiblingElement(name); 
    return (double)reinterpret_cast<int>(XMLElement);
}

export double XmlElementGetNull(double element)
{
    TiXmlElement *XMLElementParent = reinterpret_cast<TiXmlElement*>((int)element);
    if (XMLElementParent == NULL) return 0;
    else return 1;
}

export char* XmlElementGetAttributeString(double element, char* attribute)
{
    TiXmlElement *XMLElement = reinterpret_cast<TiXmlElement*>((int)element);
    return (char*)XMLElement->Attribute(attribute);
}

export double XmlElementGetAttributeReal(double element, char* attribute)
{
    TiXmlElement *XMLElement = reinterpret_cast<TiXmlElement*>((int)element);
    float real = (float)atof(XMLElement->Attribute(attribute));
    return real;
}

export double XmlGetValueFromString(char* string, char* mask, double ind)
{
    float pos[8];
    sscanf(string,mask,&pos[0],&pos[1],&pos[2],&pos[3],&pos[4],&pos[5],&pos[6],&pos[7]);
    return (double)pos[(int)ind];
}

export double XmlElementGetAttributeVector2f(double element, char* attribute, double ind)
{
    TiXmlElement *XMLElement = reinterpret_cast<TiXmlElement*>((int)element);
    float pos[2];
    sscanf(XMLElement->Attribute(attribute),"%f,%f",&pos[0],&pos[1]);
    return pos[(int)ind];
}

export double XmlElementGetAttributeVector3f(double element, char* attribute, double ind)
{
    TiXmlElement *XMLElement = reinterpret_cast<TiXmlElement*>((int)element);
    float pos[3];
    sscanf(XMLElement->Attribute(attribute),"%f,%f,%f",&pos[0],&pos[1],&pos[2]);
    return pos[(int)ind];
}

export double XmlElementGetAttributeVector4f(double element, char* attribute, double ind)
{
    TiXmlElement *XMLElement = reinterpret_cast<TiXmlElement*>((int)element);
    float pos[4];
    sscanf(XMLElement->Attribute(attribute),"%f,%f,%f,%f",&pos[0],&pos[1],&pos[2],&pos[3]);
    return pos[(int)ind];
}
