/*
  World
*/

/*  -       .     
 y , ..    p  y    
  p.
   p       , y    
        .
     p.*/

/*       id.*/
export double OdeWorldCreate()
{
    World = dWorldCreate();
    contactgroup = dJointGroupCreate(0);
	return 1;
}

/* p.   " "(big matrix)    
  m3    m2,  m    .
          ,    
    .*/
export double OdeWorldStep(double delta)
{
    dWorldStep(World, delta);
    dJointGroupEmpty(contactgroup);
    return 1;
}

/* .   ,     m*N   
 m,  m      N  .
        dWorldStep( ),   .
QuickStep         auto-disable . 
  ,         (near-singular). 
   ,      , 
    . ,    , 
  ,   .
      QuickStep':
    -  CFM.
    -      (..   
           ).
    -      .
    -  ,    .
    -   (kinematic loops)(  ,    
          ).
    -    y .
    -     y   .
   QuickStep   ,   ,   
.*/
export double OdeWorldQuickStep(double delta)
{
    dWorldQuickStep(World, delta);
    dJointGroupEmpty(contactgroup);
    return 1;
}

/*      QuickStep  
  .    20 .*/
export double OdeWorldSetQuickStepNumIterations(double num)
{
    dWorldSetQuickStepNumIterations(World, (int)num);
    return 1;
}

/*   p.    y (0,-0.981,0). 
 y  , .. (0,0,0).*/
export double OdeWorldSetGravity(double x, double y, double z)
{
    dWorldSetGravity(World, x, y, z);
    return 1;
}

/*   CFM(constraint force mixing). 
     10^-9 - 1. 
 y 10^-5      10^-10   
 .*/
export double OdeWorldSetCFM(double cfm)
{
    dWorldSetCFM(World, cfm);
    return 1;
}

/*  y   ERP,  ,  y 
      .   
   0.1-0.8.  y 0.2.*/
export double OdeWorldSetERP(double erp)
{
    dWorldSetERP(World, erp);
    return 1;
}

/*    ,   
  .   y  (.. ). 
      "" (popping)  
 .*/
export double OdeWorldSetContactMaxCorrectingVel(double cmcv)
{
    dWorldSetContactMaxCorrectingVel(World, cmcv);
    return 1;
}

/*      . 
 y        . 
  y .       (. 0.001) 
      (jittering),    ,  
.*/
export double OdeWorldSetContactSurfaceLayer(double csl)
{
    dWorldSetContactSurfaceLayer(World, csl);
    return 1;
}

/*  - (auto-disable)     . 
    (enabled)  (disabled).   
  ,            
    (simulation step).      
 .
  :
         - AutoDisableFlag=0
         - AutoDisableLinearThreshold=0.01
         - AutoDisableAngularThreshold=0.01
         - AutoDisableSteps=10
         - AutoDisableTime=0*/
export double OdeWorldSetAutoDisableFlag(double flag)
{
    dWorldSetAutoDisableFlag(World, (int)flag);
    return 1;
}

export double OdeWorldSetAutoDisableLinearThreshold(double threshold)
{
    dWorldSetAutoDisableLinearThreshold(World, threshold);
    return 1;
}

export double OdeWorldSetAutoDisableAngularThreshold(double threshold)
{
    dWorldSetAutoDisableAngularThreshold(World, threshold);
    return 1;
}

export double OdeWorldSetAutoDisableSteps(double steps)
{
    dWorldSetAutoDisableSteps(World, (int)steps);
    return 1;
}

export double OdeWorldSetAutoDisableTime(double time)
{
    dWorldSetAutoDisableTime(World, time);
    return 1;
}

/* p      .    ,    
    .       
    y     dJointGroupEmpty( ).*/
export double OdeWorldDestroy()
{
    dWorldDestroy (World);
    return 1;
}

/*    ,   ODE    
    ,  dWorldDestroy( ).    
        y .*/
export double OdeClose()
{
    dCloseODE();
    return 1;
}

