#include <stdio.h>
#include <windows.h>

#include "include/ode.h"

#define DENSITY (0.5)        // density of all objects
#define GEOMSPERBODY 1       // maximum number of geometries per body
#define MAX_CONTACTS 4       // maximum number of contact points per body

#define PI 3.1415926536

dWorldID World;
dJointGroupID contactgroup;

static void nearCallback(void *data, dGeomID o1, dGeomID o2)
{
    int i;
    dBodyID b1 = dGeomGetBody(o1);
    dBodyID b2 = dGeomGetBody(o2);
    dContact contact[MAX_CONTACTS];
    for (i = 0; i < MAX_CONTACTS; i++)
    {
        contact[i].surface.mode = dContactBounce | dContactSoftCFM;
        contact[i].surface.mu = dInfinity;
        contact[i].surface.mu2 = 0;
        contact[i].surface.bounce = 0.01;
        contact[i].surface.bounce_vel = 0.1;
        contact[i].surface.soft_cfm = 0.01;
    }
    if (int numc = dCollide(o1, o2, MAX_CONTACTS, &contact[0].geom, sizeof(dContact)))
    {
        for (i = 0; i < numc; i++)
        {
            dJointID c = dJointCreateContact(World, contactgroup, contact + i);
            dJointAttach(c, b1, b2);
        }
    }
}
