/*
  Geom
*/

/*  (sphere)      id. 
 space   ,      . 
    .*/
export double OdeCreateSphere(double space, double rad)
{   
    dGeomID *geom;
    geom = new dGeomID;
    dSpaceID *pspace;
    pspace = reinterpret_cast<dSpaceID*>((int)space);
    *geom = dCreateSphere(*pspace,rad);
    return (double)reinterpret_cast<int>(geom);
}

/*    (capped cylinder)     
  id.  space   ,      .
              
  .        
   .    height   .   
       Z.     
       rad.*/
export double OdeCreateCCylinder(double space, double rad, double height)
{   
    dGeomID *geom;
    geom = new dGeomID;
    dSpaceID *pspace;
    pspace = reinterpret_cast<dSpaceID*>((int)space);
    *geom = dCreateCCylinder(*pspace,rad,height);
    return (double)reinterpret_cast<int>(geom);
}

/* ,    .   
            -  
        .
 ID         ,   . 
      ,   /  
    /  .*/
export double OdeGeomSetBody(double geom, double body)
{   
    dGeomID *pgeom;
    pgeom = reinterpret_cast<dGeomID*>((int)geom);   
    dBodyID *pbody;
    pbody = reinterpret_cast<dBodyID*>((int)body);
    dGeomSetBody(*pgeom,*pbody);
    return 1;
}

/*     .    
 ,        OdeBodyGetPosition.*/
export double OdeGeomGetPosition(double geom, double ind)
{
    dGeomID *pgeom;
    pgeom = reinterpret_cast<dGeomID*>((int)geom);   
    return (double)dGeomGetPosition(*pgeom)[(int)ind];
}

/*     .    
 ,        OdeBodyGetRotation.*/
export double OdeGeomGetRotation(double geom, double ind)
{   
    dGeomID *pgeom;
    pgeom = reinterpret_cast<dGeomID*>((int)geom);   
    dReal *R;
    R = (dReal*)dGeomGetRotation(*pgeom);
    return (double)R[(int)ind];
}

/* .*/
export double OdeGeomDestroy(double geom, double ind)
{   
    dGeomID *pgeom;
    pgeom = reinterpret_cast<dGeomID*>((int)geom);   
    dGeomDestroy(*pgeom);
    return 1;
}

//void dGeomDestroy (dGeomID);
//void dGeomSetData (dGeomID, void *);
//void *dGeomGetData (dGeomID);
//void dGeomSetPosition (dGeomID, dReal x, dReal y, dReal z);
//void dGeomSetRotation (dGeomID, const dMatrix3 R);
//void dGeomSetQuaternion (dGeomID, const dQuaternion);
//void dGeomGetQuaternion (dGeomID, dQuaternion result);
//void dGeomGetAABB (dGeomID, dReal aabb[6]);
//int dGeomIsSpace (dGeomID);
//dSpaceID dGeomGetSpace (dGeomID);
//int dGeomGetClass (dGeomID);
//void dGeomSetCategoryBits (dGeomID, unsigned long bits);
//void dGeomSetCollideBits (dGeomID, unsigned long bits);
//void dGeomEnable (dGeomID);
//void dGeomDisable (dGeomID);
//int   dGeomIsEnabled (dGeomID);
