#include "Vector.h"
#include "Matrix.h"
#define PI2	6.28318530717958647692528676655901f

class GLWater: public GLBaseSceneObject
{
public:
  //vec RefractedRayin_cube(const vec &vertex, const vec &in, const vec &n, float nri);
  GLWater();
  ~GLWater();
  float	sx, sz;
  int	cx, cz;
  vec	*v;
  vec	*vn;
  float	*veloc;	
  float	*force;	
  float change_veloc;
  float utlm;
  float drop_time;
  float *p_fresnel;
  int   *p_quality_of_refraction;
  
  void Init( int div_x, int div_z, float size_x, float size_z);
  void UpdateWater(float timeframe);
  void Reset();
  void Rain(float timeframe, float drops_per_sec, float amplitude, float length, float muffle=1.f);
  void ComputeNormals();
  void Wave( vec p, float time, float freq, float length, float muffle);
  void Wave_time0(const vec &p, float length);
  inline float DistanceXZ( const vec &a, const vec &b);
  void RenderSolid();
  void Update()
  {
    if (RoomIndependant) Room=CurrentRoom;
    glPushMatrix ();
    GLBaseSceneObject::Update();
    if (Room==CurrentRoom)
    {
   	Rain(0.1, 1/*drops per sec*/, 0.85/*amplitude*/, 1/*wave length*/);
	UpdateWater(0.1);
    if (Visible) Render();
    }
    Material->PostUpdate();
    glPopMatrix ();
  }
  void Render()
  {
    RenderSolid();
  }
private:
  void Delete();
};

GLWater::GLWater()
{
	v = NULL;
	vn = NULL;
	veloc = NULL;
	force = NULL;
	Init( 100, 100, 10.f, 10.f);
	change_veloc = 0.3f;
	utlm = 1;
}

GLWater::~GLWater()
{
	Delete();
}

void GLWater::Delete()
{
	if(v!=NULL)delete [] v;			v = NULL;
	if(vn!=NULL)delete [] vn;		vn = NULL;
	if(force!=NULL)delete[] force;	force = NULL;
	if(veloc!=NULL)delete[] veloc;	veloc = NULL;
}

void GLWater::Init(int div_x, int div_z, float size_x, float size_z)
{
	Delete();
	sx = size_x;
	sz = size_z;
	cx = div_x;
	cz = div_z;	
	v = new vec[cx*cz];
	for(int z=0; z<cz; z++)
	{
		float zf = z/(float)(cz-1);
		zf = (zf-0.5f)*sz;
		for(int x=0; x<cx; x++)
		{
			float xf = x/(float)(cx-1);
			xf = (xf-0.5f)*sx;
			v[z*cx+x].set(xf, 0, zf);
		}
	}	
	vn = new vec[cx*cz];
	force = new float[cx*cz];
	veloc = new float[cx*cz];
	for(int i=0; i<cx*cz; i++) veloc[i]=0.0f;
	drop_time=0;
}

inline float GLWater::DistanceXZ(const vec &a, const vec &b)
{
	float x = a.x - b.x;
	float z = a.z - b.z;
	return (float) sqrt(x*x + z*z);
}

void GLWater::UpdateWater(float timeframe)
{
	#define SQRT2DIV2 0.707106781186547524400844362104849f
	float d;
	int a,b;
	int i,z,x;
	for(i=0; i<cx*cz; i++) force[i]=0;
	for(z=1; z<cz-1; z++)
	{
		for(x=1; x<cx-1; x++)
		{
			a = cx*z+x; 
			b = cx*(z  )+x-1; d = v[a].y - v[b].y; force[a] -= d; force[b] += d;
			b = cx*(z  )+x+1; d = v[a].y - v[b].y; force[a] -= d; force[b] += d;
			b = cx*(z-1)+x  ; d = v[a].y - v[b].y; force[a] -= d; force[b] += d;
			b = cx*(z+1)+x  ; d = v[a].y - v[b].y; force[a] -= d; force[b] += d;
			b = cx*(z-1)+x+1; d = v[a].y - v[b].y; d*=SQRT2DIV2; force[a] -= d; force[b] += d;
			b = cx*(z-1)+x-1; d = v[a].y - v[b].y; d*=SQRT2DIV2; force[a] -= d; force[b] += d;
			b = cx*(z+1)+x+1; d = v[a].y - v[b].y; d*=SQRT2DIV2; force[a] -= d; force[b] += d;
			b = cx*(z+1)+x-1; d = v[a].y - v[b].y; d*=SQRT2DIV2; force[a] -= d; force[b] += d;
		}
	}
	float change_veloc_fps=100.f*change_veloc*timeframe;
	if(change_veloc_fps>1.0f)change_veloc_fps=1.f;
	float utlm_fps = (float)exp(250.f*timeframe*log(1-0.01f*utlm));
	for( i=0; i<cx*cz; i++)
	{
		veloc[i] += change_veloc_fps*0.2f*force[i];
		v[i].y += change_veloc_fps*veloc[i];
		v[i].y *= utlm_fps;
	}
	ComputeNormals();
}

void GLWater::ComputeNormals()
{
    int z,x;
	for(z=0; z<cz-1; z++)
	{
		for(x=0; x<cx-1; x++)
		{
			vn[cx*z+x] = CROSS( v[cx*(z+1)+x]-v[cx*z+x], v[cx*z+x+1]-v[cx*z+x]);
			vn[cx*z+x].Normalize();
		}
	}
	z = cz-1;
	for(x=0; x<cx-1; x++)
	{
		vn[cx*z+x] = CROSS( v[cx*z+x]-v[cx*(z-1)+x], v[cx*z+x+1]-v[cx*z+x]);
		vn[cx*z+x].Normalize();
	}
	x = cx-1;
	for( z=0; z<cz-1; z++)
	{
		vn[cx*z+x] = CROSS( v[cx*(z+1)+x]-v[cx*z+x], v[cx*z+x]-v[cx*z+x-1]);
		vn[cx*z+x].Normalize();
	}
	z = cz-1;
	vn[cx*z+x] = CROSS( v[cx*z+x]-v[cx*(z-1)+x], v[cx*z+x]-v[cx*z+x-1]);
	vn[cx*z+x].Normalize();
}

void GLWater::Wave(vec p, float time, float freq, float length, float muffle)
{
	float a = PI2*freq;
	float b = PI2/length;
	int z,x;
	
	for(z=0; z<cz; z++)
	{
		for(x=0; x<cx; x++)
		{
			float dist = DistanceXZ(p,v[z*cx+x]);
			v[z*cx+x].y += p.y*(float)cos( a*time - b*dist )*(float)exp(-muffle*dist*dist);
		}
	}
}

void GLWater::Reset()
{
	for(int i=0; i<cx*cz; i++)
	{
		v[i].y = 0;
		veloc[i] = 0;
	}
	drop_time=0;
}

void GLWater::Rain(float timeframe, float drops_per_sec, float amplitude, float length, float muffle)
{
	drop_time+=timeframe;
	
	if(drop_time>(1.f/drops_per_sec))
	{
		float rn;
		vec p;
		rn = (float)rand()/(float)RAND_MAX;
		p.x = (rn-0.5f)*sx;
		rn = (float)rand()/(float)RAND_MAX;
		p.z = (rn-0.5f)*sz;
		rn = (float)rand()/(float)RAND_MAX;
		p.y = rn*amplitude;
		Wave_time0( p, length);
		drop_time=0;
	}
}

void GLWater::Wave_time0(const vec &p, float length)
{
	float b = PI2/length;
	
	for(int z=0; z<cz; z++)
	{
		for(int x=0; x<cx; x++)
		{
			float dist = DistanceXZ(p,v[z*cx+x]);
		//	v[z*cx+x].y += p.y*(float)cos( b*dist )*(float)exp(-dist);
			v[z*cx+x].y += p.y*(float)cos( b*dist )*(float)exp(-dist*dist);
		}
	}
}

void GLWater::RenderSolid()
{
	for(int z=0; z<cz-1; z++)
	{
		glBegin(GL_TRIANGLE_STRIP );
		for(int x=0; x<cx; x++)
		{
			glNormal3fv(vn[z*cx+x].v);
			glVertex3fv(v[z*cx+x].v);
			glNormal3fv(vn[(z+1)*cx+x].v);
			glVertex3fv(v[(z+1)*cx+x].v);
		}
		glEnd();
	}
}



