/*
struct Image 
{
   unsigned long  sizeX;
   unsigned long  sizeY;
   unsigned long bpp;
   char *data;
   Image()
   {
   data = (char*)0;
   sizeX = 0;
   sizeY = 0;
   bpp = 0;
   }
   ~Image() 
   { 
   delete[] data; 
   data = 0; 
   }
};

float InterPolation(float a, float b, float c)
{   
    return a+(b-a)*c*c*(3-2*c);                                                   
}

float InterLinear(float a, float b, float c)
{    
    return a*(1-c)+b*c;                                         
}

float Noise( int x)
{
    x = (x<<13)^x;
    return (((x * (x * x * 15731 + 789221) + 1376312589) & 0x7fffffff) / 2147483648.0);
}

float PerlinNoise(float x,float y,int width,int octaves,int seed,double periode)
{
    double a,b,value,freq,zone_x,zone_y;
    int s,box,num,step_x,step_y;
    int amplitude=220;
    int noisedata;
      
    freq=1/(float)(periode);

    for ( s=0;s<octaves;s++)
    {
    num=(int)(width*freq);
    step_x=(int)(x*freq);
    step_y=(int)(y*freq);
    zone_x=x*freq-step_x;
    zone_y=y*freq-step_y;
    box=step_x+step_y*num;
    noisedata=(box+seed);
    a=InterPolation(Noise(noisedata),Noise(noisedata+1),zone_x);
    b=InterPolation(Noise(noisedata+num),Noise(noisedata+1+num),zone_x);
    value=InterPolation(a,b,zone_y)*amplitude;
    }
    return value;
}

void Colour(float valor, float RGB[2])
{
      int r=(int)InterLinear(valor,0,0);
      int g=(int)InterLinear(valor,0,0);
      int b=(int)InterLinear(valor,0,0);

      RGB[0]=(float)r;
      RGB[1]=(float)g;
      RGB[2]=(float)b;
}
*/

/*
GLTexture
*/
class GLTexture
{
   public:
      GLTexture() { }
      ~GLTexture() { }
      ILuint texid;
      GLuint ID;
      GLuint imageWidth; 
      GLuint imageHeight;
      
void DevILLoad(char *filename)
{
     ilGenImages(1, &texid);
     ilBindImage(texid);
     ilLoadImage(filename);
     glGenTextures(1, &ID);
     glBindTexture(GL_TEXTURE_2D, ID);
     /*
     glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
     glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
     glTexImage2D(GL_TEXTURE_2D, 0, 
      ilGetInteger(IL_IMAGE_BPP), 
      ilGetInteger(IL_IMAGE_WIDTH),
      ilGetInteger(IL_IMAGE_HEIGHT), 0, 
      ilGetInteger(IL_IMAGE_FORMAT), GL_UNSIGNED_BYTE,
      ilGetData());
     */
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
     
       gluBuild2DMipmaps(GL_TEXTURE_2D, 
       ilGetInteger(IL_IMAGE_FORMAT), 
       ilGetInteger(IL_IMAGE_WIDTH), 
       ilGetInteger(IL_IMAGE_HEIGHT), 
       ilGetInteger(IL_IMAGE_FORMAT), GL_UNSIGNED_BYTE, 
       ilGetData());

     imageWidth=ilGetInteger(IL_IMAGE_WIDTH);
     imageHeight=ilGetInteger(IL_IMAGE_HEIGHT);
    
     ilDeleteImages(1, &texid);
}

void ILULoadExecList(char *filename, GLExecList *execlist)
{
     ilGenImages(1, &texid);
     ilBindImage(texid);
     ilLoadImage(filename);
     for( std::list<GLExecValue*>::iterator i = execlist->Values.begin(); i != execlist->Values.end(); i++ )
     {
      if ((*i)->V1==ilfGaussianBlur) iluBlurGaussian( (ILuint)(int)((*i)->V2) );
      if ((*i)->V1==ilfNegative) iluNegative();
      if ((*i)->V1==ilfEmboss) iluEmboss();
      if ((*i)->V1==ilfAlien) iluAlienify();
      if ((*i)->V1==ilfPixelize) iluPixelize( (ILuint)(int)((*i)->V2) );
      if ((*i)->V1==ilfAvgBlur) iluBlurAvg( (ILuint)(int)((*i)->V2) );
      if ((*i)->V1==ilfEdgeDetectE) iluEdgeDetectE();
      if ((*i)->V1==ilfEdgeDetectP) iluEdgeDetectP();
      if ((*i)->V1==ilfEdgeDetectS) iluEdgeDetectS();
      if ((*i)->V1==ilfSharpen) iluSharpen( (ILfloat)(float)((*i)->V2),(ILuint)(int)((*i)->V3) );
      if ((*i)->V1==ilfMirror) iluMirror();
      if ((*i)->V1==ilfContrast) iluContrast( (ILfloat)(float)((*i)->V2) );
      if ((*i)->V1==ilfGammaCorrect) iluGammaCorrect( (ILfloat)(float)((*i)->V2) );
      if ((*i)->V1==ilfRotate) iluRotate( (ILfloat)(float)((*i)->V2) );
      if ((*i)->V1==ilfWave) iluWave( (ILfloat)(float)((*i)->V2) );
      if ((*i)->V1==ilfScale) iluScale( (ILuint)(int)((*i)->V2),(ILuint)(int)((*i)->V3),(ILuint)(int)((*i)->V4) );
      if ((*i)->V1==ilfEqualize) iluEqualize();
     }
     glGenTextures(1, &ID);
     glBindTexture(GL_TEXTURE_2D, ID);
     
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
     
       gluBuild2DMipmaps(GL_TEXTURE_2D, 
       ilGetInteger(IL_IMAGE_FORMAT), 
       ilGetInteger(IL_IMAGE_WIDTH), 
       ilGetInteger(IL_IMAGE_HEIGHT), 
       ilGetInteger(IL_IMAGE_FORMAT), GL_UNSIGNED_BYTE, 
       ilGetData());

     imageWidth=ilGetInteger(IL_IMAGE_WIDTH);
     imageHeight=ilGetInteger(IL_IMAGE_HEIGHT);
    
     ilDeleteImages(1, &texid);
  }

void ILULoadExecListAndSave(char *filename, GLExecList *execlist, char *savefilename)
{
     ilGenImages(1, &texid);
     ilBindImage(texid);
     ilLoadImage(filename);
     for( std::list<GLExecValue*>::iterator i = execlist->Values.begin(); i != execlist->Values.end(); i++ )
     {
      if ((*i)->V1==ilfGaussianBlur) iluBlurGaussian( (ILuint)(int)((*i)->V2) );
      if ((*i)->V1==ilfNegative) iluNegative();
      if ((*i)->V1==ilfEmboss) iluEmboss();
      if ((*i)->V1==ilfAlien) iluAlienify();
      if ((*i)->V1==ilfPixelize) iluPixelize( (ILuint)(int)((*i)->V2) );
      if ((*i)->V1==ilfAvgBlur) iluBlurAvg( (ILuint)(int)((*i)->V2) );
      if ((*i)->V1==ilfEdgeDetectE) iluEdgeDetectE();
      if ((*i)->V1==ilfEdgeDetectP) iluEdgeDetectP();
      if ((*i)->V1==ilfEdgeDetectS) iluEdgeDetectS();
      if ((*i)->V1==ilfSharpen) iluSharpen( (ILfloat)(float)((*i)->V2),(ILuint)(int)((*i)->V3) );
      if ((*i)->V1==ilfMirror) iluMirror();
      if ((*i)->V1==ilfContrast) iluContrast( (ILfloat)(float)((*i)->V2) );
      if ((*i)->V1==ilfGammaCorrect) iluGammaCorrect( (ILfloat)(float)((*i)->V2) );
      if ((*i)->V1==ilfRotate) iluRotate( (ILfloat)(float)((*i)->V2) );
      if ((*i)->V1==ilfWave) iluWave( (ILfloat)(float)((*i)->V2) );
      if ((*i)->V1==ilfScale) iluScale( (ILuint)(int)((*i)->V2),(ILuint)(int)((*i)->V3),(ILuint)(int)((*i)->V4) );
      if ((*i)->V1==ilfEqualize) iluEqualize();
     }
     glGenTextures(1, &ID);
     glBindTexture(GL_TEXTURE_2D, ID);
     
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
     
       gluBuild2DMipmaps(GL_TEXTURE_2D, 
       ilGetInteger(IL_IMAGE_FORMAT), 
       ilGetInteger(IL_IMAGE_WIDTH), 
       ilGetInteger(IL_IMAGE_HEIGHT), 
       ilGetInteger(IL_IMAGE_FORMAT), GL_UNSIGNED_BYTE, 
       ilGetData());

     imageWidth=ilGetInteger(IL_IMAGE_WIDTH);
     imageHeight=ilGetInteger(IL_IMAGE_HEIGHT);

     ilSaveImage(savefilename);
     ilDeleteImages(1, &texid);
  }
};

/*
void GenerateCloth()
{	
    GLubyte image1[256][256][3];
	for(int y=0;y< 256; y++)
	{
        	for(int x=0;x<256; x++)	
		{
	      	image1[x][y][0] = (GLubyte)cos(x/4)*255;
      		image1[x][y][1] = (GLubyte)sin(y/4)*255;
      		image1[x][y][2] = (GLubyte)cos(x/4)*255;
		}
	}
    glGenTextures(1, &ID);
    glBindTexture(GL_TEXTURE_2D, ID);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
    gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, 256, 256, GL_RGB, GL_UNSIGNED_BYTE, image1);
    imageWidth=256;
    imageHeight=256;
};

void GenerateCloth2()
{	
    GLubyte image1[256][256][3];
	for(int y=0;y< 256; y++)
	{
        	for(int x=0;x<256; x++)	
		{
	      	image1[x][y][0] = (GLubyte)cos(x/4)*255;
      		image1[x][y][1] = (GLubyte)cos(y/4)*255;
      		image1[x][y][2] = (GLubyte)sin(x/4)*255;
		}
	}
    glGenTextures(1, &ID);
    glBindTexture(GL_TEXTURE_2D, ID);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
    gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, 256, 256, GL_RGB, GL_UNSIGNED_BYTE, image1);
    imageWidth=256;
    imageHeight=256;
};

void GeneratePerlinNoise()
{	
    GLubyte image1[256][256][3];
    float RGB[2];

    int x,y;
    int seed;
    int width;
    float  disp1,disp2,disp3,disp4,disp5,disp6,scale;

    for(y=0;y< 256; y++)
    {
        for(x=0;x<256; x++)
	{
      	scale=1;
      	width=12413;
      	seed=3634;
    	disp1= PerlinNoise(x*scale,y*scale,width,1,seed,100);
    	disp2= PerlinNoise(x*scale,y*scale,width,1,seed,25);
    	disp3= PerlinNoise(x*scale,y*scale,width,1,seed,12.5);
    	disp4= PerlinNoise(x*scale,y*scale,width,1,seed,6.25);
    	disp5= PerlinNoise(x*scale,y*scale,width,1,seed,3.125);
    	disp6= PerlinNoise(x*scale,y*scale,width,1,seed,1.56);    
      	Colour((int)disp1+(int)(disp2*.25)+(int)(disp3*.125)+(int)(disp4*.0625)+(int)(disp5*.03125)+(int)(disp6*.0156),RGB);
      	image1[x][y][0] = (GLubyte)RGB[0];
      	image1[x][y][1] = (GLubyte)RGB[1];
      	image1[x][y][2] = (GLubyte)RGB[2];  
    	}
    }

    glGenTextures(1, &ID);
    glBindTexture(GL_TEXTURE_2D, ID);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
    gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, 256, 256, GL_RGB, GL_UNSIGNED_BYTE, image1);
    imageWidth=256;
    imageHeight=256;
};
*/

