/*
GLShader
*/
class GLShader
{
   public:
      bool VPEnabled;
      bool FPEnabled;
      GLuint VP;
      GLuint FP;
      char *VPSource;
      char *FPSource;
      GLVector4f VPEnvPar[5];
      GLVector4f FPEnvPar[5];
      int VPEnvParCount;
      int FPEnvParCount;
      GLShader() 
	{ 
	   VPEnabled=false;
	   FPEnabled=false;
	   VPEnvParCount=0;
	   FPEnvParCount=0;
	}
      ~GLShader() { }
      void VPLoad(char *filename)
    	{	
    		if (vp_supported)
    		{
    		int err;
    		VPSource = ReadTextFile(filename);
    		glEnable(GL_VERTEX_PROGRAM_ARB);
    		glGenProgramsARB(1, &VP);
    		glBindProgramARB(GL_VERTEX_PROGRAM_ARB, VP);
   		    glProgramStringARB(GL_VERTEX_PROGRAM_ARB, GL_PROGRAM_FORMAT_ASCII_ARB, strlen(VPSource), VPSource);
    		glGetIntegerv(GL_PROGRAM_ERROR_POSITION_ARB, &err);
    		if (err >= 0) printf("Vertex program error %s\n", glGetString(GL_PROGRAM_ERROR_STRING_ARB));
		    VPEnabled=true;
    		glDisable(GL_VERTEX_PROGRAM_ARB);
            VPSource=0;
    		}
    	};
      void FPLoad(char *filename)
    	{	
    		if (fp_supported)
    		{
    		int err;
    		FPSource = ReadTextFile(filename);
    		glEnable(GL_FRAGMENT_PROGRAM_ARB);
    		glBindProgramARB(GL_FRAGMENT_PROGRAM_ARB, FP);
   		    glProgramStringARB(GL_FRAGMENT_PROGRAM_ARB, GL_PROGRAM_FORMAT_ASCII_ARB, strlen(FPSource), FPSource);
    		glGetIntegerv(GL_PROGRAM_ERROR_POSITION_ARB, &err);
    		if (err >= 0) printf("Fragment program error %s\n", glGetString(GL_PROGRAM_ERROR_STRING_ARB));
	        FPEnabled=true;
    		glDisable(GL_FRAGMENT_PROGRAM_ARB);
            FPSource=0;
    		}
    	};
      void VPSetEnvParameter(GLuint n, GLfloat p1, GLfloat p2, GLfloat p3, GLfloat p4)
	  {
      
		VPEnvPar[n].X = p1;
		VPEnvPar[n].Y = p2;
		VPEnvPar[n].Z = p3;
		VPEnvPar[n].W = p4;
		VPEnvParCount++;
	  };
      void FPSetEnvParameter(GLuint n, GLfloat p1, GLfloat p2, GLfloat p3, GLfloat p4)
	  {
        FPEnvPar[n].X = p1;
		FPEnvPar[n].Y = p2;
		FPEnvPar[n].Z = p3;
		FPEnvPar[n].W = p4;
		FPEnvParCount++;
	  };
      void Update()
    	{
    		if (vp_supported || fp_supported)
    		{
		if (VPEnabled)
		{
    		glEnable(GL_VERTEX_PROGRAM_ARB);
    		for( int i=1; i<=VPEnvParCount; i++ ) 
			{
			glProgramEnvParameter4fARB(GL_VERTEX_PROGRAM_ARB, i, VPEnvPar[i].X, VPEnvPar[i].Y, VPEnvPar[i].Z, VPEnvPar[i].W);
			}
    		glBindProgramARB(GL_VERTEX_PROGRAM_ARB, VP);
		}
    		if (FPEnabled)
		{
    		glEnable(GL_FRAGMENT_PROGRAM_ARB);
    		for( int i=1; i<=FPEnvParCount; i++ ) 
			{
			glProgramEnvParameter4fARB(GL_FRAGMENT_PROGRAM_ARB, i, FPEnvPar[i].X, FPEnvPar[i].Y, FPEnvPar[i].Z, FPEnvPar[i].W);
			}
    		glBindProgramARB(GL_FRAGMENT_PROGRAM_ARB, FP);
    		}
		}
        };
};

