class GLBaseObject
{
public:
  int Room;
  GLBaseObject() { }
  virtual ~GLBaseObject() { Destroy(); }
  void Release() { delete this; }
  virtual void Update()
  {
    for( std::list<GLBaseObject*>::iterator i = m_lstChildren.begin();
         i != m_lstChildren.end(); i++ )
    {
      (*i)->Update();
    }
  }
  void Destroy()
  {
    for( std::list<GLBaseObject*>::iterator i = m_lstChildren.begin();
         i != m_lstChildren.end(); i++ )
      (*i)->Release();
  
    m_lstChildren.clear();
  }
  void AddChild( GLBaseObject* pNode )
  {
    m_lstChildren.push_back(pNode);
  }
  void SetRoom(int room)
  {
    Room = room;
    for( std::list<GLBaseObject*>::iterator i = m_lstChildren.begin();
         i != m_lstChildren.end(); i++ )
    {
      (*i)->Room = room;
    }
  }
protected:
  std::list<GLBaseObject*> m_lstChildren;
};

/*
GLBaseSceneObject
Basic 3D object class.
*/
class GLBaseSceneObject: public GLBaseObject
{
public:  
  GLVector3f Scaling;
  GLVector4f Position;
  GLVector3f Rotation;
  GLMatrix LocalMatrix;
  bool UseLocalMatrix;
  GLColor* Color;
  bool UseObjectColor;
  bool Visible;
  bool RoomIndependant;
  GLMaterial* Material;
  //GLMaterial Material2;
  float CustomParameter1;
  float CustomParameter2;
  float CustomParameter3;
  float CustomParameter4;
  GLBaseSceneObject()
  {
    Room = CurrentRoom;
    RoomIndependant = false;
    Color = new GLColor;
    Color->R = 1;
    Color->G = 1;
    Color->B = 1;
    Color->A = 1;
    Material = new GLMaterial;
  	UseObjectColor=false;
  	Visible=true;
	Scaling.X = 1;
    Scaling.Y = 1;
    Scaling.Z = 1;
    Position.X = 0;
    Position.Y = 0;
	Position.Z = 0;
	Position.W = 0;
	Rotation.X = 0;
	Rotation.Y = 0;
	Rotation.Z = 0;
	UseLocalMatrix = false;
	CustomParameter1 = 0;
	CustomParameter2 = 0;
	CustomParameter3 = 0;
	CustomParameter4 = 0;
	//GLMatrix *pointer;
    //LocalMatrix = new GLMatrix;
    //LocalMatrix = *pointer;
	//GLMatrixSetHomogeneous(LocalMatrix);
    //LocalMatrix->Array[0]=1;
    //LocalMatrix->Array[5]=1;
    //LocalMatrix->Array[10]=1;
    //LocalMatrix->Array[15]=1;
  }
  ~GLBaseSceneObject() { }
  void SetColor(float r, float g, float b, float a)
  {
  	Color->R=r;
  	Color->G=g;
  	Color->B=b;
  	Color->A=a;
  }
  void Rotate(float p, float t, float r)
  {
	Rotation.X+=p;
	Rotation.Y+=t;
	Rotation.Z+=r;
  }
  void SetRotation(float p, float t, float r)
  {
	Rotation.X=p;
	Rotation.Y=t;
	Rotation.Z=r;
  }
  void SetPosition(float x, float y, float z)
  {
	Position.X = x;
	Position.Y = y;
	Position.Z = z;
    //GLMatixSetPosition(LocalMatrix,x,y,z);
      //LocalMatrix->Array[12]=x;
      //LocalMatrix->Array[13]=y;
      //LocalMatrix->Array[14]=z;
  }
  void Translate(float x, float y, float z)
  {
	Position.X += x;
	Position.Y += y;
	Position.Z += z;
  }
  void Scale(float x, float y, float z)
  {
	Scaling.X*=x;
	Scaling.Y*=y;
	Scaling.Z*=z;
  }
  void SetScaling(float x, float y, float z)
  {
	Scaling.X=x;
	Scaling.Y=y;
	Scaling.Z=z;
  }
  void FreeFly(float spd)
  {
  	float trad, prad;
  	prad = (Rotation.X / 180 * 3.141592654f);
  	trad = (Rotation.Y / 180 * 3.141592654f);
  	Position.X -= float(sin(trad))*spd;
  	Position.Y += float(sin(prad))*spd;
  	Position.Z -= float(cos(trad))*spd;
  }
  void Move(float spd)
  {
  	float trad, prad;
  	prad = (Rotation.X / 180 * 3.141592654f);
  	trad = (Rotation.Y / 180 * 3.141592654f);
  	Position.X -= float(sin(trad))*spd;
  	Position.Z -= float(cos(trad))*spd;
  }
  void Strafe(float spd)
  {
  	float trad, prad;
  	prad = (Rotation.X / 180 * 3.141592654f);
  	trad = (Rotation.Y / 180 * 3.141592654f);
  	Position.X += float(cos(trad))*spd;
  	Position.Z -= float(sin(trad))*spd;
  }
  void Update()
  {
       if (!UseLocalMatrix)
       {
  	   glTranslatef (Position.X, Position.Y, Position.Z);
  	   glRotatef(Rotation.X, 1.0f, 0.0f, 0.0f);
  	   glRotatef(Rotation.Y, 0.0f, 1.0f, 0.0f);
  	   glRotatef(Rotation.Z, 0.0f, 0.0f, 1.0f);
  	   glScalef(Scaling.X,Scaling.Y,Scaling.Z);
       }
       else glMultMatrixf(LocalMatrix.Array);
  	glColor4f(1,1,1,1);
  	GLBaseObject::Update();
  	Material->Update();
  	if (UseObjectColor) 
  	{
  		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  		glColor4f(Color->R,Color->G,Color->B,Color->A);
  	}
  }
};

/*
GLCamera
Camera object class.
*/
class GLCamera: public GLBaseSceneObject
{
public:
  GLCamera() { }
  ~GLCamera() { }
  void Update()
  { 
  if (RoomIndependant) Room=CurrentRoom;
  glPushMatrix ();
  if (Room==CurrentRoom)
  {
  glTranslatef (Position.X, Position.Y, Position.Z);
  glRotatef(Rotation.Y,  0.0f, 1.0f, 0.0f);
  glRotatef(Rotation.X, 1.0f, 0.0f, 0.0f);
  glRotatef(Rotation.Z,  0.0f, 0.0f, 1.0f);
  glScalef(Scaling.X,Scaling.Y,Scaling.Z);
  }
  GLBaseObject::Update();
  glPopMatrix ();
  }
};

/*
GLLight
Light source object class.
*/
class GLLight: public GLBaseSceneObject
{
public:
  GLfloat Ambient[4];
  GLfloat Diffuse[4];
  GLfloat Specular[4];
  GLfloat LightPosition[4];
  GLenum Light;
  bool Shining;
  void SetDiffuseColor(float r, float g, float b, float a)
  {
  Diffuse[0]=r;
  Diffuse[1]=g;
  Diffuse[2]=b;
  Diffuse[3]=a;
  }
  void SetAmbientColor(float r, float g, float b, float a)
  {
  Ambient[0]=r;
  Ambient[1]=g;
  Ambient[2]=b;
  Ambient[3]=a;
  }
  void SetSpecularColor(float r, float g, float b, float a)
  {
  Specular[0]=r;
  Specular[1]=g;
  Specular[2]=b;
  Specular[3]=a;
  }
  GLLight() 
  {
  Ambient[0]=0;
  Ambient[1]=0;
  Ambient[2]=0;
  Ambient[3]=1;
  Diffuse[0]=1;
  Diffuse[1]=1;
  Diffuse[2]=1;
  Diffuse[3]=1;
  Specular[0]=1;
  Specular[1]=1;
  Specular[2]=1;
  Specular[3]=1;
  LightPosition[0]=Position.X;
  LightPosition[1]=Position.Y;
  LightPosition[2]=Position.Z;
  LightPosition[3]=Position.W;
  Light=GL_LIGHT0;
  Shining=true;
  }
  ~GLLight() { }
  void Update()
  { 
    if (RoomIndependant) Room=CurrentRoom;
    glPushMatrix ();
    GLBaseSceneObject::Update();
    if (Room==CurrentRoom)
    {
    if (Visible) Render();
    }
    Material->PostUpdate();
    glPopMatrix ();
  }
  void Render()
  {
    LightPosition[0]=Position.X;
    LightPosition[1]=Position.Y;
    LightPosition[2]=Position.Z;
    LightPosition[3]=Position.W;
    glEnable(Light);
    glLightfv(Light, GL_AMBIENT,  Ambient);
    glLightfv(Light, GL_DIFFUSE,  Diffuse);
    glLightfv(Light, GL_SPECULAR, Specular);
    glLightfv(Light, GL_POSITION, LightPosition);
  }
};

/*
GLGeometry
3D geometry class template.
*/
class GLGeometry: public GLBaseSceneObject
{
public:
  GLGeometry() { }
  ~GLGeometry() { }
  void Update()
  {
    if (RoomIndependant) Room=CurrentRoom;
    glPushMatrix ();
    GLBaseSceneObject::Update();
    if (Room==CurrentRoom)
    {
    if (Visible) Render();
    }
    Material->PostUpdate();
    glPopMatrix ();
  }
  void Render()
  {
    glBegin (GL_QUADS);
     		glTexCoord2f(1.0f, 0.0f); glNormal3f(0.0f, 1.0f, 0.0f); glVertex3f(-1.0f, 0.0f,-1.0f);
     		glTexCoord2f(1.0f, 1.0f); glNormal3f(0.0f, 1.0f, 0.0f); glVertex3f(-1.0f, 0.0f, 1.0f);
     		glTexCoord2f(0.0f, 1.0f); glNormal3f(0.0f, 1.0f, 0.0f); glVertex3f( 1.0f, 0.0f, 1.0f);
     		glTexCoord2f(0.0f, 0.0f); glNormal3f(0.0f, 1.0f, 0.0f); glVertex3f( 1.0f, 0.0f,-1.0f);
  	glEnd ();
  }
};

/*
GLDummy
Empty object class (used for storing a transformation).
*/
class GLDummy: public GLBaseSceneObject
{
public:
  GLDummy() 
  { 
  Visible=false; 
  }
  ~GLDummy() {}
  void Update()
  {
  if (RoomIndependant) Room=CurrentRoom;
  glPushMatrix ();
  GLBaseSceneObject::Update();
  if (Room==CurrentRoom)
  {
  if (Visible) Render();
  }
  Material->PostUpdate();
  glPopMatrix ();
  }
  void Render() {}
};

/*
GLSphere
Sphere primitive.
*/
class GLSphere: public GLBaseSceneObject
{
public:
  float Size;
  int Slices;
  int Stacks;
  GLUquadricObj * Quadric;
  GLSphere() 
  { 
  Size=1;
  Slices=32;
  Stacks=32;
  Quadric = gluNewQuadric();
  gluQuadricDrawStyle(Quadric, GLU_FILL);
  gluQuadricNormals(Quadric, GLU_SMOOTH);
  gluQuadricTexture(Quadric,GL_TRUE);
  }
  ~GLSphere() { }
  void Update()
  {
  if (RoomIndependant) Room=CurrentRoom;
  glPushMatrix ();
  GLBaseSceneObject::Update();
  if (Room==CurrentRoom)
  {
  if (Visible) Render();
  }
  Material->PostUpdate();
  glPopMatrix ();
  }
  void Render()
  {
  gluSphere(Quadric, Size, Slices, Stacks);
  }
};

/*
GLCylinder
Cylinder primitive.
*/
class GLCylinder: public GLBaseSceneObject
{
public:
  int Slices;
  int Stacks;
  int Loops;
  float Base;
  float Top;
  float Height;
  GLUquadricObj * Quadric;
  GLCylinder() 
  { 
  Slices=32;
  Stacks=32;
  Loops=3;
  Base=0.5;
  Top=0.5;
  Height=1;
  Quadric = gluNewQuadric();
  gluQuadricDrawStyle(Quadric, GLU_FILL);
  gluQuadricNormals(Quadric, GLU_SMOOTH);
  gluQuadricTexture(Quadric,GL_TRUE);
  }
  ~GLCylinder() { }
  void Update()
  {
  if (RoomIndependant) Room=CurrentRoom;
  glPushMatrix ();
  GLBaseSceneObject::Update();
  if (Room==CurrentRoom)
  {
  if (Visible) Render();
  }
  Material->PostUpdate();
  glPopMatrix ();
  }
  void Render()
  {
  glPushMatrix ();     
  glTranslatef(0,0,-Height/2);    
  gluCylinder(Quadric, Base, Top, Height, Slices, Stacks);
  //Material2.Update();
  glTranslatef(0,0,Height);       
  gluPartialDisk (Quadric, 0, Top, Slices, Loops, 0, 360);
  glTranslatef(0,0,-Height);
  glRotatef(180,0,1,0);       
  gluPartialDisk (Quadric, 0, Base, Slices, Loops, 0, 360);
  glPopMatrix ();
  //Material2.PostUpdate();
  }
};

/*
GLModel
*/
class GLModel: public GLBaseSceneObject
{
public:
  struct Mesh
    {
	int m_materialIndex;
	int m_numTriangles;
	int *m_pTriangleIndices;
    };
  struct Triangle
	{
    float m_vertexNormals[3][3];
	float m_s[3], m_t[3];
	int m_vertexIndices[3];
    };
  struct Vertex
	{
	char m_boneID;	// for skeletal animation
	float m_location[3];
	};
  GLModel();
  ~GLModel();
  virtual bool loadModelData( const char *filename ) = 0;
  void Update()
  {
  if (RoomIndependant) Room=CurrentRoom;
  glPushMatrix ();
  GLBaseSceneObject::Update();
  if (Room==CurrentRoom)
  {
  if (Visible) Render();
  }
  Material->PostUpdate();
  glPopMatrix ();
  }
  void Render();
  protected:
    int m_numMeshes;
	Mesh *m_pMeshes;

	int m_numTriangles;
	Triangle *m_pTriangles;

	int m_numVertices;
	Vertex *m_pVertices;
};

GLModel::GLModel()
{
	m_numMeshes = 0;
	m_pMeshes = NULL;
	m_numTriangles = 0;
	m_pTriangles = NULL;
	m_numVertices = 0;
	m_pVertices = NULL;
}

GLModel::~GLModel()
{
	int i;
	for ( i = 0; i < m_numMeshes; i++ )
		delete[] m_pMeshes[i].m_pTriangleIndices;

	m_numMeshes = 0;
	if ( m_pMeshes != NULL )
	{
		delete[] m_pMeshes;
		m_pMeshes = NULL;
	}

	m_numTriangles = 0;
	if ( m_pTriangles != NULL )
	{
		delete[] m_pTriangles;
		m_pTriangles = NULL;
	}

	m_numVertices = 0;
	if ( m_pVertices != NULL )
	{
		delete[] m_pVertices;
		m_pVertices = NULL;
	}
}

void GLModel::Render() 
{
	for ( int i = 0; i < m_numMeshes; i++ )
	{
		glBegin( GL_TRIANGLES );
		{
			for ( int j = 0; j < m_pMeshes[i].m_numTriangles; j++ )
			{
				int triangleIndex = m_pMeshes[i].m_pTriangleIndices[j];
				const Triangle* pTri = &m_pTriangles[triangleIndex];

				for ( int k = 0; k < 3; k++ )
				{
					int index = pTri->m_vertexIndices[k];

					glNormal3fv( pTri->m_vertexNormals[k] );
					glTexCoord2f( pTri->m_s[k], pTri->m_t[k] );
					glVertex3fv( m_pVertices[index].m_location );
				}
			}
		}
		glEnd();
	}
}

struct UserModelVertex
{
GLfloat pos[3];
GLfloat nor[3];
GLfloat tex[3];
};

class GLUserModel: public GLBaseSceneObject
{
public:
  UserModelVertex Vertices[255]; 
  int NumVertices;
  GLUserModel() 
  {
   NumVertices = 0; 
  }
  ~GLUserModel() { }
  void AddVertex(GLfloat x, GLfloat y, GLfloat z, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat u, GLfloat v)
  {
  NumVertices++;
  Vertices[NumVertices].pos[0]=x;
  Vertices[NumVertices].pos[1]=y;
  Vertices[NumVertices].pos[2]=z;
  Vertices[NumVertices].nor[0]=nx;
  Vertices[NumVertices].nor[1]=ny;
  Vertices[NumVertices].nor[2]=nz;
  Vertices[NumVertices].tex[0]=u;
  Vertices[NumVertices].tex[1]=v;
  }
  void Update()
  {
    if (RoomIndependant) Room=CurrentRoom;
    glPushMatrix ();
    GLBaseSceneObject::Update();
    if (Room==CurrentRoom)
    {
    if (Visible) Render();
    }
    Material->PostUpdate();
    glPopMatrix ();
  }
  void Render()
  {
    glBegin (GL_TRIANGLES);
    for (int i=1; i<NumVertices+1; i++)
    {
  		glTexCoord2f(Vertices[i].tex[0], Vertices[i].tex[1]); 
        glNormal3f(Vertices[i].nor[0], Vertices[i].nor[1], Vertices[i].nor[2]);        
        glVertex3f(Vertices[i].pos[0], Vertices[i].pos[1], Vertices[i].pos[2]);
  	}
  	glEnd ();
  }
};

/*
GLOpenObject
*/
class GLOpenObject: public GLBaseSceneObject
{
public:
  GLOpenObject() { }
  ~GLOpenObject() { }
  void Update()
  {
    if (RoomIndependant) Room=CurrentRoom;
    glPushMatrix ();
    GLBaseSceneObject::Update();
    //if (Room==CurrentRoom)
    //{
    //if (Visible) Render();
    //}
  }
  void EndUpdate()
  {
    Material->PostUpdate();
    glPopMatrix ();
  }
};
