/*
GLMaterial
Material class.
*/
class GLMaterial
{
public:
  GLColor* Color;
  GLfloat ColorAmbient[4];
  GLfloat ColorDiffuse[4];
  GLfloat ColorSpecular[4];
  GLfloat HighShininess[4];
  bool TextureEnabled;
  GLTexture* Texture;
  GLShader* Shader;
  int TextureMappingMode;
  int BlendingMode;
  bool LightingEnabled;
  bool ShaderEnabled;
  GLMaterial() 
  { 
    TextureEnabled=false;
    TextureMappingMode=tmmDefault;
    BlendingMode=bmAlpha;
    LightingEnabled=true;
    ShaderEnabled=false;
    Color = new GLColor;
    Color->R = 1; Color->G = 1; Color->B = 1; Color->A = 1;
    ColorAmbient[0] = 0.7f; 
    ColorAmbient[1] = 0.7f; 
    ColorAmbient[2] = 0.7f; 
    ColorAmbient[3] = 1.0f; 
    ColorDiffuse[0] = 0.8f; 
    ColorDiffuse[1] = 0.8f; 
    ColorDiffuse[2] = 0.8f; 
    ColorDiffuse[3] = 1.0f; 
    ColorSpecular[0] = 1.0f; 
    ColorSpecular[1] = 1.0f; 
    ColorSpecular[2] = 1.0f; 
    ColorSpecular[3] = 1.0f;
    HighShininess[0] = 10.0f;
    Shader = new GLShader;
    Texture = new GLTexture;
  }
  ~GLMaterial() { }
  void Update()
  { 
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  if (BlendingMode==bmAdditive) {glBlendFunc(GL_SRC_ALPHA, GL_SRC_ALPHA);}
  if (BlendingMode==bmAdditive2) {glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR);}   
  glMaterialfv(GL_FRONT, GL_AMBIENT,   ColorAmbient);
  glMaterialfv(GL_FRONT, GL_DIFFUSE,   ColorDiffuse);
  glMaterialfv(GL_FRONT, GL_SPECULAR,  ColorSpecular);
  glMaterialfv(GL_FRONT, GL_SHININESS, HighShininess);
  glColor4f(Color->R,Color->G,Color->B,Color->A); 
  if (!LightingEnabled) glDisable(GL_LIGHTING);
  else glEnable(GL_LIGHTING);
  if (TextureEnabled) 
     {
          glEnable(GL_TEXTURE_2D);
          glBindTexture(GL_TEXTURE_2D, Texture->ID);
             if (TextureMappingMode==tmmSphere)
             {
               glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
               glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
               glEnable(GL_TEXTURE_GEN_S);
               glEnable(GL_TEXTURE_GEN_T);
             }
     }
  //#ifndef WIN32
  //glDisable(GL_VERTEX_PROGRAM_ARB);
  //glDisable(GL_FRAGMENT_PROGRAM_ARB);
  //#endif
  if (ShaderEnabled) Shader->Update();
  }
  void PostUpdate()
  {
     //#ifndef WIN32
     glDisable(GL_VERTEX_PROGRAM_ARB);
     glDisable(GL_FRAGMENT_PROGRAM_ARB);
     //#endif
     glDisable(GL_TEXTURE_GEN_S);
     glDisable(GL_TEXTURE_GEN_T);
     //glDisable(GL_LIGHTING);
     glDisable(GL_TEXTURE_2D);
     glColor4f(1,1,1,1);
  }
};
