const int bmAlpha=0;
const int bmAdditive=1;
const int bmAdditive2=2;
const int tmmDefault=0;
const int tmmSphere=1;

const int hdpCenter=0;
const int hdpUpperLeft=1;
const int hdpUpperRight=2;
const int hdpLowerLeft=3;
const int hdpLowerRight=4;

const int ilfNoFilter=0;
const int ilfGaussianBlur=1;
const int ilfNegative=2;
const int ilfEmboss=3;
const int ilfAlien=4;
const int ilfPixelize=5;
const int ilfAvgBlur=6;
const int ilfEdgeDetectE=7;
const int ilfEdgeDetectP=8;
const int ilfEdgeDetectS=9;
const int ilfSharpen=10;
const int ilfMirror=11;
const int ilfContrast=12;
const int ilfGammaCorrect=13;
const int ilfRotate=14;
const int ilfWave=15;
const int ilfScale=16;
const int ilfEqualize=17;

struct GLVector3f
{
  float X;
  float Y;
  float Z; 
};

struct GLVector4f
{
  float X;
  float Y;
  float Z;
  float W; 
};

struct GLMatrix
{
  GLfloat Array[16];
};

struct GLVector
{
  GLfloat Array[4];
};

struct GLColor
{
  float R;
  float G;
  float B;
  float A; 
};

struct GLVertex
{
  GLVector3f Position;
  GLVector3f Normal;
  GLVector3f TexCoord;
  GLColor    Color; 
};

struct GLTriangle
{
  GLVertex Vertex1;
  GLVertex Vertex2;
  GLVertex Vertex3; 
};

struct GLExecValue
{
  double V1;
  double V2;
  double V3;
  double V4;
};

void GLMatrixSetHomogeneous(GLMatrix* pointer)
{
  pointer->Array[0]=1;
  pointer->Array[1]=0;
  pointer->Array[2]=0;
  pointer->Array[3]=0;
  pointer->Array[4]=0;
  pointer->Array[5]=1;
  pointer->Array[6]=0;
  pointer->Array[7]=0;
  pointer->Array[8]=0;
  pointer->Array[9]=0;
  pointer->Array[10]=1;
  pointer->Array[11]=0;
  pointer->Array[12]=0;
  pointer->Array[13]=0;
  pointer->Array[14]=0;
  pointer->Array[15]=1;
  return;
}

void GLMatixSetPosition(GLMatrix* pointer, float x, float y, float z)
{
  pointer->Array[12]=x;
  pointer->Array[13]=y;
  pointer->Array[14]=z;
  return;
}

class GLExecList
{
public:
  GLExecList() { }
  virtual ~GLExecList() { }
  void AddValue( double v1, double v2, double v3, double v4 )
  {
    GLExecValue *value;
    value = new GLExecValue;
    value->V1 = v1;
    value->V2 = v2;
    value->V3 = v3;
    value->V4 = v4;
    Values.push_back(value);
  }
  std::list<GLExecValue*> Values;
};

char *ReadTextFile( const char *fileName )
{
    FILE *file = fopen( fileName, "r" );
    if( file == NULL ) return 0;
    struct stat fileStats;
    if( stat( fileName, &fileStats ) != 0 ) return 0;
    char *buffer = new char[fileStats.st_size];
	int bytes = fread( buffer, 1, fileStats.st_size, file );
    buffer[bytes] = 0;
	fclose( file );
	return buffer;
}

int supportsExtension(const char* extensionString){
  const char* extensions = (const char*)glGetString(GL_EXTENSIONS);
  return (extensions && extensionString &&
    #ifdef __cplusplus
      std::strstr(extensions,extensionString)
    #else
      strstr(extensions,extensionString)
    #endif
  );
}

bool vp_supported=true;
bool fp_supported=true;

#define GL_VERTEX_PROGRAM_ARB             0x8620
#define GL_FRAGMENT_PROGRAM_ARB           0x8804
#define GL_PROGRAM_FORMAT_ASCII_ARB       0x8875
#define GL_PROGRAM_ERROR_STRING_ARB       0x8874
PFNGLGENPROGRAMSARBPROC glGenProgramsARB;
PFNGLBINDPROGRAMARBPROC glBindProgramARB;
PFNGLPROGRAMSTRINGARBPROC glProgramStringARB;
PFNGLPROGRAMENVPARAMETER4FARBPROC glProgramEnvParameter4fARB;
