export double SphereCreate(double radius, double slices, double stacks, double parent)
{
    GLSphere *pointer;
    pointer = new GLSphere;
    if (parent == 0) SceneRoot.AddChild(pointer);
    else 
    {
    GLBaseObject *pointer_parent;
    pointer_parent = reinterpret_cast<GLBaseObject*>((int)parent);
    pointer_parent->AddChild(pointer);
    }
    pointer->Size = radius;
    pointer->Slices = (int)slices;
    pointer->Stacks = (int)stacks;
    return (double)reinterpret_cast<int>(pointer);
}

export double SphereSetRadius(double sphere, double radius)
{
    GLSphere *pointer;
    pointer = reinterpret_cast<GLSphere*>((int)sphere);
    pointer->Size = radius;
    return 1;
}

export double SphereSetQuality(double sphere, double slices, double stacks)
{
    GLSphere *pointer;
    pointer = reinterpret_cast<GLSphere*>((int)sphere);
    pointer->Slices = (int)slices;
    pointer->Stacks = (int)stacks;
    return 1;
}

export double CylinderCreate(double topradius, 
                             double bottomradius, 
                             double height,
                             double slices, 
                             double stacks, 
                             double loops,
                             double parent)
{
    GLCylinder *pointer;
    pointer = new GLCylinder;
    if (parent == 0) SceneRoot.AddChild(pointer);
    else 
    {
    GLBaseObject *pointer_parent;
    pointer_parent = reinterpret_cast<GLBaseObject*>((int)parent);
    pointer_parent->AddChild(pointer);
    }
    pointer->Top = topradius;
    pointer->Base = bottomradius;
    pointer->Height = height;
    pointer->Slices = (int)slices;
    pointer->Stacks = (int)stacks;
    pointer->Loops = (int)loops;
    return (double)reinterpret_cast<int>(pointer);
}

export double DummyCreate(double parent)
{
    GLDummy *pointer;
    pointer = new GLDummy;
    if (parent == 0) SceneRoot.AddChild(pointer);
    else 
    {
    GLBaseObject *pointer_parent;
    pointer_parent = reinterpret_cast<GLBaseObject*>((int)parent);
    pointer_parent->AddChild(pointer);
    }
    return (double)reinterpret_cast<int>(pointer);
}

