export double MatrixCreate()
{
    GLMatrix *pointer;
    pointer = new GLMatrix;
    return (double)reinterpret_cast<int>(pointer);
}

export double MatrixSetList(double matrix, double list)
{
    GLMatrix *pointer;
    pointer = reinterpret_cast<GLMatrix*>((int)matrix);
    GLExecList *execlist;
    execlist = reinterpret_cast<GLExecList*>((int)list);
    int ii = 0;
    for( std::list<GLExecValue*>::iterator i = execlist->Values.begin(); i != execlist->Values.end(); i++ )
     {
     pointer->Array[ii] =   (*i)->V1;
     pointer->Array[ii+1] = (*i)->V2;
     pointer->Array[ii+2] = (*i)->V3;
     pointer->Array[ii+3] = (*i)->V4;
     ii = ii+4;
     }
    return 1;
}

export double MatrixSetValue(double matrix, double ind, double value)
{
    GLMatrix *pointer;
    pointer = reinterpret_cast<GLMatrix*>((int)matrix);
    pointer->Array[(int)ind]=(float)value;
    return 1;
}

export double MatrixSetHomogeneous(double matrix)
{
    GLMatrix *pointer;
    pointer = reinterpret_cast<GLMatrix*>((int)matrix);
    GLMatrixSetHomogeneous(pointer);
    return 1;
}

export double MatrixSetPosition(double matrix, double x, double y, double z)
{
    GLMatrix *pointer;
    pointer = reinterpret_cast<GLMatrix*>((int)matrix);
    GLMatixSetPosition(pointer,x,y,z);
    return 1;
}

export double MatrixSetScaling(double matrix, double x, double y, double z)
{
    GLMatrix *pointer;
    pointer = reinterpret_cast<GLMatrix*>((int)matrix);
    pointer->Array[0]=(float)x;
    pointer->Array[5]=(float)y;
    pointer->Array[10]=(float)z;
    return 1;
}

export double MatrixSetRotationX(double matrix, double angle)
{
    GLMatrix *pointer;
    pointer = reinterpret_cast<GLMatrix*>((int)matrix);
    pointer->Array[5]=(float)cos(angle*(PI/180));
    pointer->Array[9]=(float)sin(angle*(PI/180));
    pointer->Array[6]=(float)(-sin(angle*(PI/180)));
    pointer->Array[10]=(float)cos(angle*(PI/180));
    return 1;
}

export double MatrixSetRotationY(double matrix, double angle)
{
    GLMatrix *pointer;
    pointer = reinterpret_cast<GLMatrix*>((int)matrix);
    pointer->Array[0]=(float)cos(angle*(PI/180));
    pointer->Array[8]=(float)(-sin(angle*(PI/180)));
    pointer->Array[2]=(float)sin(angle*(PI/180));
    pointer->Array[10]=(float)cos(angle*(PI/180));
    return 1;
}

export double MatrixSetRotationZ(double matrix, double angle)
{
    GLMatrix *pointer;
    pointer = reinterpret_cast<GLMatrix*>((int)matrix);
    pointer->Array[0]=(float)cos(angle*(PI/180));
    pointer->Array[1]=(float)(-sin(angle*(PI/180)));
    pointer->Array[4]=(float)sin(angle*(PI/180));
    pointer->Array[5]=(float)cos(angle*(PI/180));
    return 1;
}

export double MatrixMultiply(double matrix1, double matrix2)
{
    GLMatrix *pmatrix1;
    pmatrix1 = reinterpret_cast<GLMatrix*>((int)matrix1);
    GLMatrix *pmatrix2;
    pmatrix2 = reinterpret_cast<GLMatrix*>((int)matrix2);

    GLfloat Array[16];
    
    Array[0]=(pmatrix1->Array[0])*(pmatrix2->Array[0])
            +(pmatrix1->Array[4])*(pmatrix2->Array[1])
            +(pmatrix1->Array[8])*(pmatrix2->Array[2])
            +(pmatrix1->Array[12])*(pmatrix2->Array[3]);
    Array[1]=(pmatrix1->Array[1])*(pmatrix2->Array[0])
            +(pmatrix1->Array[5])*(pmatrix2->Array[1])
            +(pmatrix1->Array[9])*(pmatrix2->Array[2])
            +(pmatrix1->Array[13])*(pmatrix2->Array[3]);
    Array[2]=(pmatrix1->Array[2])*(pmatrix2->Array[0])
            +(pmatrix1->Array[6])*(pmatrix2->Array[1])
            +(pmatrix1->Array[10])*(pmatrix2->Array[2])
            +(pmatrix1->Array[14])*(pmatrix2->Array[3]);
    Array[3]=(pmatrix1->Array[3])*(pmatrix2->Array[0])
            +(pmatrix1->Array[7])*(pmatrix2->Array[1])
            +(pmatrix1->Array[11])*(pmatrix2->Array[2])
            +(pmatrix1->Array[15])*(pmatrix2->Array[3]);
            
    Array[4]=(pmatrix1->Array[0])*(pmatrix2->Array[4])
            +(pmatrix1->Array[4])*(pmatrix2->Array[5])
            +(pmatrix1->Array[8])*(pmatrix2->Array[6])
            +(pmatrix1->Array[12])*(pmatrix2->Array[7]);
    Array[5]=(pmatrix1->Array[1])*(pmatrix2->Array[4])
            +(pmatrix1->Array[5])*(pmatrix2->Array[5])
            +(pmatrix1->Array[9])*(pmatrix2->Array[6])
            +(pmatrix1->Array[13])*(pmatrix2->Array[7]);
    Array[6]=(pmatrix1->Array[2])*(pmatrix2->Array[4])
            +(pmatrix1->Array[6])*(pmatrix2->Array[5])
            +(pmatrix1->Array[10])*(pmatrix2->Array[6])
            +(pmatrix1->Array[14])*(pmatrix2->Array[7]);
    Array[7]=(pmatrix1->Array[3])*(pmatrix2->Array[4])
            +(pmatrix1->Array[7])*(pmatrix2->Array[5])
            +(pmatrix1->Array[11])*(pmatrix2->Array[6])
            +(pmatrix1->Array[15])*(pmatrix2->Array[7]);

    Array[8]=(pmatrix1->Array[0])*(pmatrix2->Array[8])
            +(pmatrix1->Array[4])*(pmatrix2->Array[9])
            +(pmatrix1->Array[8])*(pmatrix2->Array[10])
            +(pmatrix1->Array[12])*(pmatrix2->Array[11]);
    Array[9]=(pmatrix1->Array[1])*(pmatrix2->Array[8])
            +(pmatrix1->Array[5])*(pmatrix2->Array[9])
            +(pmatrix1->Array[9])*(pmatrix2->Array[10])
            +(pmatrix1->Array[13])*(pmatrix2->Array[11]);
    Array[10]=(pmatrix1->Array[2])*(pmatrix2->Array[8])
            +(pmatrix1->Array[6])*(pmatrix2->Array[9])
            +(pmatrix1->Array[10])*(pmatrix2->Array[10])
            +(pmatrix1->Array[14])*(pmatrix2->Array[11]);
    Array[11]=(pmatrix1->Array[3])*(pmatrix2->Array[8])
            +(pmatrix1->Array[7])*(pmatrix2->Array[9])
            +(pmatrix1->Array[11])*(pmatrix2->Array[10])
            +(pmatrix1->Array[15])*(pmatrix2->Array[11]);
            
    Array[12]=(pmatrix1->Array[0])*(pmatrix2->Array[12])
            +(pmatrix1->Array[4])*(pmatrix2->Array[13])
            +(pmatrix1->Array[8])*(pmatrix2->Array[14])
            +(pmatrix1->Array[12])*(pmatrix2->Array[15]);
    Array[13]=(pmatrix1->Array[1])*(pmatrix2->Array[12])
            +(pmatrix1->Array[5])*(pmatrix2->Array[13])
            +(pmatrix1->Array[9])*(pmatrix2->Array[14])
            +(pmatrix1->Array[13])*(pmatrix2->Array[15]);
    Array[14]=(pmatrix1->Array[2])*(pmatrix2->Array[12])
            +(pmatrix1->Array[6])*(pmatrix2->Array[13])
            +(pmatrix1->Array[10])*(pmatrix2->Array[14])
            +(pmatrix1->Array[14])*(pmatrix2->Array[15]);
    Array[15]=(pmatrix1->Array[3])*(pmatrix2->Array[12])
            +(pmatrix1->Array[7])*(pmatrix2->Array[13])
            +(pmatrix1->Array[11])*(pmatrix2->Array[14])
            +(pmatrix1->Array[15])*(pmatrix2->Array[15]);
            
    for (int i=0; i!=16; i++) pmatrix1->Array[i]=Array[i];
            
    return 1;
}

export double ObjectUseLocalMatrix(double object, double mode)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    if (mode==0) pointer->UseLocalMatrix = false;
    if (mode==1) pointer->UseLocalMatrix = true;
    return 1;
}

export double ObjectSetLocalMatrix(double object, double matrix)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    GLMatrix *pmatrix;
    pmatrix = reinterpret_cast<GLMatrix*>((int)matrix);
    pointer->LocalMatrix = *pmatrix;
    return 1;
}

export double ObjectHide(double object)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Visible = false;
    return 1;
}

export double ObjectShow(double object)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Visible = true;
    return 1;
}

export double ObjectSetRoomIndependant(double object, double mode)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    if (mode==0) pointer->RoomIndependant=false;
    if (mode==1) pointer->RoomIndependant=true;
    return 1;
}

export double ObjectSetRoom(double object, double room)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->SetRoom((int)room);
    return 1;
}

export double ObjectGetRoom(double object)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    int room = pointer->Room;
    return (double)room;
}

export double ObjectSetPosition(double object, double x, double y, double z, double w)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Position.X = (float)x;
    pointer->Position.Y = (float)y;
    pointer->Position.Z = (float)z;
    pointer->Position.W = (float)w;
    return 1;
}

export double ObjectRotate(double object, double x, double y, double z)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Rotate((float)x, (float)y, (float)z);
    return 1;
}

export double ObjectPitch(double object, double angle)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Rotation.X+=(float)angle;
    return 1;
}

export double ObjectTurn(double object, double angle)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Rotation.Y+=(float)angle;
    return 1;
}

export double ObjectRoll(double object, double angle)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Rotation.Z+=(float)angle;
    return 1;
}

export double ObjectSetRotation(double object, double x, double y, double z)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->SetRotation((float)x, (float)y, (float)z);
    return 1;
}

export double ObjectMove(double object, double speed)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Move((float)speed);
    return 1;
}

export double ObjectFreeFly(double object, double speed)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->FreeFly((float)speed);
    return 1;
}

export double ObjectStrafe(double object, double speed)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Strafe((float)speed);
    return 1;
}

export double ObjectScale(double object, double x, double y, double z)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Scale((float)x, (float)y, (float)z);
    return 1;
}

export double ObjectSetScaling(double object, double x, double y, double z)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->SetScaling((float)x, (float)y, (float)z);
    return 1;
}



