export double MaterialCreate()
{
    GLMaterial *pointer;
    pointer = new GLMaterial;
    return (double)reinterpret_cast<int>(pointer);
}

export double ObjectSetMaterial(double object, double material)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    GLMaterial *m_pointer;
    m_pointer = reinterpret_cast<GLMaterial*>((int)material);
    pointer->Material = m_pointer;
    return 1;
}

export double MaterialSetColor(double material, double color)
{
    GLMaterial *m_pointer;
    m_pointer = reinterpret_cast<GLMaterial*>((int)material);
    GLColor *pointer;
    pointer = reinterpret_cast<GLColor*>((int)color);
    m_pointer->Color = pointer;
    return 1;
}

export double MaterialSetAmbient(double material, double r, double g, double b, double a)
{
    GLMaterial *m_pointer;
    m_pointer = reinterpret_cast<GLMaterial*>((int)material);
    m_pointer->ColorAmbient[0] = r/255;
    m_pointer->ColorAmbient[1] = g/255;
    m_pointer->ColorAmbient[2] = b/255;
    m_pointer->ColorAmbient[3] = a;
    return 1;
}

export double MaterialSetDiffuse(double material, double r, double g, double b, double a)
{
    GLMaterial *m_pointer;
    m_pointer = reinterpret_cast<GLMaterial*>((int)material);
    m_pointer->ColorDiffuse[0] = r/255;
    m_pointer->ColorDiffuse[1] = g/255;
    m_pointer->ColorDiffuse[2] = b/255;
    m_pointer->ColorDiffuse[3] = a;
    return 1;
}

export double MaterialSetSpecular(double material, double r, double g, double b, double a)
{
    GLMaterial *m_pointer;
    m_pointer = reinterpret_cast<GLMaterial*>((int)material);
    m_pointer->ColorSpecular[0] = r/255;
    m_pointer->ColorSpecular[1] = g/255;
    m_pointer->ColorSpecular[2] = b/255;
    m_pointer->ColorSpecular[3] = a;
    return 1;
}

export double MaterialSetShininess(double material, double shininess)
{
    GLMaterial *m_pointer;
    m_pointer = reinterpret_cast<GLMaterial*>((int)material);
    m_pointer->HighShininess[0] = shininess;
    return 1;
}

export double MaterialSetTexture(double material, double texture)
{
    GLMaterial *m_pointer;
    m_pointer = reinterpret_cast<GLMaterial*>((int)material);
    m_pointer->TextureEnabled=true;
    GLTexture *pointer;
    pointer = reinterpret_cast<GLTexture*>((int)texture);
    m_pointer->Texture = pointer;
    return 1;
}

export double MaterialSetShader(double material, double shader)
{
    GLMaterial *m_pointer;
    m_pointer = reinterpret_cast<GLMaterial*>((int)material);
    GLShader *pointer;
    pointer = reinterpret_cast<GLShader*>((int)shader);
    m_pointer->Shader = pointer;
    m_pointer->ShaderEnabled = true;
    return 1;
}
