#define export extern "C" __declspec( dllexport )

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <list>
#include <math.h>
#include <windows.h>
/*
#include <IL/il.h>
#include <IL/ilu.h>
#include <IL/ilut.h>
*/
#include "include/GLDevIL.h" /*-lILU -lILUT -lDevIL*/
#include <gl/gl.h>
#include <gl/glu.h>
#include "include/glext.h"

#define PI 3.1415926536

#include <fstream>
using namespace std;
using std::ifstream;
using std::ios;

int CurrentRoom = 0;

#include "include/GLEngine.h"
#include "include/GLShader.h"
#include "include/GLTexture.h"
#include "include/GLMaterial.h"
#include "include/GLObjects.h"
#include "include/GLModelMS3D.h"
#include "include/GLWater.h"
#include "include/GLOde.h"

HDC hDC;
HGLRC hRC;
HWND hWnd;

int gl_vx = 0;
int gl_vy = 0;
int gl_vw = 640;
int gl_vh = 480;
GLfloat gl_znear = 0.1;
GLfloat gl_zfar = 500;

GLBaseObject SceneRoot;

#include "Engine.cpp"
#include "Camera.cpp"
#include "Object.cpp"
#include "Quad.cpp"
#include "Color.cpp"
#include "ODE.cpp"
#include "Primitives.cpp"
#include "DevIL.cpp"
#include "List.cpp"
#include "Material.cpp"
#include "Shader.cpp"
#include "OpenGL.cpp"

export double OpenObjectCreate()
{
    GLOpenObject *pointer;
    pointer = new GLOpenObject;
    return (double)reinterpret_cast<int>(pointer);
}

export double OpenObjectBeginUpdate(double object)
{
    GLOpenObject *pointer;
    pointer = reinterpret_cast<GLOpenObject*>((int)object);
    pointer->Update();
    return 1;
}

export double OpenObjectEndUpdate(double object)
{
    GLOpenObject *pointer;
    pointer = reinterpret_cast<GLOpenObject*>((int)object);
    pointer->EndUpdate();
    return 1;
}

export double UserModelAddVertex(double model, double x, double y, double z, double nx, double ny, double nz, double u, double v)
{
    GLUserModel *pointer;
    pointer = reinterpret_cast<GLUserModel*>((int)model);
    pointer->AddVertex(x,y,z,nx,ny,nz,u,v);
    return 1;
}

export double UserModelCreate(double parent)
{
    GLUserModel *pointer;
    pointer = new GLUserModel;
    if (parent == 0) SceneRoot.AddChild(pointer);
    else 
    {
    GLBaseObject *pointer_parent;
    pointer_parent = reinterpret_cast<GLBaseObject*>((int)parent);
    pointer_parent->AddChild(pointer);
    }
    return (double)reinterpret_cast<int>(pointer);
}

export double WaterCreate(double parent)
{
    GLWater *pointer;
    pointer = new GLWater;
    if (parent == 0) SceneRoot.AddChild(pointer);
    else 
    {
    GLBaseObject *pointer_parent;
    pointer_parent = reinterpret_cast<GLBaseObject*>((int)parent);
    pointer_parent->AddChild(pointer);
    }
    return (double)reinterpret_cast<int>(pointer);
}

export double ModelMS3DCreate(PCHAR filename, double parent)
{
    GLModelMS3D *pointer;
    pointer = new GLModelMS3D;
    if (parent == 0) SceneRoot.AddChild(pointer);
    else 
    {
    GLBaseObject *pointer_parent;
    pointer_parent = reinterpret_cast<GLBaseObject*>((int)parent);
    pointer_parent->AddChild(pointer);
    }
    pointer->loadModelData(filename);
    return (double)reinterpret_cast<int>(pointer);
}

export double RoomCreate()
{
    int room = CurrentRoom++;
    return (double)room;
}

export double RoomSetActive(double room)
{
    CurrentRoom = (int)room;
    return 1;
}

export double RoomGetActive()
{
    return (double)CurrentRoom;
}

export double LightCreate(double parent)
{
    GLLight *pointer;
    pointer = new GLLight;
    if (parent == 0) SceneRoot.AddChild(pointer);
    else 
    {
    GLBaseObject *pointer_parent;
    pointer_parent = reinterpret_cast<GLBaseObject*>((int)parent);
    pointer_parent->AddChild(pointer);
    }
    //pointer->Light = GL_LIGHT0;
    return (double)reinterpret_cast<int>(pointer);
}

export double LightSetAmbient(double light, double r, double g, double b, double a)
{
    GLLight *pointer;
    pointer = reinterpret_cast<GLLight*>((int)light);
    pointer->SetAmbientColor(r/255,g/255,b/255,a);
    return 1;
}

export double LightSetDiffuse(double light, double r, double g, double b, double a)
{
    GLLight *pointer;
    pointer = reinterpret_cast<GLLight*>((int)light);
    pointer->SetDiffuseColor(r/255,g/255,b/255,a);
    return 1;
}

export double LightSetSpecular(double light, double r, double g, double b, double a)
{
    GLLight *pointer;
    pointer = reinterpret_cast<GLLight*>((int)light);
    pointer->SetSpecularColor(r/255,g/255,b/255,a);
    return 1;
}

export double ShowMessage(PCHAR mtext, PCHAR mcaption)
{
	return MessageBox(GetActiveWindow(),mtext,mcaption,MB_OK);
}

export PCHAR StringAppend(PCHAR string1, PCHAR string2)
{
return strcat(string1,string2);
}
