export double EngineCreate(double window_handle)
{
    hWnd = (HWND)(int)window_handle;
    
    hDC = GetDC( hWnd );
    
    PIXELFORMATDESCRIPTOR pfd;
    ZeroMemory( &pfd, sizeof( pfd ) );
    pfd.nSize = sizeof( pfd );
    pfd.nVersion = 1;
    pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
    pfd.iPixelType = PFD_TYPE_RGBA;
    pfd.cColorBits = 24;
    pfd.cDepthBits = 16;
    pfd.iLayerType = PFD_MAIN_PLANE;
    int iFormat = ChoosePixelFormat( hDC, &pfd );
    SetPixelFormat( hDC, iFormat, &pfd );

    hRC = wglCreateContext( hDC );
    wglMakeCurrent( hDC, hRC );
    
    glEnable(GL_CULL_FACE);
    glCullFace(GL_BACK);
    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);
    glEnable(GL_NORMALIZE);
    glEnable(GL_COLOR_MATERIAL);
    glEnable(GL_LIGHTING);
    glEnable(GL_TEXTURE_2D);
    glEnable (GL_BLEND);
    
    glGenProgramsARB=(PFNGLGENPROGRAMSARBPROC)wglGetProcAddress("glGenProgramsARB");
    glBindProgramARB=(PFNGLBINDPROGRAMARBPROC)wglGetProcAddress("glBindProgramARB");
    glProgramStringARB=(PFNGLPROGRAMSTRINGARBPROC) wglGetProcAddress("glProgramStringARB");
    glProgramEnvParameter4fARB=(PFNGLPROGRAMENVPARAMETER4FARBPROC) wglGetProcAddress("glProgramEnvParameter4fARB");
    if (!supportsExtension("GL_ARB_vertex_program")) vp_supported=false;
    if (!supportsExtension("GL_ARB_fragment_program")) fp_supported=false;
    
    glViewport(gl_vx,gl_vy,gl_vw,gl_vh);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective (60,(GLfloat)gl_vw/(GLfloat)gl_vh, gl_znear, gl_zfar);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    glClearColor (0.0f, 0.0f, 0.0f, 0.0f);
    
    return 1;
}

export double EngineClearBuffers()
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    return 1;
}

export double EngineUpdateProjection(double object)
{       
    glLoadIdentity();
    //GLfloat Matrix[16];
	//glGetFloatv(GL_MODELVIEW_MATRIX, Matrix);
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    glRotatef(-(pointer->Rotation.X), 1.0f, 0.0f, 0.0f);
    glRotatef(-(pointer->Rotation.Y),  0.0f, 1.0f, 0.0f);
    glRotatef(-(pointer->Rotation.Z),  0.0f, 0.0f, 1.0f);
    glTranslatef(-(pointer->Position.X), -(pointer->Position.Y), -(pointer->Position.Z)); 
    return 1;
}

export double ObjectUpdate(double object)
{
    GLBaseSceneObject *pointer;
    pointer = reinterpret_cast<GLBaseSceneObject*>((int)object);
    pointer->Update();
    return 1;
}

export double EngineUpdateRootObject()
{
    SceneRoot.Update();
    return 1;
}

export double EngineSwapBuffers()
{
    SwapBuffers( hDC );
    //Sleep(2);
    return 1;
}

export double EngineDestroy()
{
    wglMakeCurrent( NULL, NULL );
    wglDeleteContext( hRC );
    ReleaseDC( hWnd, hDC );
}

export double EngineViewerResize(double x, double y, double width, double height)
{
    gl_vx = (int)x;
    gl_vy = (int)y;
    gl_vw = (int)width;
    gl_vh = (int)height;
    glViewport(gl_vx,gl_vy,gl_vw,gl_vh);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective (60,(GLfloat)gl_vw/(GLfloat)gl_vh, gl_znear, gl_zfar);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity() ;
    return 1;
}

export double EngineSetClippingPlanes(double znear, double zfar)
{
    gl_znear = (GLfloat)znear;
    gl_zfar = (GLfloat)zfar;
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective (60,(GLfloat)gl_vw/(GLfloat)gl_vh, gl_znear, gl_zfar);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity() ;
    return 1;
}

export double EngineSetBackgroundColor(double color)
{
    /*
    long red;
    long green;
    long blue;
    red = (long)color & 0xFF;
    green = ((long)color & 0xFF00)/256;
    blue = (long)color/65536;
    glClearColor (
    ((GLfloat)(int)red)/255, 
    ((GLfloat)(int)green)/255, 
    ((GLfloat)(int)blue)/255, 
    0.0f);    
    return 1;
    */
    GLColor *pointer;
    pointer = reinterpret_cast<GLColor*>((int)color);
    glClearColor (
    (GLfloat)(pointer->R),//255,
    (GLfloat)(pointer->G),//255,
    (GLfloat)(pointer->B),//255,
    (GLfloat)(pointer->A)//255
    );
    return 1;
}

/*
export double EngineSetCamera(double camera)
{
    Camera = reinterpret_cast<GLCamera*>((int)camera);
    return 1;
}
*/

export double EngineGetDeviceContext()
{
    return (double)(int)hDC;
}

export double EngineGetRenderContext()
{
    return (double)(int)hRC;
}
