export double ColorGetRGB(double color, double ind)
{
    long red;
    long green;
    long blue;
    red = (long)color & 0xFF;
    green = ((long)color & 0xFF00)/256;
    blue = (long)color/65536;   
    double result = 0;
    if (ind == 0) result = (double)red; 
    if (ind == 1) result = (double)green; 
    if (ind == 2) result = (double)blue; 
    return result;
}

export double ColorCreate(double r, double g, double b, double a)
{
    GLColor *pointer;
    pointer = new GLColor;
    pointer->R = ((float)r)/255;
    pointer->G = ((float)g)/255;
    pointer->B = ((float)b)/255;
    pointer->A = (float)a;
    return (double)reinterpret_cast<int>(pointer);
}

export double ColorGetValue(double color, double ind)
{
    GLColor *pointer;
    pointer = reinterpret_cast<GLColor*>((int)color);
    double result = 0;
    if (ind == 0) result = (double)(pointer->R);
    if (ind == 1) result = (double)(pointer->G);
    if (ind == 2) result = (double)(pointer->B);
    if (ind == 3) result = (double)(pointer->A);
    return result;
}

export double ColorGetFromDecimal(double color, double dec, double alpha)
{
    long red;
    long green;
    long blue;
    red = (long)dec & 0xFF;
    green = ((long)dec & 0xFF00)/256;
    blue = (long)dec/65536;
    GLColor *pointer;
    pointer = reinterpret_cast<GLColor*>((int)color);
    pointer->R = ((float)red)/255;
    pointer->G = ((float)green)/255;
    pointer->B = ((float)blue)/255;
    pointer->A = (float)alpha;
    return 1;
}
