#include <stdio.h>
#include <stdlib.h>
#include <cstdlib>
#include <string.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>
#include "SOIL.h"

#ifdef WIN32
#include <windows.h>
#endif

#include "include/irrklang/irrKlang.h"

#include "include/angelscript.h"
#include "include/add_on/scriptstring/scriptstring.h"
#include "include/add_on/scripthelper/scripthelper.h"
#include "include/add_on/scriptbuilder/scriptbuilder.h"

#include "SDLInterface.h"
#include "P3DCgShader.h"

using namespace std;
using namespace irrklang;

SDLInterface Game;
ISoundEngine* sound_engine;

#undef main

void MessageCallback(const asSMessageInfo *msg, void *param)
{
	const char *type = "ERR ";
	if( msg->type == asMSGTYPE_WARNING )
		type = "WARN";
	else if( msg->type == asMSGTYPE_INFORMATION )
		type = "INFO";

	printf("%s (%d, %d) : %s : %s\n", msg->section, msg->row, msg->col, type, msg->message);
}

void ConsoleOpen()
{
    	#ifdef WIN32
    	AllocConsole();
    	freopen("CONOUT$", "wb", stdout);
    	#endif
}

void ConsoleClose()
{
    	#ifdef WIN32
    	AllocConsole();
    	freopen("CONOUT$", "wb", stdout);
    	#endif
}

void print(string* msg)
{
  	char* text = (char*)msg->c_str();
  	printf("%s", text);
}

void SDLGraphicsInit(unsigned int width, unsigned int height, bool fullscreen, string* title)
{
    char* titlestring = (char*)title->c_str();
	Game.Init(width,height,fullscreen,titlestring);
}

unsigned int SDLWindowGetWidth()
{
    return Game.WindowWidth;
}

unsigned int SDLWindowGetHeight()
{
    return Game.WindowHeight;
}

unsigned int SDLDisplayGetWidth()
{
    return Game.DisplayWidth;
}

unsigned int SDLDisplayGetHeight()
{
    return Game.DisplayHeight;
}

bool SDLKeyboardState(SDLKey key)
{
	return Game.KeyboardState[key];
}

int SDLMouseGetX()
{
	return Game.MouseX;
}

int SDLMouseGetY()
{
	return Game.MouseY;
}

void SDLMouseShowCursor(bool mode)
{
     Game.ShowCursor((unsigned int)mode);
}

bool SDLJoystickButtonState(unsigned int button)
{
	return Game.JoystickButtonState[button];
}

float SDLJoystickAxisValue(unsigned int axis)
{
	return Game.JoystickAxisValue[axis];
}

void SDLSwapBuffers()
{
	Game.SwapBuffers();
}

void SDLCheckInput()
{
	Game.CheckInput();
}

bool SDLExitRequest()
{
	if (Game.ExitSignal != 0) return true;
	else return 0;
}

unsigned int IrrklangSourceLoad(string* filename)
{
	char* file = (char*)filename->c_str();
	irrklang::ISoundSource* sound = sound_engine->addSoundSourceFromFile(file);
	return reinterpret_cast<unsigned int>(sound);
}

void IrrklangSourcePlay2D(unsigned int sound)
{
	irrklang::ISoundSource* Sound = reinterpret_cast<irrklang::ISoundSource*>(sound);
	sound_engine->play2D(Sound);
}

void IrrklangSourceSetVolume(unsigned int sound, float vol)
{
	irrklang::ISoundSource* Sound = reinterpret_cast<irrklang::ISoundSource*>(sound);
	Sound->setDefaultVolume(vol);
}

unsigned int IrrklangSourceCopy(unsigned int sound)
{
	irrklang::ISoundSource* Sound1 = reinterpret_cast<irrklang::ISoundSource*>(sound);
	irrklang::ISoundSource* Sound2 = sound_engine->addSoundSourceAlias(Sound1,"Name");
	return reinterpret_cast<unsigned int>(Sound2);
}

void CgManagerCreate()
{
	CgInit();
}

unsigned int CgShaderCreate(string* vp)
{
	P3DCgShader* CgGreenShader = new P3DCgShader;
	char* vpfile = (char*)vp->c_str();
	CgGreenShader->LoadVertexProgram(vpfile,(char*)"C2E1v_green");
	return reinterpret_cast<unsigned int>(CgGreenShader);
}

void CgShaderApply(unsigned int shader)
{
	P3DCgShader* CgGreenShader = reinterpret_cast<P3DCgShader*>(shader);
	CgGreenShader->BeginUpdate();
}

void CgShaderUnApply(unsigned int shader)
{
	P3DCgShader* CgGreenShader = reinterpret_cast<P3DCgShader*>(shader);
	CgGreenShader->EndUpdate();
}

void CgShaderDestroy(unsigned int shader)
{
	P3DCgShader* CgGreenShader = reinterpret_cast<P3DCgShader*>(shader);
	delete CgGreenShader;
}

unsigned int SOILTextureLoad(string* filename)
{
char* file = (char*)filename->c_str();
GLuint tex_ID = SOIL_load_OGL_texture(file,
		SOIL_LOAD_AUTO,
		SOIL_CREATE_NEW_ID,
		SOIL_FLAG_MIPMAPS | 
                SOIL_FLAG_INVERT_Y | 
                SOIL_FLAG_NTSC_SAFE_RGB | 
                SOIL_FLAG_COMPRESS_TO_DXT );
//GLuint tex_ID = SOIL_load_OGL_texture(filename,forcechannels,SOIL_CREATE_NEW_ID,flagbits);
return tex_ID;
}

void GLClearColor(float x, float y, float z, float w) { glClearColor(x,y,z,w); }
void GLClearDepth(double depth) { glClearDepth(depth); }
void GLDepthFunc(unsigned int func) { glDepthFunc(func); }
void GLShadeModel(unsigned int lighting) { glShadeModel(lighting); }
void GLEnable(unsigned int option) { glEnable(option); }
void GLDisable(unsigned int option) { glDisable(option); }
void GLMatrixMode(unsigned int matrixmode) { glMatrixMode(matrixmode); }
void GLUPerspective(double fovy, double aspect, double zNear, double zFar) { gluPerspective(fovy,aspect,zNear,zFar); }
void GLHint(unsigned int target, unsigned int mode) { glHint(target,mode); }
void GLLoadIdentity() { glLoadIdentity(); }
void GLTranslatef(float x, float y, float z) { glTranslatef(x,y,z); }
void GLRotatef(float angle, float x, float y, float z) { glRotatef(angle,x,y,z); }
void GLBegin(unsigned int primitive) { glBegin(primitive); }
void GLEnd() { glEnd(); }
void GLColor3f(float x, float y, float z) { glColor3f(x,y,z); }
void GLColor4f(float x, float y, float z, float w) { glColor4f(x,y,z,w); }
void GLNormal3f(float x, float y, float z) { glNormal3f(x,y,z); }
void GLTexCoord2f(float x, float y) { glTexCoord2f(x,y); }
void GLVertex3f(float x, float y, float z) { glVertex3f(x,y,z); }
void GLClear(unsigned int bufferbits) { glClear(bufferbits); }

void GLBlendFunc(unsigned int sfactor, unsigned int dfactor) { glBlendFunc(sfactor,dfactor); }
void GLAlphaFunc(unsigned int func, float ref) { glAlphaFunc(func,ref); }
void GLPushMatrix() { glPushMatrix(); }
void GLPopMatrix() { glPopMatrix(); }
void GLBindTexture(unsigned int target, unsigned int texture) { glBindTexture(target,texture); }

char* mainscript;

int main (int argc, char *argv[])
{   
	if (argc>1) mainscript = argv[1];
	else mainscript = (char*)"main.as";

	//Sound
	sound_engine = createIrrKlangDevice();
	if (!sound_engine)
	{
		printf("IrrKlang error: Could not create sound engine\n");
		return 0;
	}

    	asIScriptEngine *engine = asCreateScriptEngine(ANGELSCRIPT_VERSION);
    	CScriptString *p_name = new CScriptString("player");

    	engine->SetMessageCallback(asFUNCTION(MessageCallback), 0, asCALL_CDECL);
    	RegisterScriptString(engine);
    
        //Standart output
    	engine->RegisterGlobalFunction("void ConsoleOpen()", asFUNCTION(ConsoleOpen), asCALL_CDECL);
    	engine->RegisterGlobalFunction("void ConsoleClose()", asFUNCTION(ConsoleClose), asCALL_CDECL);
    	engine->RegisterGlobalFunction("void print(string@ msg)", asFUNCTION(print), asCALL_CDECL);

        //SDL
        engine->RegisterGlobalFunction("void GraphicsInit(uint width, uint height, bool fullscreen, string@ title)", asFUNCTION(SDLGraphicsInit), asCALL_CDECL);
	engine->RegisterGlobalFunction("uint WindowGetWidth()", asFUNCTION(SDLWindowGetWidth), asCALL_CDECL); 
	engine->RegisterGlobalFunction("uint WindowGetHeight()", asFUNCTION(SDLWindowGetHeight), asCALL_CDECL);   	
	engine->RegisterGlobalFunction("uint DisplayGetWidth()", asFUNCTION(SDLDisplayGetWidth), asCALL_CDECL); 
	engine->RegisterGlobalFunction("uint DisplayGetHeight()", asFUNCTION(SDLDisplayGetHeight), asCALL_CDECL);  
	engine->RegisterGlobalFunction("bool KeyboardState(int key)", asFUNCTION(SDLKeyboardState), asCALL_CDECL);
	engine->RegisterGlobalFunction("int MouseGetX()", asFUNCTION(SDLMouseGetX), asCALL_CDECL);
        engine->RegisterGlobalFunction("int MouseGetY()", asFUNCTION(SDLMouseGetY), asCALL_CDECL);
	engine->RegisterGlobalFunction("void MouseShowCursor(bool mode)", asFUNCTION(SDLMouseShowCursor), asCALL_CDECL);
        engine->RegisterGlobalFunction("bool JoystickButtonState(uint key)", asFUNCTION(SDLJoystickButtonState), asCALL_CDECL);
	engine->RegisterGlobalFunction("float JoystickAxisValue(uint axis)", asFUNCTION(SDLJoystickAxisValue), asCALL_CDECL);
    	engine->RegisterGlobalFunction("void SwapBuffers()", asFUNCTION(SDLSwapBuffers), asCALL_CDECL);
    	engine->RegisterGlobalFunction("void CheckInput()", asFUNCTION(SDLCheckInput), asCALL_CDECL);
    	engine->RegisterGlobalFunction("bool ExitRequest()", asFUNCTION(SDLExitRequest), asCALL_CDECL);

	//IrrKlang	
	engine->RegisterGlobalFunction("uint SoundLoad(string@ filename)", asFUNCTION(IrrklangSourceLoad), asCALL_CDECL);
	engine->RegisterGlobalFunction("void SoundPlay2D(uint sound)", asFUNCTION(IrrklangSourcePlay2D), asCALL_CDECL);
	engine->RegisterGlobalFunction("void SoundSetVolume(uint sound, float vol)", asFUNCTION(IrrklangSourceSetVolume), asCALL_CDECL);
	engine->RegisterGlobalFunction("uint SoundCopy(uint sound)", asFUNCTION(IrrklangSourceCopy), asCALL_CDECL);

        //OpenGL
	engine->RegisterGlobalFunction("void glClearColor(float x, float y, float z, float w)", asFUNCTION(GLClearColor), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glClearDepth(double depth)", asFUNCTION(GLClearDepth), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glDepthFunc(uint func)", asFUNCTION(GLDepthFunc), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glShadeModel(uint lighting)", asFUNCTION(GLShadeModel), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glEnable(uint option)", asFUNCTION(GLEnable), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glDisable(uint option)", asFUNCTION(GLDisable), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glMatrixMode(uint matrixmode)", asFUNCTION(GLMatrixMode), asCALL_CDECL);
	engine->RegisterGlobalFunction("void gluPerspective(double fovy, double aspect, double zNear, double zFar)", asFUNCTION(GLUPerspective), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glHint(uint target, uint mode)", asFUNCTION(GLHint), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glLoadIdentity()", asFUNCTION(GLLoadIdentity), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glTranslatef(float x, float y, float z)", asFUNCTION(GLTranslatef), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glRotatef(float angle, float x, float y, float z)", asFUNCTION(GLRotatef), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glBegin(uint primitive)", asFUNCTION(GLBegin), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glEnd()", asFUNCTION(GLEnd), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glColor3f(float x, float y, float z)", asFUNCTION(GLColor3f), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glColor4f(float x, float y, float z, float w)", asFUNCTION(GLColor3f), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glNormal3f(float x, float y, float z)", asFUNCTION(GLNormal3f), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glTexCoord2f(float x, float y)", asFUNCTION(GLTexCoord2f), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glVertex3f(float x, float y, float z)", asFUNCTION(GLVertex3f), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glClear(uint buffer)", asFUNCTION(GLClear), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glBlendFunc(uint sfactor, uint dfactor)", asFUNCTION(GLBlendFunc), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glAlphaFunc(uint func, float ref)", asFUNCTION(GLAlphaFunc), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glPushMatrix()", asFUNCTION(GLPushMatrix), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glPopMatrix()", asFUNCTION(GLPopMatrix), asCALL_CDECL);
	engine->RegisterGlobalFunction("void glBindTexture(uint target, uint texture)", asFUNCTION(GLBindTexture), asCALL_CDECL);

	//Texture
	engine->RegisterGlobalFunction("uint TextureCreate(string@ filename)", asFUNCTION(SOILTextureLoad), asCALL_CDECL);

	//Cg
	engine->RegisterGlobalFunction("void CgManagerCreate()", asFUNCTION(CgManagerCreate), asCALL_CDECL);
	engine->RegisterGlobalFunction("uint CgShaderCreate(string@ vp)", asFUNCTION(CgShaderCreate), asCALL_CDECL);
	engine->RegisterGlobalFunction("void CgShaderApply(uint shader)", asFUNCTION(CgShaderApply), asCALL_CDECL);
	engine->RegisterGlobalFunction("void CgShaderUnApply(uint shader)", asFUNCTION(CgShaderUnApply), asCALL_CDECL);
	engine->RegisterGlobalFunction("void CgShaderDestroy(uint shader)", asFUNCTION(CgShaderDestroy), asCALL_CDECL);
    
    	CScriptBuilder builder;
	builder.DefineWord((char*)"PHANTOM3D_VERSION_1_0a");
	#ifdef WIN32
	builder.DefineWord((char*)"WIN32");
	#else
	builder.DefineWord((char*)"LINUX");
	#endif

    	builder.StartNewModule(engine, "MyModule");
    	builder.AddSectionFromFile(mainscript);
    	builder.BuildModule();
    
    	asIScriptModule *mod = engine->GetModule("MyModule");
    	int funcId = mod->GetFunctionIdByDecl("void main()");
    	asIScriptContext *ctx = engine->CreateContext();
    	ctx->Prepare(funcId);
    	ctx->Execute();
    
    	ctx->Release();
    	engine->Release();

	sound_engine->drop();
    	return 0;
}
