#ifndef SDLINTERFACE_H
#define SDLINTERFACE_H

#include <SDL/SDL.h>

class SDLInterface
{
	public:
	int DisplayWidth;
	int DisplayHeight;
	int WindowWidth;
	int WindowHeight;
	bool Fullscreen;
	SDL_Joystick *Joystick1;
	bool KeyboardState[256];
	int MouseX;
	int MouseY;
	bool JoystickButtonState[256];
	float JoystickAxisValue[4];
	int ExitSignal;
	SDLInterface();
	~SDLInterface();
	void Init(unsigned int width, unsigned int height, bool fullscreen, const char* title);
    void ShowCursor(unsigned int mode);
	void CheckInput();
	void SwapBuffers();
	void ShowCursor(int mode);
};

#endif
