#include "SDLInterface.h"

SDLInterface::SDLInterface() {};

SDLInterface::~SDLInterface() {};

void SDLInterface::Init(unsigned int width, unsigned int height, bool fullscreen, const char* title)
	{
		ExitSignal = 0;
		WindowWidth = width;
		WindowHeight = height;
		Fullscreen = fullscreen;
		MouseX = 0;
		MouseY = 0;

		if ( SDL_Init(SDL_INIT_VIDEO | SDL_INIT_JOYSTICK) < 0 ) { printf("Unable to init SDL: %s\n", SDL_GetError()); exit(1); } 	
		atexit(SDL_Quit); 

		SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
		SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 5);
		SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 6);
		SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 5); 
 
		const SDL_VideoInfo* vidInfo = SDL_GetVideoInfo();
		DisplayWidth=vidInfo->current_w;
		DisplayHeight=vidInfo->current_h;
 
		putenv((char*)"SDL_VIDEO_WINDOW_POS");
 		putenv((char*)"SDL_VIDEO_CENTERED=1");
 
 		MouseX = DisplayWidth/2;
 		MouseY = DisplayHeight/2;

 		if (Fullscreen)
 		{
 			if ( SDL_SetVideoMode(WindowWidth,WindowHeight,32,SDL_OPENGL | SDL_FULLSCREEN) == NULL )
 			{ 
   				printf("Unable to set video mode: %s\n", SDL_GetError()); 
   				exit(1); 
 			}
 		}
 		else
 		{
 			if ( SDL_SetVideoMode(WindowWidth,WindowHeight,32,SDL_OPENGL) == NULL )
 			{ 
   				printf("Unable to set video mode: %s\n", SDL_GetError()); 
   				exit(1); 
 			}
 		}
		SDL_WM_SetCaption (title, NULL);

		SDL_EnableKeyRepeat(1,30);
 
 		SDL_JoystickEventState(SDL_ENABLE);
 		Joystick1 = SDL_JoystickOpen(0);
	};
	
void SDLInterface::ShowCursor(unsigned int mode)
{
        SDL_ShowCursor(mode);
};

void SDLInterface::CheckInput()
	{
   		SDL_Event event; 
   		while ( SDL_PollEvent(&event) )
   		{ 
     			if ( event.type == SDL_QUIT )
     			{ 
      				ExitSignal = 1; 
     			} 
     			if ( event.type == SDL_KEYDOWN )
     			{
       				//if (event.key.keysym.sym == SDLK_ESCAPE) ExitSignal = 1;
       				KeyboardState[event.key.keysym.sym] = true;
     			} 
     			if ( event.type == SDL_KEYUP )
     			{
       				KeyboardState[event.key.keysym.sym] = false;
     			}
     			if ( event.type == SDL_MOUSEMOTION )
     			{
       				//event.motion.xrel, event.motion.yrel,
       				MouseX = event.motion.x;
       				MouseY = event.motion.y;
 	 		}
 	 		if ( event.type == SDL_MOUSEBUTTONDOWN )
         		{
         			//event.button.button, event.button.x, event.button.y
 	 		}
 	   		if ( event.type == SDL_JOYBUTTONDOWN ) JoystickButtonState[event.jbutton.button] = true;
 	   		if ( event.type == SDL_JOYBUTTONUP ) JoystickButtonState[event.jbutton.button] = false;
 	   		if ( event.type == SDL_JOYAXISMOTION ) JoystickAxisValue[event.jaxis.axis] = event.jaxis.value;
   		} 
	}

void SDLInterface::SwapBuffers()
	{
  		SDL_GL_SwapBuffers();
  		//SDL_Delay (1);
	}

void SDLInterface::ShowCursor(int mode)
	{
		SDL_ShowCursor(mode);
	}

