#include "P3DCgShader.h"

void CgInit()
{
  myCgContext = cgCreateContext();
  CgCheckForError("creating context");
  cgGLSetDebugMode(CG_FALSE);
  //cgSetParameterSettingMode(myCgContext, CG_DEFERRED_PARAMETER_SETTING);

  myCgVertexProfile = cgGLGetLatestProfile(CG_GL_VERTEX);
  cgGLSetOptimalOptions(myCgVertexProfile);
  CgCheckForError("selecting vertex profile");
}

void CgCheckForError(const char *situation)
{
  	CGerror error;
  	const char *string = cgGetLastErrorString(&error);

  	if (error != CG_NO_ERROR) 
	{ 
	printf("%s: %s\n", situation, string);
    	if (error == CG_COMPILER_ERROR) printf("%s\n", cgGetLastListing(myCgContext));
    	exit(1);
  	}
}

P3DCgShader::P3DCgShader() { };

P3DCgShader::~P3DCgShader() 
{
    	cgDestroyProgram(myCgVertexProgram);
    	cgDestroyContext(myCgContext); 
};

void P3DCgShader::LoadVertexProgram(char* filename, char* function)
{
  myProgramName = (char*)"01_vertex_program";
  myVertexProgramFileName = filename;
  myVertexProgramName = function; 

  myCgVertexProgram = cgCreateProgramFromFile(
      myCgContext,              /* Cg runtime context */
      CG_SOURCE,                /* Program in human-readable form */
      myVertexProgramFileName,
      myCgVertexProfile,        /* Profile: OpenGL ARB vertex program */
      myVertexProgramName,      /* Entry function name */
      NULL);                    /* No extra compiler options */
  CgCheckForError("creating vertex program");
  cgGLLoadProgram(myCgVertexProgram);
  CgCheckForError("loading vertex program");

  myCgVertexParam_modelViewProj = cgGetNamedParameter(myCgVertexProgram, "ModelViewProj");
  CgCheckForError("Could not get modelViewProj parameter");
}

void P3DCgShader::BeginUpdate()
{
	cgGLBindProgram(myCgVertexProgram);
  	CgCheckForError("binding vertex program");
  	cgGLEnableProfile(myCgVertexProfile);
 	CgCheckForError("enabling vertex profile");
	cgGLSetStateMatrixParameter(myCgVertexParam_modelViewProj,CG_GL_MODELVIEW_PROJECTION_MATRIX,CG_GL_MATRIX_IDENTITY);
	CgCheckForError("setting parameter");
}

void P3DCgShader::EndUpdate()
{
  	cgGLDisableProfile(myCgVertexProfile);
  	CgCheckForError("disabling vertex profile");
}




  
