#include "GL/gl.as"
#include "SDL/SDL.as"

typedef uint P3DSound;
//typedef uint P3DTexture;
//typedef uint P3DShader;

class P3DSceneManager
{
	P3DSceneManager() {}
	~P3DSceneManager() {}
	void Init()
	{
		  glClearColor(0.5f, 0.0f, 0.0f, 0.0f);
  		  glClearDepth(1.0);
  		  glDepthFunc(GL_LESS);
  		  glEnable(GL_DEPTH_TEST);
  		  glShadeModel(GL_SMOOTH);

		  glEnable( GL_BLEND );
		  glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
		  glEnable( GL_ALPHA_TEST );
		  glAlphaFunc( GL_GREATER, 0.5f );

  		  glMatrixMode(GL_PROJECTION);
  		  glLoadIdentity();
  		  gluPerspective(45.0f,WindowGetWidth()/WindowGetHeight(),0.1f,100.0f);
  		  glMatrixMode(GL_MODELVIEW);
  		  glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);
	}
}

class P3DVector3f
{
	float X;
	float Y;
	float Z;
	P3DVector3f()
	{
		X = 0;
		Y = 0;
		Z = 0;
	}
	P3DVector3f(float x, float y, float z) 
	{
		X = x;
		Y = y;
		Z = z;
	}
	P3DVector3f(P3DVector3f@ vec)
	{
		X = vec.X;
		Y = vec.Y;
		Z = vec.Z;
	}
	P3DVector3f(P3DVector4f@ vec)
	{
		X = vec.X;
		Y = vec.Y;
		Z = vec.Z;
	}
	~P3DVector3f() {}
	void Set(float x, float y, float z) 
	{
		X = x;
		Y = y;
		Z = z;
	}
}

class P3DVector4f
{
	float X;
	float Y;
	float Z;
	float W;
	P3DVector4f() 
	{
		X = 0;
		Y = 0;
		Z = 0;
		W = 0;
	}
	P3DVector4f(float x, float y, float z, float w) 
	{
		X = x;
		Y = y;
		Z = z;
		W = w;
	}
	P3DVector4f(P3DVector3f@ vec)
	{
		X = vec.X;
		Y = vec.Y;
		Z = vec.Z;
		W = 1.0f;
	}
	P3DVector4f(P3DVector4f@ vec)
	{
		X = vec.X;
		Y = vec.Y;
		Z = vec.Z;
		W = vec.W;
	}
	~P3DVector4f() {}
	void Set(float x, float y, float z, float w) 
	{
		X = x;
		Y = y;
		Z = z;
		W = w;
	}
}

class P3DColor
{
	float R;
	float G;
	float B;
	float A;
	P3DColor() 
	{
		R = 1.0f;
		G = 1.0f;
		B = 1.0f;
		A = 1.0f;
	}
	P3DColor(float r, float g, float b, float a) 
	{
		R = r;
		G = g;
		B = b;
		A = a;
	}
	P3DColor(P3DVector4f@ vec)
	{
		R = vec.X;
		G = vec.Y;
		B = vec.Z;
		A = vec.W;
	}
	~P3DColor() {}
	void Set(float r, float g, float b, float a) 
	{
		R = r;
		G = g;
		B = b;
		A = a;
	}
	void Set(uint r, uint g, uint b, float a)
	{
    		R = r/255;
    		G = g/255;
    		B = b/255;
    		A = a;
	}
	void Set(uint dec, float a)
	{
    		uint red = dec & 0xFF;
    		uint green = (dec & 0xFF00)/256;
    		uint blue = dec/65536;
    		R = float(red)/255;
    		G = float(green)/255;
    		B = float(blue)/255;
    		A = a;
	}
}

class P3DTexture
{
	uint ID;
	P3DTexture() 
	{
		ID = 0;
	}
	P3DTexture(string filename) 
	{
		ID = TextureCreate(filename);
	}
	~P3DTexture() {}
	void Load(string filename) 
	{
		ID = TextureCreate(filename);
	}
	void Apply()
	{
		if (ID!=0)		
		{
			glEnable(GL_TEXTURE_2D);
      			glBindTexture(GL_TEXTURE_2D,ID);
		}
	}
	void UnApply()
	{
		glDisable(GL_TEXTURE_2D);
	}
}

class P3DShader
{
	uint CgShader;
	P3DShader() 
	{
		CgShader = 0;
	}
	P3DShader(string vp) 
	{
		CgShader = CgShaderCreate(vp);
	}
	~P3DShader() {}
	void Load(string vp)
	{
		CgShader = CgShaderCreate(vp);
	}
	void Apply()
	{
		if (CgShader!=0) CgShaderApply(CgShader);
	}
	void UnApply()
	{
		if (CgShader!=0) CgShaderUnApply(CgShader);
	}
}

class P3DMaterial
{
	P3DColor ColorDefault;
	P3DColor@ Color;
	P3DTexture TextureDefault;
	P3DTexture@ Texture;
	P3DShader ShaderDefault;
	P3DShader@ Shader;
	P3DMaterial() 
	{
	@Color = @ColorDefault;
	@Texture = @TextureDefault;
	@Shader = @ShaderDefault;
	}
	~P3DMaterial() {}
	void Apply()
	{
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    		glColor4f(Color.R,Color.G,Color.B,Color.A);
		Texture.Apply();
		Shader.Apply();
	}
	void UnApply()
	{
		Shader.UnApply();
		Texture.UnApply();
	}
}

class P3DBaseObject
{
	P3DVector3f PositionDefault;
	P3DVector3f@ Position;
	P3DVector3f RotationDefault;
	P3DVector3f@ Rotation;
	P3DMaterial Material;
  	P3DBaseObject()  
	{
	@Position = @PositionDefault;
	@Rotation = @RotationDefault;
	}
  	~P3DBaseObject() { }
	void Update()
	{
		glTranslatef(Position.X,Position.Y,Position.Z);
  		glRotatef(Rotation.X, 1.0f, 0.0f, 0.0f);
  		glRotatef(Rotation.Y, 0.0f, 1.0f, 0.0f);
  		glRotatef(Rotation.Z, 0.0f, 0.0f, 1.0f);
	}
}

class P3DColorCube: P3DBaseObject
{
  	P3DColorCube()  
	{
		//super();
	}
  	~P3DColorCube() { }
  	void Update()
  	{
		glPushMatrix();
		P3DBaseObject::Update();
		Material.Apply();
		Render();
		Material.UnApply();
		glPopMatrix();
  	}
	void Render()
	{
		glBegin(GL_QUADS);

		glColor3f(0.0f,1.0f,0.0f); 
    		glVertex3f( 1.0f, 1.0f,-1.0f);       
    		glVertex3f(-1.0f, 1.0f,-1.0f);    
    		glVertex3f(-1.0f, 1.0f, 1.0f);       
    		glVertex3f( 1.0f, 1.0f, 1.0f);    
    	
    		glColor3f(1.0f,0.5f,0.0f);           
    		glVertex3f( 1.0f,-1.0f, 1.0f); 
    		glVertex3f(-1.0f,-1.0f, 1.0f); 
    		glVertex3f(-1.0f,-1.0f,-1.0f);  
    		glVertex3f( 1.0f,-1.0f,-1.0f);    
    
    		glColor3f(1.0f,0.0f,0.0f);       
    		glVertex3f( 1.0f, 1.0f, 1.0f); 
    		glVertex3f(-1.0f, 1.0f, 1.0f);  
    		glVertex3f(-1.0f,-1.0f, 1.0f);   
    		glVertex3f( 1.0f,-1.0f, 1.0f);   

    		glColor3f(1.0f,1.0f,0.0f);      
    		glVertex3f( 1.0f,-1.0f,-1.0f);   
    		glVertex3f(-1.0f,-1.0f,-1.0f);   
    		glVertex3f(-1.0f, 1.0f,-1.0f);   
    		glVertex3f( 1.0f, 1.0f,-1.0f);   

    		glColor3f(0.0f,0.0f,1.0f);     
    		glVertex3f(-1.0f, 1.0f, 1.0f);       
    		glVertex3f(-1.0f, 1.0f,-1.0f);   
    		glVertex3f(-1.0f,-1.0f,-1.0f); 
    		glVertex3f(-1.0f,-1.0f, 1.0f); 
    	
    		glColor3f(1.0f,0.0f,1.0f);       
    		glVertex3f( 1.0f, 1.0f,-1.0f);     
    		glVertex3f( 1.0f, 1.0f, 1.0f); 
    		glVertex3f( 1.0f,-1.0f, 1.0f); 
    		glVertex3f( 1.0f,-1.0f,-1.0f);  

  		glEnd();
	}
}

class P3DQuad: P3DBaseObject
{
  	P3DQuad()  
	{
		//super();
	}
  	~P3DQuad() { }
  	void Update()
  	{
		glPushMatrix();
		P3DBaseObject::Update();
		Material.Apply();
		Render();
		Material.UnApply();
		glPopMatrix();
  	}
	void Render()
	{
		glBegin(GL_QUADS);
       		glTexCoord2f(0.0f, 0.0f); glNormal3f(0,1,0); glVertex3f(-1,0,-1);
       		glTexCoord2f(0.0f, 1.0f); glNormal3f(0,1,0); glVertex3f(-1,0, 1);
       		glTexCoord2f(1.0f, 1.0f); glNormal3f(0,1,0); glVertex3f( 1,0, 1);
       		glTexCoord2f(1.0f, 0.0f); glNormal3f(0,1,0); glVertex3f( 1,0,-1);
      		glEnd();
	}
}

