#include "scripts/Phantom3D.as"

void main()
{
  	//ConsoleOpen();

	#if PHANTOM3D_VERSION_1_0a
	print("Phantom3D Runtime 1.0a ");
	#endif

	#if WIN32
	print("Win32\n");
	#endif

	#if LINUX
	print("Linux\n");
	#endif

	GraphicsInit(640,480,false,"My Game");
	MouseShowCursor(false);

	string sounds = "media/";
	string textures = "media/";
	string shaders = "media/";

	P3DSound sound = SoundLoad(sounds+"moondance.mod");
	P3DSound sound2 = SoundCopy(sound);
	SoundSetVolume(sound2,0.5f);
	SoundPlay2D(sound2);

	P3DSceneManager Scene;
	Scene.Init();

	CgManagerCreate();

	P3DMaterial CgMaterialExample;
	CgMaterialExample.Shader.Load(shaders+"vp_green.cg");

	P3DMaterial TexMaterialExample;
	TexMaterialExample.Texture.Load(textures+"floor.jpg");
	//TexMaterialExample.Color.Set(0x00FFFF,1.0f);
	//TexMaterialExample.Color.Set(255,255,0,1.0f);
	TexMaterialExample.Color.Set(1.0f,1.0f,0.0f,1.0f);
  	P3DQuad Quad;
	Quad.Material = TexMaterialExample;
	Quad.Position.Set(0.0f,-2.0f,-6.0f);
  
  	P3DColorCube Cube;
	Cube.Material = CgMaterialExample;
	Cube.Position.Set(0.0f,0.0f,-10.0f);
	//P3DVector4f Position1(0.0f,0.0f,-10.0f,1.0f);
	//P3DVector3f Position2(@Position1);
	//@(Cube.Position) = @Position2;
  
	bool button1 = false;

  	bool done = false;
  	while (not done)
  	{
		CheckInput();
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();

		Cube.Rotation.X += JoystickAxisValue(1)/20000;
		Cube.Rotation.Y += JoystickAxisValue(0)/20000;
		Cube.Rotation.Z += JoystickAxisValue(2)/20000;

		Cube.Update();
		Quad.Update();

		SwapBuffers();

		if (KeyboardState(SDLK_SPACE)==true) @(Cube.Position) = @(Cube.PositionDefault);
		if (JoystickButtonState(1)==true) 
		{
			if (button1==false) { print("Button 1 pressed\n"); button1=true; }
		}
		else button1 = false;
		done = ExitRequest() or KeyboardState(SDLK_ESCAPE);
  	}
}
