/*
 * Datatypes
 */
typedef uint	GLenum;
typedef uint8	GLboolean;
typedef uint	GLbitfield;
typedef int8	GLbyte;		/* 1-byte signed */
typedef int16	GLshort;	/* 2-byte signed */
typedef int	GLint;			/* 4-byte signed */
typedef uint8	GLubyte;	/* 1-byte unsigned */
typedef uint16	GLushort;	/* 2-byte unsigned */
typedef uint	GLuint;		/* 4-byte unsigned */
typedef int	GLsizei;		/* 4-byte signed */
typedef float	GLfloat;	/* single precision float */
typedef float	GLclampf;	/* single precision float in [0,1] */
typedef double	GLdouble;	/* double precision float */
typedef double	GLclampd;	/* double precision float in [0,1] */

/*
 * Constants
 */

/* Boolean values */
enum GL_CONSTANT_BOOLEAN
{
	GL_FALSE = 0x0,
	GL_TRUE = 0x1
}

/* Data types */
enum GL_CONSTANT_DATA_TYPES
{
	GL_BYTE = 0x1400,
	GL_UNSIGNED_BYTE = 0x1401,
	GL_SHORT = 0x1402,
	GL_UNSIGNED_SHORT = 0x1403,
	GL_INT = 0x1404,
	GL_UNSIGNED_INT = 0x1405,
	GL_FLOAT = 0x1406,
	GL_2_BYTES = 0x1407,
	GL_3_BYTES = 0x1408,
	GL_4_BYTES = 0x1409,
	GL_DOUBLE = 0x140A
}

/* Primitives */
enum GL_CONSTANT_PRIMITIVES
{
	GL_POINTS = 0x0000,
	GL_LINES = 0x0001,
	GL_LINE_LOOP = 0x0002,
	GL_LINE_STRIP = 0x0003,
	GL_TRIANGLES = 0x0004,
	GL_TRIANGLE_STRIP = 0x0005,
	GL_TRIANGLE_FAN = 0x0006,
	GL_QUADS = 0x0007,
	GL_QUAD_STRIP = 0x0008,
	GL_POLYGON = 0x0009
};

/* Vertex Arrays */
enum GL_CONSTANT_VERTEX_ARRAYS
{
	GL_VERTEX_ARRAY = 0x8074,
	GL_NORMAL_ARRAY	= 0x8075,
	GL_COLOR_ARRAY = 0x8076,
	GL_INDEX_ARRAY = 0x8077,
	GL_TEXTURE_COORD_ARRAY = 0x8078,
	GL_EDGE_FLAG_ARRAY = 0x8079,
	GL_VERTEX_ARRAY_SIZE = 0x807A,
	GL_VERTEX_ARRAY_TYPE = 0x807B,
	GL_VERTEX_ARRAY_STRIDE = 0x807C,
	GL_NORMAL_ARRAY_TYPE = 0x807E,
	GL_NORMAL_ARRAY_STRIDE = 0x807F,
	GL_COLOR_ARRAY_SIZE = 0x8081,
	GL_COLOR_ARRAY_TYPE = 0x8082,
	GL_COLOR_ARRAY_STRIDE = 0x8083,
	GL_INDEX_ARRAY_TYPE = 0x8085,
	GL_INDEX_ARRAY_STRIDE = 0x8086,
	GL_TEXTURE_COORD_ARRAY_SIZE = 0x8088,
	GL_TEXTURE_COORD_ARRAY_TYPE = 0x8089,
	GL_TEXTURE_COORD_ARRAY_STRIDE = 0x808A,
	GL_EDGE_FLAG_ARRAY_STRIDE = 0x808C,
	GL_VERTEX_ARRAY_POINTER = 0x808E,
	GL_NORMAL_ARRAY_POINTER = 0x808F,
	GL_COLOR_ARRAY_POINTER = 0x8090,
	GL_INDEX_ARRAY_POINTER = 0x8091,
	GL_TEXTURE_COORD_ARRAY_POINTER = 0x8092,
	GL_EDGE_FLAG_ARRAY_POINTER = 0x8093,
	GL_V2F = 0x2A20,
	GL_V3F = 0x2A21,
	GL_C4UB_V2F = 0x2A22,
	GL_C4UB_V3F = 0x2A23,
	GL_C3F_V3F = 0x2A24,
	GL_N3F_V3F = 0x2A25,
	GL_C4F_N3F_V3F = 0x2A26,
	GL_T2F_V3F = 0x2A27,
	GL_T4F_V4F = 0x2A28,
	GL_T2F_C4UB_V3F = 0x2A29,
	GL_T2F_C3F_V3F = 0x2A2A,
	GL_T2F_N3F_V3F = 0x2A2B,
	GL_T2F_C4F_N3F_V3F = 0x2A2C,
	GL_T4F_C4F_N3F_V4F = 0x2A2D
}

/* Matrix Mode */
enum GL_CONSTANT_MATRIX_MODE
{
	GL_MATRIX_MODE = 0x0BA0,
	GL_MODELVIEW = 0x1700,
	GL_PROJECTION = 0x1701,
	GL_TEXTURE = 0x1702
}

/* Points */
enum GL_CONSTANT_POINTS
{
	GL_POINT_SMOOTH = 0x0B10,
	GL_POINT_SIZE = 0x0B11,
	GL_POINT_SIZE_GRANULARITY = 0x0B13,
	GL_POINT_SIZE_RANGE = 0x0B12
}

/* Lines */
enum GL_CONSTANT_LINES
{
	GL_LINE_SMOOTH = 0x0B20,
	GL_LINE_STIPPLE = 0x0B24,
	GL_LINE_STIPPLE_PATTERN	= 0x0B25,
	GL_LINE_STIPPLE_REPEAT = 0x0B26,
	GL_LINE_WIDTH = 0x0B21,
	GL_LINE_WIDTH_GRANULARITY = 0x0B23,
	GL_LINE_WIDTH_RANGE = 0x0B22
}

/* Alpha testing */
enum GL_CONSTANT_ALPHA_TESTING
{
	GL_ALPHA_TEST = 0x0BC0,
	GL_ALPHA_TEST_REF = 0x0BC2,
	GL_ALPHA_TEST_FUNC = 0x0BC1
}

/* Blending */
enum GL_CONSTANT_BLENDING
{
	GL_BLEND = 0x0BE2,
	GL_BLEND_SRC = 0x0BE1,
	GL_BLEND_DST = 0x0BE0,
	GL_ZERO = 0x0,
	GL_ONE = 0x1,
	GL_SRC_COLOR = 0x0300,
	GL_ONE_MINUS_SRC_COLOR = 0x0301,
	GL_SRC_ALPHA = 0x0302,
	GL_ONE_MINUS_SRC_ALPHA = 0x0303,
	GL_DST_ALPHA = 0x0304,
	GL_ONE_MINUS_DST_ALPHA = 0x0305,
	GL_DST_COLOR = 0x0306,
	GL_ONE_MINUS_DST_COLOR = 0x0307,
	GL_SRC_ALPHA_SATURATE = 0x0308
}

/* Texture mapping */
enum GL_CONSTANT_TEXTURE_MAPPING
{
	GL_TEXTURE_ENV = 0x2300,
	GL_TEXTURE_ENV_MODE = 0x2200,
	GL_TEXTURE_1D = 0x0DE0,
	GL_TEXTURE_2D = 0x0DE1
/*
#define GL_TEXTURE_WRAP_S			0x2802
#define GL_TEXTURE_WRAP_T			0x2803
#define GL_TEXTURE_MAG_FILTER			0x2800
#define GL_TEXTURE_MIN_FILTER			0x2801
#define GL_TEXTURE_ENV_COLOR			0x2201
#define GL_TEXTURE_GEN_S			0x0C60
#define GL_TEXTURE_GEN_T			0x0C61
#define GL_TEXTURE_GEN_MODE			0x2500
#define GL_TEXTURE_BORDER_COLOR			0x1004
#define GL_TEXTURE_WIDTH			0x1000
#define GL_TEXTURE_HEIGHT			0x1001
#define GL_TEXTURE_BORDER			0x1005
#define GL_TEXTURE_COMPONENTS			0x1003
#define GL_TEXTURE_RED_SIZE			0x805C
#define GL_TEXTURE_GREEN_SIZE			0x805D
#define GL_TEXTURE_BLUE_SIZE			0x805E
#define GL_TEXTURE_ALPHA_SIZE			0x805F
#define GL_TEXTURE_LUMINANCE_SIZE		0x8060
#define GL_TEXTURE_INTENSITY_SIZE		0x8061
#define GL_NEAREST_MIPMAP_NEAREST		0x2700
#define GL_NEAREST_MIPMAP_LINEAR		0x2702
#define GL_LINEAR_MIPMAP_NEAREST		0x2701
#define GL_LINEAR_MIPMAP_LINEAR			0x2703
#define GL_OBJECT_LINEAR			0x2401
#define GL_OBJECT_PLANE				0x2501
#define GL_EYE_LINEAR				0x2400
#define GL_EYE_PLANE				0x2502
#define GL_SPHERE_MAP				0x2402
#define GL_DECAL				0x2101
#define GL_MODULATE				0x2100
#define GL_NEAREST				0x2600
#define GL_REPEAT				0x2901
#define GL_CLAMP				0x2900
#define GL_S					0x2000
#define GL_T					0x2001
#define GL_R					0x2002
#define GL_Q					0x2003
#define GL_TEXTURE_GEN_R			0x0C62
#define GL_TEXTURE_GEN_Q			0x0C63
*/
}

enum GL_CONSTANT_DEPTH_BUFFER
{
	GL_NEVER = 0x0200,
	GL_LESS	= 0x0201,
	GL_EQUAL = 0x0202,
	GL_LEQUAL = 0x0203,
	GL_GREATER = 0x0204,
	GL_NOTEQUAL = 0x0205,
	GL_GEQUAL = 0x0206,
	GL_ALWAYS = 0x0207,
	GL_DEPTH_TEST = 0x0B71,
	GL_DEPTH_BITS = 0x0D56,
	GL_DEPTH_CLEAR_VALUE = 0x0B73,
	GL_DEPTH_FUNC = 0x0B74,
	GL_DEPTH_RANGE = 0x0B70,
	GL_DEPTH_WRITEMASK = 0x0B72,
	GL_DEPTH_COMPONENT = 0x1902
};

enum GL_CONSTANT_LIGHTING
{
	GL_LIGHTING = 0x0B50,
	GL_LIGHT0 = 0x4000,
	GL_LIGHT1 = 0x4001,
	GL_LIGHT2 = 0x4002,
	GL_LIGHT3 = 0x4003,
	GL_LIGHT4 = 0x4004,
	GL_LIGHT5 = 0x4005,
	GL_LIGHT6 = 0x4006,
	GL_LIGHT7 = 0x4007,
	GL_SPOT_EXPONENT = 0x1205,
	GL_SPOT_CUTOFF = 0x1206,
	GL_CONSTANT_ATTENUATION	= 0x1207,
	GL_LINEAR_ATTENUATION = 0x1208,
	GL_QUADRATIC_ATTENUATION = 0x1209,
	GL_AMBIENT = 0x1200,
	GL_DIFFUSE = 0x1201,
	GL_SPECULAR = 0x1202,
	GL_SHININESS = 0x1601,
	GL_EMISSION = 0x1600,
	GL_POSITION = 0x1203,
	GL_SPOT_DIRECTION = 0x1204,
	GL_AMBIENT_AND_DIFFUSE = 0x1602,
	GL_COLOR_INDEXES = 0x1603,
	GL_LIGHT_MODEL_TWO_SIDE = 0x0B52,
	GL_LIGHT_MODEL_LOCAL_VIEWER = 0x0B51,
	GL_LIGHT_MODEL_AMBIENT = 0x0B53,
	GL_FRONT_AND_BACK = 0x0408,
	GL_SHADE_MODEL = 0x0B54,
	GL_FLAT = 0x1D00,
	GL_SMOOTH = 0x1D01,
	GL_COLOR_MATERIAL = 0x0B57,
	GL_COLOR_MATERIAL_FACE = 0x0B55,
	GL_COLOR_MATERIAL_PARAMETER = 0x0B56,
	GL_NORMALIZE = 0x0BA1
};

enum GL_CONSTANT_GETS
{
	GL_ATTRIB_STACK_DEPTH = 0x0BB0,
	GL_CLIENT_ATTRIB_STACK_DEPTH = 0x0BB1,
	GL_COLOR_CLEAR_VALUE = 0x0C22,
	GL_COLOR_WRITEMASK = 0x0C23,
	GL_CURRENT_INDEX = 0x0B01,
	GL_CURRENT_COLOR = 0x0B00,
	GL_CURRENT_NORMAL = 0x0B02,
	GL_CURRENT_RASTER_COLOR = 0x0B04,
	GL_CURRENT_RASTER_DISTANCE = 0x0B09,
	GL_CURRENT_RASTER_INDEX = 0x0B05,
	GL_CURRENT_RASTER_POSITION = 0x0B07,
	GL_CURRENT_RASTER_TEXTURE_COORDS = 0x0B06,
	GL_CURRENT_RASTER_POSITION_VALID = 0x0B08,
	GL_CURRENT_TEXTURE_COORDS = 0x0B03,
	GL_INDEX_CLEAR_VALUE = 0x0C20,
	GL_INDEX_MODE = 0x0C30,
	GL_INDEX_WRITEMASK = 0x0C21,
	GL_MODELVIEW_MATRIX = 0x0BA6,
	GL_MODELVIEW_STACK_DEPTH = 0x0BA3,
	GL_NAME_STACK_DEPTH = 0x0D70,
	GL_PROJECTION_MATRIX = 0x0BA7,
	GL_PROJECTION_STACK_DEPTH = 0x0BA4,
	GL_RENDER_MODE = 0x0C40,
	GL_RGBA_MODE = 0x0C31,
	GL_TEXTURE_MATRIX = 0x0BA8,
	GL_TEXTURE_STACK_DEPTH = 0x0BA5,
	GL_VIEWPORT = 0x0BA2
};

enum GL_CONSTANT_HINTS
{
	GL_PERSPECTIVE_CORRECTION_HINT = 0x0C50,
	GL_POINT_SMOOTH_HINT = 0x0C51,
	GL_LINE_SMOOTH_HINT = 0x0C52,
	GL_POLYGON_SMOOTH_HINT = 0x0C53,
	GL_FOG_HINT = 0x0C54,
	GL_DONT_CARE = 0x1100,
	GL_FASTEST = 0x1101,
	GL_NICEST = 0x1102
};

enum GL_CONSTANT_BITS
{
	GL_CURRENT_BIT = 0x00000001,
	GL_POINT_BIT = 0x00000002,
	GL_LINE_BIT = 0x00000004,
	GL_POLYGON_BIT = 0x00000008,
	GL_POLYGON_STIPPLE_BIT = 0x00000010,
	GL_PIXEL_MODE_BIT = 0x00000020,
	GL_LIGHTING_BIT = 0x00000040,
	GL_FOG_BIT = 0x00000080,
	GL_DEPTH_BUFFER_BIT = 0x00000100,
	GL_ACCUM_BUFFER_BIT = 0x00000200,
	GL_STENCIL_BUFFER_BIT = 0x00000400,
	GL_VIEWPORT_BIT = 0x00000800,
	GL_TRANSFORM_BIT = 0x00001000,
	GL_ENABLE_BIT = 0x00002000,
	GL_COLOR_BUFFER_BIT = 0x00004000,
	GL_HINT_BIT = 0x00008000,
	GL_EVAL_BIT = 0x00010000,
	GL_LIST_BIT = 0x00020000,
	GL_TEXTURE_BIT = 0x00040000,
	GL_SCISSOR_BIT = 0x00080000,
	GL_ALL_ATTRIB_BITS = 0x000FFFFF
};

