#define GmnConstraintCreateHinge
// GMNewton 1.00
//
//Function:  Creates a basic hinge
//Notes:  Reccomended to use the CustomHinge instead as it supports more options such as breaking
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - xOrig
//   Argument2 - yOrig
//   Argument3 - zOrig
//   Argument4 - xPin
//   Argument5 - yPin
//   Argument6 - zPin
//   Argument7 - dChildBody
//   Argument8 - dParentBody
//call GmnConstraintCreateHinge(dWorld,xOrig,yOrig,zOrig,xPin,yPin,zPin,dChildBody,dParentBody);
//return: 
return external_call(global.__GmnConstraintCreateHinge__,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7,argument8);

#define GmnCreateCustomHinge
// GMNewton 1.00
//
//Function:  Creates a custom hinge joint
//Notes:  position and pin.  pin is a vector around which hinge rotation is allowed
//
//Arguments:
//   Argument0 - xOrig
//   Argument1 - yOrig
//   Argument2 - zOrig
//   Argument3 - xPin
//   Argument4 - yPin
//   Argument5 - zPin
//   Argument6 - dChildBody
//   Argument7 - dParentBody
//call GmnCreateCustomHinge(xOrig,yOrig,zOrig,xPin,yPin,zPin,dChildBody,dParentBody);
//return: 
return external_call(global.__GmnCreateCustomHinge__,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7);

#define GmnCustomHingeSetLimits
// GMNewton 1.00
//
//Function:  Sets the limits of a hinge joint
//Notes:  in degrees, the min and max angle
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - min
//   Argument2 - max
//call GmnCustomHingeSetLimits(dHinge,min,max);
//return: 
return external_call(global.__GmnCustomHingeSetLimits__,argument0,argument1,argument2);

#define GmnCustomHingeGetForceMagnitude
// GMNewton 1.00
//
//Function:  Gets the magnitude of force hinge is applying
//Notes:
//
//Arguments:
//   Argument0 - dHinge
//call GmnCustomHingeGetForceMagnitude(dHinge);
//return: 
return external_call(global.__GmnCustomHingeGetForceMagnitude__,argument0);

#define GmnCustomHingeGetTorqueMagnitude
// GMNewton 1.00
//
//Function:  Gets the magnitude of torque hinge is applying
//Notes:
//
//Arguments:
//   Argument0 - dHinge
//call GmnCustomHingeGetTorqueMagnitude(dHinge);
//return: 
return external_call(global.__GmnCustomHingeGetTorqueMagnitude__,argument0);

#define GmnCustomHingeSetSeverCallscript
// GMNewton 1.00
//
//Function:  Set the script to be called when joint is severed
//Notes:  must have initiated gmi for this to work
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - script
//call GmnCustomHingeSetSeverCallscript(dHinge,script);
//return: 
return external_call(global.__GmnCustomHingeSetSeverCallscript__,argument0,argument1);

#define GmnCustomHingeSetBreakCallscript
// GMNewton 1.00
//
//Function:  Sets the script called when joint brakes
//Notes:  gmi must be inited for this to work
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - script
//call GmnCustomHingeSetBreakCallscript(dHinge,script);
//return: 
return external_call(global.__GmnCustomHingeSetBreakCallscript__,argument0,argument1);

#define GmnCustomHingeSetSeverTolerance
// GMNewton 1.00
//
//Function:  Sets the force at which joint severs
//Notes:
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - forceTolerance
//   Argument2 - torqueTolerance
//call GmnCustomHingeSetSeverTolerance(dHinge,forceTolerance,torqueTolerance);
//return: 
return external_call(global.__GmnCustomHingeSetSeverTolerance__,argument0,argument1,argument2);

#define GmnCustomHingeSetSeverable
// GMNewton 1.00
//
//Function:  Sets if joint is severable
//Notes:
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - severable
//call GmnCustomHingeSetSeverable(dHinge,severable);
//return: 
return external_call(global.__GmnCustomHingeSetSeverable__,argument0,argument1);

#define GmnCustomHingeSetLimitsBreakTolerance
// GMNewton 1.00
//
//Function:  Sets force needed to break joint
//Notes:
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - tolerance
//call GmnCustomHingeSetLimitsBreakTolerance(dHinge,tolerance);
//return: 
return external_call(global.__GmnCustomHingeSetLimitsBreakTolerance__,argument0,argument1);

#define GmnCustomHingeSetLimitsBreakable
// GMNewton 1.00
//
//Function:  Sets if joint is breakable
//Notes:
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - breakable
//call GmnCustomHingeSetLimitsBreakable(dHinge,breakable);
//return: 
return external_call(global.__GmnCustomHingeSetLimitsBreakable__,argument0,argument1);

#define GmnCustomHingeGetLimitsBreakTolerance
// GMNewton 1.00
//
//Function:  Gets force required to break joint
//Notes:
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//call GmnCustomHingeGetLimitsBreakTolerance(dHinge);
//return: 
return external_call(global.__GmnCustomHingeGetLimitsBreakTolerance__,argument0);

