#define GmnCreate
// GMNewton 1.00
//
//Function:  Creates a new Newton world
//Notes:
//
//Arguments:
//call GmnCreate();
//return: 
return external_call(global.__GmnCreate__);

#define GmnDestroy
// GMNewton 1.00
//
//Function:  Destroys a Newton world
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//call GmnDestroy(dWorld);
//return: 
return external_call(global.__GmnDestroy__,argument0);

#define GmnSetPlatformArchitecture
// GMNewton 1.00
//
//Function:  Set the current platform hardware architecture.
//Notes:  <taken from NGD Wiki>
//This function allows the application to configure the Newton to take advantage for specific hardware architecture in the same platform.
//0 - force the hardware lower common denominator for the running platform.
//1 - will try to use common floating point enhancement like spacial instruction set on the specific architecture. This mode made lead to result that differ from mode 1 and 2 as the accumulation round off errors maybe different.
//2 - the engine will try to use the best possible hardware setting found in the current platform this is the default configuration. This mode made lead to result that differ from mode 1 and 2 as the accumulation round off errors maybe different.
//the only hardware mode guarantee to work is mode 0. all other are only hints to the engine, for example setting mode 1 will take not effect on CPUs without specially floating point instructions set.
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - mode
//call GmnSetPlatformArchitecture(dWorld,mode);
//return: 
return external_call(global.__GmnSetPlatformArchitecture__,argument0,argument1);

#define GmnSetSolverModel
// GMNewton 1.00
//
//Function:  
//Notes:  <copied from NGD Wiki>
//        0 is the exact solver (default).
//                This is a one pass solver that calculates regular and frictional forces at the same time. Use this model if you require a high degree of accuracy in your simulation.
//        n ( > 0 ) is the linear solver
//               This is a complete iterative solver which peform n iterations per update. Increasing the number of iterations will improve accuracy at the cost of solver speed. Use this model if you require speed over accuracy in your simulation.
//
//        The adaptive friction model combined with the linear solver model make for the fastest possible configuration of the Newton solver. This setup is best for games. If you need the best realistic behavior, we recommend the use of the exact solver and exact friction model which are the defaults.
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - model
//call GmnSetSolverModel(dWorld,model);
//return: 
return external_call(global.__GmnSetSolverModel__,argument0,argument1);

#define GmnSetFrictionModel
// GMNewton 1.00
//
//Function:  Set friction model used
//Notes:   This command speficies the accuracy of friction used by the exact solver. This command has no effect when using the linear solver.
//        0 is the exact model (default).
//        1 is the adaptive model.
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - model
//call GmnSetFrictionModel(dWorld,model);
//return: 
return external_call(global.__GmnSetFrictionModel__,argument0,argument1);

#define GmnSetMinimumFrameRate
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - framerate
//call GmnSetMinimumFrameRate(dWorld,framerate);
//return: 
return external_call(global.__GmnSetMinimumFrameRate__,argument0,argument1);

#define GmnUpdateFPS
// GMNewton 1.00
//
//Function: Update the simulation with the given fps
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - fps
//call GmnUpdateFPS(dWorld,fps);
//return: 
return external_call(global.__GmnUpdateFPS__,argument0,argument1);

#define GmnUpdate
// GMNewton 1.00
//
//Function: Update simulation by given number of seconds
//Notes:  1/room_speed will update at same fps as game
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - timestep
//call GmnUpdate(dWorld,timestep);
//return: 
return external_call(global.__GmnUpdate__,argument0,argument1);

#define GmnDestroyAllBodies
// GMNewton 1.00
//
//Function:  Destroys all bodies in a newton world
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//call GmnDestroyAllBodies(dWorld);
//return: 
return external_call(global.__GmnDestroyAllBodies__,argument0);

#define GmnSetWorldSize
// GMNewton 1.00
//
//Function:  Sets the size of the Newton world
//Notes:  Bodies and raycasts will not be processed when outside of the world
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - x1
//   Argument2 - y1
//   Argument3 - z1
//   Argument4 - x2
//   Argument5 - y2
//   Argument6 - z2
//call GmnSetWorldSize(dWorld,x1,y1,z1,x2,y2,z2);
//return: 
return external_call(global.__GmnSetWorldSize__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnWorldGetBodyCount
// GMNewton 1.00
//
//Function:  Returns the number of bodies in the Newton world
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//call GmnWorldGetBodyCount(dWorld);
//return: 
return external_call(global.__GmnWorldGetBodyCount__,argument0);

