#define GmnCreateNull
// GMNewton 1.00
//
//Function:  Creates a Null collision shape
//Notes:  Does not collide with anything, but may be useful for say controlling another body or the neck of a ragdoll
//
//Arguments:
//   Argument0 - dWorld
//call GmnCreateNull(dWorld);
//return: 
return external_call(global.__GmnCreateNull__,argument0);

#define GmnCreateBox
// GMNewton 1.00
//
//Function:  Creates a box collision shape
//Notes:  dx, dy, and dz define the length of box on x, y, and z axi
//        Offset moves collision shape from origin by given amount
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - dx
//   Argument2 - dy
//   Argument3 - dz
//   Argument4 - offset_x
//   Argument5 - offset_y
//   Argument6 - offset_z
//call GmnCreateBox(dWorld,dx,dy,dz,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateBox__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnCreateSphere
// GMNewton 1.00
//
//Function:  Creates a spherical collision shape
//Notes:  Define the radius of box on x, y, and z axi
//        Offset moves collision shape from origin by given amount
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - radiusX
//   Argument2 - radiusY
//   Argument3 - radiusZ
//   Argument4 - offset_x
//   Argument5 - offset_y
//   Argument6 - offset_z
//call GmnCreateSphere(dWorld,radiusX,radiusY,radiusZ,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateSphere__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnCreateCone
// GMNewton 1.00
//
//Function:  Creates a cone collision shape
//Notes:  'radius' defines base, and 'height' the height
//        Offset moves collision shape from origin
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - radius
//   Argument2 - height
//   Argument3 - offset_x
//   Argument4 - offset_y
//   Argument5 - offset_z
//call GmnCreateCone(dWorld,radius,height,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateCone__,argument0,argument1,argument2,argument3,argument4,argument5);

#define GmnCreateCapsule
// GMNewton 1.00
//
//Function:  Creates a capsule collision shape
//Notes:  A cylinder with rounded ends
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - radius
//   Argument2 - height
//   Argument3 - offset_x
//   Argument4 - offset_y
//   Argument5 - offset_z
//call GmnCreateCapsule(dWorld,radius,height,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateCapsule__,argument0,argument1,argument2,argument3,argument4,argument5);

#define GmnCreateCylinder
// GMNewton 1.00
//
//Function:  Creates a cylinder collision shape
//Notes:  "radius" defines the radius of the cylinder, and "height" the height.
//        This was really a useful note eh?
//        Offsets shift the shape from the origin
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - radius
//   Argument2 - height
//   Argument3 - offset_x
//   Argument4 - offset_y
//   Argument5 - offset_z
//call GmnCreateCylinder(dWorld,radius,height,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateCylinder__,argument0,argument1,argument2,argument3,argument4,argument5);

#define GmnCreateChamferCylinder
// GMNewton 1.00
//
//Function:  Creates a ChamferCylinder shape
//Notes:  Radius, height define size
//        Offsets displace from origin
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - radius
//   Argument2 - height
//   Argument3 - offset_x
//   Argument4 - offset_y
//   Argument5 - offset_z
//call GmnCreateChamferCylinder(dWorld,radius,height,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateChamferCylinder__,argument0,argument1,argument2,argument3,argument4,argument5);

