#define GmnConvexCollisionCalculateVolume
// GMNewton 1.00
//
//Function:  Calculates the approximate volume of a convex collision
//Notes:  Useful to set the mass of an object based on density and volume
//        (Not to be used on collision trees, as they are not necessarily closed shapes)
//
//Arguments:
//   Argument0 - dCollision
//call GmnConvexCollisionCalculateVolume(dCollision);
//return: 
return external_call(global.__GmnConvexCollisionCalculateVolume__,argument0);

#define GmnReleaseCollision
// GMNewton 1.00
//
//Function:  Releases a collision shape returning control to Newton
//Notes:  Collision objects are reference counted objects. The application should call NewtonReleaseCollision in order to release references to the object. Neglecting to release references to collision primitives is a common cause of memory leaks.
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - dCollision
//call GmnReleaseCollision(dWorld,dCollision);
//return: 
return external_call(global.__GmnReleaseCollision__,argument0,argument1);

#define GmnCollisionSetAsTriggerVolume
// GMNewton 1.00
//
//Function:  Turns the collision into a trigger volume or vice versa
//Notes:  Trigger volumes are different from normal collisions in that they don't generate contacts. They are useful to trigger events if a body hits the trigger volume.
//        Only convex collision primitives can be used as trigger volumes.
//
//Arguments:
//   Argument0 - dCollision
//   Argument1 - trigger
//call GmnCollisionSetAsTriggerVolume(dCollision,trigger);
//return: 
return external_call(global.__GmnCollisionSetAsTriggerVolume__,argument0,argument1);

