#define GmnBodyAddImpulse
// GMNewton 1.00
//
//Function:  Adds an impulse to body at given position and magnitude
//Notes:  Applied in global space, with impulse representing change in velocity
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - xOrig
//   Argument2 - yOrig
//   Argument3 - zOrig
//   Argument4 - xImpulse
//   Argument5 - yImpulse
//   Argument6 - zImpulse
//call GmnBodyAddImpulse(dBody,xOrig,yOrig,zOrig,xImpulse,yImpulse,zImpulse);
//return: 
return external_call(global.__GmnBodyAddImpulse__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnBodyGetPointGlobalVelocity
// GMNewton 1.00
//
//Function:  Retrieves body's velocity at specific point in global space
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - x
//   Argument2 - y
//   Argument3 - z
//   Argument4 - axis
//call GmnBodyGetPointGlobalVelocity(dBody,x,y,z,axis);
//return: 
return external_call(global.__GmnBodyGetPointGlobalVelocity__,argument0,argument1,argument2,argument3,argument4);

#define GmnBodyGetPointLocalVelocity
// GMNewton 1.00
//
//Function:  Retrieves body's velocity at specific point in local space
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - x
//   Argument2 - y
//   Argument3 - z
//   Argument4 - axis
//call GmnBodyGetPointLocalVelocity(dBody,x,y,z,axis);
//return: 
return external_call(global.__GmnBodyGetPointLocalVelocity__,argument0,argument1,argument2,argument3,argument4);

#define GmnBodyAddPointGlobalForce
// GMNewton 1.00
//
//Function:  Adds force to body at a specified point in global space
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - x
//   Argument2 - y
//   Argument3 - z
//   Argument4 - xforce
//   Argument5 - yforce
//   Argument6 - zforce
//call GmnBodyAddPointGlobalForce(dBody,x,y,z,xforce,yforce,zforce);
//return: 
return external_call(global.__GmnBodyAddPointGlobalForce__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnBodyAddPointLocalForce
// GMNewton 1.00
//
//Function:  Adds force to body at a specified point in local space
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - x
//   Argument2 - y
//   Argument3 - z
//   Argument4 - xforce
//   Argument5 - yforce
//   Argument6 - zforce
//call GmnBodyAddPointLocalForce(dBody,x,y,z,xforce,yforce,zforce);
//return: 
return external_call(global.__GmnBodyAddPointLocalForce__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnBodyGetLocalOmega
// GMNewton 1.00
//
//Function:  Retrieves body's omega in local space
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - axis
//call GmnBodyGetLocalOmega(dBody,axis);
//return: 
return external_call(global.__GmnBodyGetLocalOmega__,argument0,argument1);

