#define GmnCreateBody
// GMNewton 1.00
//
//Function:  Creates a body in the newton world
//Notes:  The concept of bodies is quite simple.  If you understand GM, understanding bodies should be easy.
//        Bodies in Newton are as objects are in GM.
//        Collisions are as sprites or masks used for collision
//        Bodies must be created in a "world"
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - dCollision
//call GmnCreateBody(dWorld,dCollision);
//return: 
return external_call(global.__GmnCreateBody__,argument0,argument1);

#define GmnDestroyBody
// GMNewton 1.00
//
//Function:  Destroys a newton body
//Notes:  Call this to remove a body from the simulation
//        It is importaint to remember this when destroying objects
//         so that the body does not continue to be simulated
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - dBody
//call GmnDestroyBody(dWorld,dBody);
//return: 
return external_call(global.__GmnDestroyBody__,argument0,argument1);

#define GmnBodyGetWorld
// GMNewton 1.00
//
//Function:  Retrieves the world that a body exists in
//Notes:
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyGetWorld(dBody);
//return: 
return external_call(global.__GmnBodyGetWorld__,argument0);

#define GmnBodyGetCollision
// GMNewton 1.00
//
//Function:  Gets the collision shape assigned to the body
//Notes:
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyGetCollision(dBody);
//return: 
return external_call(global.__GmnBodyGetCollision__,argument0);

#define GmnBodySetMaterialGroupID
// GMNewton 1.00
//
//Function:  Applies given material to body
//Notes:  Materials define how bodies interact with each other.
//        This includes how bouncy, soft, friction, etc. of reaction to collisions
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - id
//call GmnBodySetMaterialGroupID(dBody,id);
//return: 
return external_call(global.__GmnBodySetMaterialGroupID__,argument0,argument1);

#define GmnBodySetAutoSleep
// GMNewton 1.00
//
//Function:  Sets if Newton may put a body to sleep after it is unactive for a time
//Notes:  Sleeping is a low-processing state that an unmoving body is placed in if allowed.
//        Bodies will automatically wake up and resume simulation if an outside force is applied
//        Or contact is made with another body
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - state (true/false)
//call GmnBodySetAutoSleep(dBody,state);
//return: 
return external_call(global.__GmnBodySetAutoSleep__,argument0,argument1);

#define GmnBodySetCentreOfMass
// GMNewton 1.00
//
//Function: Sets the center of mass of a body
//Notes:  By default, this is set to (0,0,0) local body space
//        New COM is given in offset from local origin ob body
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - Xoffset
//   Argument2 - Yoffset
//   Argument3 - Zoffset
//call GmnBodySetCentreOfMass(dBody,Xoffset,Yoffset,Zoffset);
//return: 
return external_call(global.__GmnBodySetCentreOfMass__,argument0,argument1,argument2,argument3);

#define GmnBodySetMassMatrix
// GMNewton 1.00
//
//Function:  Sets up the mass and moment of inertia
//Notes:  Mass defines the resistance to motion
//        Ixx, Iyy, and Izz are the resistance to rotation on the given axis
//        The function GmnBodySetAutoMassMatrix can calculate this automatically
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - mass
//   Argument2 - Ixx
//   Argument3 - Iyy
//   Argument4 - Izz
//call GmnBodySetMassMatrix(dBody,mass,Ixx,Iyy,Izz);
//return: 
return external_call(global.__GmnBodySetMassMatrix__,argument0,argument1,argument2,argument3,argument4);

#define GmnBodySetAutoMassMatrix
// GMNewton 1.00
//
//Function:  Automaticaly calculates moment of inertia values(resistance to rotation) for a convex hull
//Notes:  Only for use on convex collision, not collision trees
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - mass
//   Argument2 - doCom
//call GmnBodySetAutoMassMatrix(dBody,mass,doCom);
//return: 
return external_call(global.__GmnBodySetAutoMassMatrix__,argument0,argument1,argument2);

#define GmnBodySetContinuousCollisionMode
// GMNewton 1.00
//
//Function:  Turns CCD on or off for body
//Notes:  ContinuousCollisionDetection prevents small, fast-moving bodies from passing through other bodies
//        CCD is slower than normal processing, and should be applied only when needed to maintain simulation speed
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - state (true/false)
//call GmnBodySetContinuousCollisionMode(dBody,state);
//return: 
return external_call(global.__GmnBodySetContinuousCollisionMode__,argument0,argument1);

#define GmnBodySetJointRecursiveCollision
// GMNewton 1.00
//
//Function:  Sets if jointed bodies react to each other
//Notes:  Sometimes when two bodies are jointed together it is necessary to disable collisions between them to achieve desired effect
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - state
//call GmnBodySetJointRecursiveCollision(dBody,state);
//return: 
return external_call(global.__GmnBodySetJointRecursiveCollision__,argument0,argument1);

#define GmnBodySetFreezeState
// GMNewton 1.00
//
//Function:  Puts a body to sleep or wakes it up
//Notes:  Sleeping bodies are not simulated, but are wakened when acted on by outside force
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - state
//call GmnBodySetFreezeState(dBody,state);
//return: 
return external_call(global.__GmnBodySetFreezeState__,argument0,argument1);

