#define GmnBodySetLinearDamping
// GMNewton 1.00
//
//Function:  Sets linear damping of body
//Notes:  The dampening viscous friction force is added to the external force applied to the body every frame before going to the solver-integrator.
//        linearDamp is clamped between 0 and 1, default being .1
//        There is a non zero implicit attenuation value of 0.0001 assumed by the integrator
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - linearDamp
//call GmnBodySetLinearDamping(dBody,linearDamp);
//return: 
return external_call(global.__GmnBodySetLinearDamping__,argument0,argument1);

#define GmnBodyGetLinearDamping
// GMNewton 1.00
//
//Function:  Gets the linear damp setting of a body
//Notes:
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyGetLinearDamping(dBody);
//return: 
return external_call(global.__GmnBodyGetLinearDamping__,argument0);

#define GmnBodySetAngularDamping
// GMNewton 1.00
//
//Function:  Sets rotational damping of body
//Notes:  damping on each axis is clamped between 0 and 1
//        There is a non zero implicit attenuation value of 0.0001 assumed by the integrator
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - angularDampX
//   Argument2 - angularDampY
//   Argument3 - angularDampZ
//call GmnBodySetAngularDamping(dBody,angularDampX,angularDampY,angularDampZ);
//return: 
return external_call(global.__GmnBodySetAngularDamping__,argument0,argument1,argument2,argument3);

#define GmnBodyGetAngularDamping
// GMNewton 1.00
//
//Function:  Gets the rotational damping of body on given axis
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - axis
//call GmnBodyGetAngularDamping(dBody,axis);
//return: 
return external_call(global.__GmnBodyGetAngularDamping__,argument0,argument1);

