#define handle_collisions
ce = GmnCollisionGet();

while(ce!=0){

    global.xxobj1 = GmnCollisionGetObject(ce,0);

    global.xxobj2 = GmnCollisionGetObject(ce,1);
    
    if(global.xxobj1*global.xxobj2 != 0){
       if((instance_exists(global.xxobj1))and(instance_exists(global.xxobj1))){
              (global.xxobj1).colobj=global.xxobj2;
              (global.xxobj2).colobj=global.xxobj1;
              with(global.xxobj1){
                 if(instance_exists(colobj))   event_perform(ev_collision,colobj.object_index);
              }
              with(global.xxobj2){
                 if(instance_exists(colobj))   event_perform(ev_collision,colobj.object_index);
              }
       }
    }
    ce=GmnCollisionGetNext(ce);

}

#define mouse_get_vector
//same arguments as d3d_projection_ext() except the last two

var mm,dX,dY,dZ,uX,uY,uZ,vX,vY,vZ,mX,mY,mZ, width, height, tFOV;
dX = argument3-argument0;
dY = argument4-argument1;
dZ = argument5-argument2;
mm = sqrt(dX*dX+dY*dY+dZ*dZ);

dX /= mm;
dY /= mm;
dZ /= mm;
uX = argument6;
uY = argument7;
uZ = argument8;
mm = uX*dX+uY*dY+uZ*dZ;
uX -= mm*dX;
uY -= mm*dY;
uZ -= mm*dZ
mm = sqrt(uX*uX+uY*uY+uZ*uZ);
uX /= mm;
uY /= mm;
uZ /= mm;
// v = u x d
vX = uY*dZ-dY*uZ;
vY = uZ*dX-dZ*uX;
vZ = uX*dY-dX*uY;
tFOV = tan(argument9*pi/360);
uX *= tFOV;
uY *= tFOV;
uZ *= tFOV;
vX *= tFOV*argument10;
vY *= tFOV*argument10;
vZ *= tFOV*argument10;
width = window_get_width();
height = window_get_height();
mX = dX+uX*(1-2*mouse_y/height)+vX*(2*mouse_x/width-1);
mY = dY+uY*(1-2*mouse_y/height)+vY*(2*mouse_x/width-1);
mZ = dZ+uZ*(1-2*mouse_y/height)+vZ*(2*mouse_x/width-1);
mm = sqrt(mX*mX+mY*mY+mZ*mZ);
global.mouse_dx = mX/mm;
global.mouse_dy = mY/mm;
global.mouse_dz = mZ/mm;

#define ds_vec_list_add
//Adds vector to list
//argument0 - list
//Argument1 - z
//Argument2 - y
//Argument3 - z

ds_list_add(argument0,argument1);
ds_list_add(argument0,argument2);
ds_list_add(argument0,argument3);

return(1);
#define ds_vec_list_delete
//Remove vector from list
//argument0 - list
//Argument1 - pos

repeat(3) ds_list_delete(argument0,argument1*3);

return(1);
#define ds_vec_list_insert
//Adds vector to list
//argument0 - list
//Argument1 - pos
//Argument2 - z
//Argument3 - y
//Argument4 - z

ds_list_insert(argument0,argument1*3,argument2);
ds_list_insert(argument0,(argument1*3)+1,argument3);
ds_list_insert(argument0,(argument1*3)+2,argument4);

return(1);
#define ds_vec_list_size
//Adds vector to list
//argument0 - list

return(floor(ds_list_size(argument0)/3));
#define string_to_list
//Argument0 - string
//Argument1 - seperating character
//
//returns list id

var i, list, strpos, text, cnt;
text=argument0;
list=ds_list_create()

//show_message(string(string_pos(argument1,text)))

ds_list_add(list,real(string_copy(text,1,string_pos(argument1,text)-1)));
text=string_copy(text,string_pos(argument1,argument0)+1,string_length(text)-string_pos(argument1,text))

cnt=string_count(argument1,text)
//show_message(string(cnt))
for(i=0;i<cnt;i+=1){
   ds_list_add(list,real(string_copy(text,1,string_pos(argument1,text)-1)));
   text=string_copy(text,string_pos(argument1,text)+1,string_length(text))
}
ds_list_add(list,real(string_copy(text,1,string_length(text))));

return(list);



#define string_to_list_ext
//Argument0 - string
//Argument1 - seperating character
//Argument2 - list
//
//returns list id

var i, list, strpos, text, cnt;
text=argument0;


//show_message(string(string_pos(argument1,text)))
ds_list_add(argument2,real(string_copy(text,1,string_pos(argument1,text)-1)));
text=string_copy(text,string_pos(argument1,argument0)+1,string_length(text)-string_pos(argument1,text))
cnt=string_count(argument1,text)
//show_message(string(cnt))
for(i=0;i<cnt;i+=1){
   ds_list_add(argument2,real(string_copy(text,1,string_pos(argument1,text)-1)));
   text=string_copy(text,string_pos(argument1,text)+1,string_length(text));
}
ds_list_add(argument2,real(string_copy(text,1,string_length(text))));
return(argument2);



#define string_to_list_str
//Argument0 - string
//Argument1 - seperating character
//
//returns list id

var i, list, strpos, text, cnt;
text=argument0;
list=ds_list_create()

//show_message(string(string_pos(argument1,text)))

ds_list_add(list,string_copy(text,1,string_pos(argument1,text)-1));
text=string_copy(text,string_pos(argument1,argument0)+1,string_length(text)-string_pos(argument1,text))

cnt=string_count(argument1,text)
//show_message(string(cnt))
for(i=0;i<cnt;i+=1){
   ds_list_add(list,string_copy(text,1,string_pos(argument1,text)-1));
   text=string_copy(text,string_pos(argument1,text)+1,string_length(text))
}
ds_list_add(list,string_copy(text,1,string_length(text)));

return(list);



#define show_list
//Argument0 - list

var str, i;
str="";

for(i=0;i<ds_list_size(argument0);i+=1){
   str+=string(ds_list_find_value(argument0,i))+"#";
}

show_message(str)
#define string_pos_ext
//argument0 - substring
//argument1 - string
//argument2 - number (1=first;2=second,3=third,etc.)

var i,count;
count=0;

if(string_count(argument0,argument1)<argument2) return(-1);

for(i=1;i<=string_length(argument1);i+=1){
   if(string_char_at(argument1,i)==argument0){
      count+=1;
      if(count==argument2){
         return(i);
      }
   }
}

return(-1);

#define ds_list_add_mass
//argument0 - list id
//Argument1 - #of elements to add
//Argument2-Argumentx - new elements

var i;

for(i=0;i<argument1;i+=1){
   ds_list_add(argument0,argument[2+i]);
}

return(1);

#define ds_list_copy
//copies a list to a new one
//argument0 - list
//returns new list id
var i,list;
list=ds_list_create();
for(i=0;i<ds_list_size(argument0);i+=1){
   ds_list_add(list,ds_list_find_value(argument0,i));
}
return(list);
#define ds_list_add_list
//appends a list to a list
//argument0 - list
//Argument1 - additional list
//returns list id
var i,list;
for(i=0;i<ds_list_size(argument1);i+=1){
   ds_list_add(argument0,ds_list_find_value(argument1,i));
}
return(argument0);
#define scale_list
//Argument0 - list
//Argument1 - scale
var i;

for(i=0;i<ds_list_size(argument0);i+=1){
   ds_list_replace(argument0,i,ds_list_find_value(argument0,i)*argument1);
}
#define ds_list_add_list
//Appends a list to another list
//
//Argument0 - Main list
//Argument1 - List to add
var i;

for(i=0;i<ds_list_size(argument1);i+=1){
   ds_list_add(argument0,ds_list_find_value(argument1,i));
}
return(ds_list_size(argument0));//Return new size of list
#define interpolate_values
//Argument0 - v1
//Argument1 - v2
//Argument2 - amount(0-1);

return(argument0+(argument2*(argument1-argument0)));
#define GmnCollisionGet
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//call GmnCollisionGet();
//return: 
return external_call(global.__GmnCollisionGet__);

#define GmnCollisionGetNext
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - current
//call GmnCollisionGetNext(current);
//return: 
return external_call(global.__GmnCollisionGetNext__,argument0);

#define GmnCollisionGetObject
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - dCollision
//   Argument1 - index
//call GmnCollisionGetObject(dCollision,index);
//return: 
return external_call(global.__GmnCollisionGetObject__,argument0,argument1);

#define GmnCollisionGetContactCount
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - dCollision
//call GmnCollisionGetContactCount(dCollision);
//return: 
return external_call(global.__GmnCollisionGetContactCount__,argument0);

#define GmnCollisionGetMaxImpactSpeed
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - dCollision
//call GmnCollisionGetMaxImpactSpeed(dCollision);
//return: 
return external_call(global.__GmnCollisionGetMaxImpactSpeed__,argument0);

#define GmnInit
nf("GmnSetCompatabilityMode",1);
nf("GmnGetCompatabilityMode",0);
nf("GmnSetGravity",3);
nf("GmnCreateBody",2);
nf("GmnDestroyBody",2);
nf("GmnBodyLinkObject",3);
nf("GmnBodyUnlinkObject",1);
nf("GmnBodyGetLinked",1);
nf("GmnBodyGetLinkedObject",1);
nf("GmnBodyGetWorld",1);
nf("GmnBodyGetCollision",1);
nf("GmnBodySetMassMatrix",5);
nf("GmnBodySetForce",4);
nf("GmnBodyAddForce",4);
nf("GmnBodyGetForce",2);
nf("GmnBodySetTorque",4);
nf("GmnBodyAddTorque",4);
nf("GmnBodyGetTorque",2);
nf("GmnBodySetAutoFreeze",2);
nf("GmnBodySetAutoSleep",2);
nf("GmnBodySetMaterialGroupID",2);
nf("GmnBodySetContinuousCollisionMode",2);
nf("GmnBodySetJointRecursiveCollision",2);
nf("GmnBodySetVelocity",4);
nf("GmnBodySetVelocityAxis",3);
nf("GmnBodyGetVelocity",2);
nf("GmnBodySetOmega",4);
nf("GmnBodySetOmegaAxis",3);
nf("GmnBodyGetOmega",2);
nf("GmnBodySetLinearDamping",2);
nf("GmnBodyGetLinearDamping",1);
nf("GmnBodySetAngularDamping",4);
nf("GmnBodyGetAngularDamping",2);
nf("GmnBodyAddImpulse",7);
nf("GmnBodySetCentreOfMass",4);
nf("GmnBodySetAutoMassMatrix",3);
nf("GmnBodyAutoGetPosRot",1);
nf("GmnBodyGetPosition",2);
nf("GmnBodyGetRotation",2);
nf("GmnBodySetPosition",4);
nf("GmnBodySetRotation",4);
nf("GmnBodyGetPointGlobalVelocity",5);
nf("GmnBodyGetPointLocalVelocity",5);
nf("GmnBodyAddPointGlobalForce",7);
nf("GmnBodyAddPointLocalForce",7);
nf("GmnBodyGetLocalOmega",2);
nf("createBuoyancyDefine",6);
nf("GmnMaterialSetBuoyancyCallback",5);
nf("GmnCreateNull",1);
nf("GmnCreateBox",7);
nf("GmnCreateSphere",7);
nf("GmnCreateCone",6);
nf("GmnCreateCapsule",6);
nf("GmnCreateCylinder",6);
nf("GmnCreateChamferCylinder",6);
nf("GmnConvexCollisionCalculateVolume",1);
nf("GmnModelBufferClear",0);
nf("GmnModelBufferAdd",3);
nf("GmnModelBufferCount",0);
nf("GmnCreateConvexHull",5);
nf("GmnBeginConstructCompoundCollision",0);
nf("GmnConstructCompoundCollisionAdd",1);
nf("GmnEndConstructCompoundCollision",1);
nf("GmnReleaseCollision",2);
nf("GmnCollisionSetAsTriggerVolume",2);
nf("GmnCustomConstraintCreateRigid",5);
nf("GmnCustomConstraintCreateDryRollingFriction",3);
nf("GmnCreateCustomKinematicController",4);
nf("GmnCustomKinematicControllerSetMaxAngularFriction",2);
nf("GmnCustomKinematicControllerSetMaxLinearFriction",2);
nf("GmnCustomKinematicControllerSetPickMode",2);
nf("GmnCustomKinematicControllerSetTargetPosit",4);
nf("GmnCustomKinematicControllerSetTargetRotation",4);
nf("GmnConstraintCreateBall",6);
nf("GmnBallGetJointForce",2);
nf("GmnBallGetJointForceMag",1);
nf("GmnConstraintCreateUpVector",5);
nf("GmnConstraintCreateHinge",9);
nf("GmnCreateCustomSlider",8);
nf("GmnSliderEnableLimits",2);
nf("GmnSliderSetLimits",3);
nf("GmnDestroyJoint",2);
nf("GmnCustomDestroyJoint",1);
nf("GmnJointSetCollisionState",2);
nf("GmnCustomJointSetCollisionState",2);
nf("GmnCreateCustomHinge",8);
nf("GmnCustomHingeSetLimits",3);
nf("GmnCustomHingeGetForceMagnitude",1);
nf("GmnCustomHingeGetTorqueMagnitude",1);
nf("GmnCustomHingeSetSeverCallscript",2);
nf("GmnCustomHingeSetBreakCallscript",2);
nf("GmnCustomHingeSetSeverTolerance",3);
nf("GmnCustomHingeSetSeverable",2);
nf("GmnCustomHingeSetLimitsBreakTolerance",2);
nf("GmnCustomHingeSetLimitsBreakable",2);
nf("GmnCustomHingeGetLimitsBreakTolerance",1);
nf("GmnCreateCustomRigid",5);
nf("GmnCustomRigidGetForceMagnitude",1);
nf("GmnCustomRigidGetTorqueMagnitude",1);
nf("GmnCustomRigidSetSeverCallscript",2);
nf("GmnCustomRigidSetSeverTolerance",3);
nf("GmnCustomRigidSetSeverable",2);
nf("GmnCreateCustomRigid",9);
nf("GmnCreateCustomPlayerController",3);
nf("GmnCustomPlayerControllerSetMaxSlope",2);
nf("GmnCustomPlayerControllerSetVelocity",4);
nf("GmnMaterialGetDefaultGroupID",1);
nf("GmnMaterialCreateGroupId",1);
nf("GmnMaterialDestroyAllGroupID",1);
nf("GmnMaterialSetDefaultCollidable",4);
nf("GmnMaterialSetContinuousCollisionMode",4);
nf("GmnMaterialSetDefaultFriction",5);
nf("GmnMaterialSetDefaultElasticity",4);
nf("GmnMaterialSetDefaultSoftness",4);
nf("GmnMaterialSetCollisionCallback",3);
nf("GmnMaterialSetResponseType",4);
nf("GmnCollisionGet",0);
nf("GmnCollisionGetNext",1);
nf("GmnCollisionGetObject",2);
nf("GmnCollisionGetContactCount",1);
nf("GmnCollisionGetMaxImpactSpeed",1);
nf("GmnCreateTreeCollision",1);
nf("GmnTreeCollisionBeginBuild",1);
nf("GmnTreeCollisionAddFace",11);
nf("GmnTreeCollisionEndBuild",2);
nf("GmnCreate",0);
nf("GmnDestroy",1);
nf("GmnSetPlatformArchitecture",2);
nf("GmnSetSolverModel",2);
nf("GmnSetFrictionModel",2);
nf("GmnUpdateFPS",2);
nf("GmnUpdate",2);
nf("GmnSetMinimumFrameRate",2);
nf("GmnGetTimeStep",1);
nf("GmnDestroyAllBodies",1);
nf("GmnSetWorldSize",7);
nf("GmnWorldFreezeBody",2);
nf("GmnWorldUnfreezeBody",2);
nf("GmnBodySetFreezeState",2);
nf("GmnWorldGetBodyCount",1);
nf("GmnWorldRayCastDist",7);
nf("GmnWorldRayCastObject",7);

#define GmnSetCompatabilityMode
// GMNewton 1.00
//
//Function:  Set compatability mode of GMNewton
//Notes:
//   Sets compatibility mode flag
//   for correct euler rotation conversions
//   0 - Game Maker rotations
//   1 - Ultimate 3D rotations
//   2 - GMOgre3D
//
//
//Arguments:
//   Argument0 - mode
//call GmnSetCompatabilityMode(mode);
//return: 
return external_call(global.__GmnSetCompatabilityMode__,argument0);

#define GmnGetCompatabilityMode
// GMNewton 1.00
//
//Function: Retrieves the compatability mode set for GMNewton
//Notes:
//   0 - Game Maker rotations
//   1 - Ultimate 3D rotations
//   2 - GMOgre3D
//
//Arguments:
//call GmnGetCompatabilityMode();
//return: 
return external_call(global.__GmnGetCompatabilityMode__);

#define GmnSetGravity
// GMNewton 1.00
//
//Function: Sets global gravity
//Notes:  Gravity is given for each axis to construct a vector.
//        Magnitude of vector is gravity strength
//        ( i.e. basic gravity on z-axis only:  GmnSetGravity(0,0,-9.8) )
//
//Arguments:
//   Argument0 - xForce
//   Argument1 - yForce
//   Argument2 - zForce
//call GmnSetGravity(xForce,yForce,zForce);
//return: 
return external_call(global.__GmnSetGravity__,argument0,argument1,argument2);

#define nf
//argument0 - name
//Argument1 - args

var dllpath;
dllpath=working_directory+"\GMNewton.dll";

str="global.__"+argument0+"__ = external_define("+'"'+dllpath+'"'+","+'"'+argument0+'"'+",dll_stdcall,ty_real,"+string(argument1);

for(i=0;i<argument1;i+=1){
   str+=",ty_real";
}
str+=");";
//get_string("Generated Code:",str);
execute_string(str);

#define gmi_init
//This script is used to initialize gmi script links
//and set up gmi dll calls


nf("DLLInit",0);

external_call(global.__DLLInit__);

nf("set_script_transform_body",1);
gmi_set_script_transform_body(gmi_update_body);

#define gmi_set_script_transform_body
// gmi
//
//Function:
//Notes:  This sets the script that the dll uses to automatically update a body
//
//Arguments:
//   Argument0 - script [script args:(body,x,y,z,xrot,yrot,zrot)]
//call GmnBodySetForce(script);
//return: 
return external_call(global.__set_script_transform_body__,argument0);


#define gmi_update_body
//GM Interface
//This is a script used by the dll to auto-update the position and rotation
//of a rigid body.  Although it is not intended to be called or modified by
//the user, advanced users may find it useful to do so.
//
//Argument0 - body id
//Argument1 - x
//Argument2 - y
//Argument3 - z
//Argument4 - xrot
//Argument5 - yrot
//Argument6 - zrot

if(instance_exists(argument0)){
   argument0.x=argument1;
   argument0.y=argument2;
   argument0.z=argument3;
   argument0.xrot=radtodeg(argument4);
   argument0.yrot=radtodeg(argument5);
   argument0.zrot=radtodeg(argument6);
   return(1);
}else{
   return(0);
}
#define GmnCreate
// GMNewton 1.00
//
//Function:  Creates a new Newton world
//Notes:
//
//Arguments:
//call GmnCreate();
//return: 
return external_call(global.__GmnCreate__);

#define GmnDestroy
// GMNewton 1.00
//
//Function:  Destroys a Newton world
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//call GmnDestroy(dWorld);
//return: 
return external_call(global.__GmnDestroy__,argument0);

#define GmnSetPlatformArchitecture
// GMNewton 1.00
//
//Function:  Set the current platform hardware architecture.
//Notes:  <taken from NGD Wiki>
//This function allows the application to configure the Newton to take advantage for specific hardware architecture in the same platform.
//0 - force the hardware lower common denominator for the running platform.
//1 - will try to use common floating point enhancement like spacial instruction set on the specific architecture. This mode made lead to result that differ from mode 1 and 2 as the accumulation round off errors maybe different.
//2 - the engine will try to use the best possible hardware setting found in the current platform this is the default configuration. This mode made lead to result that differ from mode 1 and 2 as the accumulation round off errors maybe different.
//the only hardware mode guarantee to work is mode 0. all other are only hints to the engine, for example setting mode 1 will take not effect on CPUs without specially floating point instructions set.
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - mode
//call GmnSetPlatformArchitecture(dWorld,mode);
//return: 
return external_call(global.__GmnSetPlatformArchitecture__,argument0,argument1);

#define GmnSetSolverModel
// GMNewton 1.00
//
//Function:  
//Notes:  <copied from NGD Wiki>
//        0 is the exact solver (default).
//                This is a one pass solver that calculates regular and frictional forces at the same time. Use this model if you require a high degree of accuracy in your simulation.
//        n ( > 0 ) is the linear solver
//               This is a complete iterative solver which peform n iterations per update. Increasing the number of iterations will improve accuracy at the cost of solver speed. Use this model if you require speed over accuracy in your simulation.
//
//        The adaptive friction model combined with the linear solver model make for the fastest possible configuration of the Newton solver. This setup is best for games. If you need the best realistic behavior, we recommend the use of the exact solver and exact friction model which are the defaults.
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - model
//call GmnSetSolverModel(dWorld,model);
//return: 
return external_call(global.__GmnSetSolverModel__,argument0,argument1);

#define GmnSetFrictionModel
// GMNewton 1.00
//
//Function:  Set friction model used
//Notes:   This command speficies the accuracy of friction used by the exact solver. This command has no effect when using the linear solver.
//        0 is the exact model (default).
//        1 is the adaptive model.
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - model
//call GmnSetFrictionModel(dWorld,model);
//return: 
return external_call(global.__GmnSetFrictionModel__,argument0,argument1);

#define GmnSetMinimumFrameRate
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - framerate
//call GmnSetMinimumFrameRate(dWorld,framerate);
//return: 
return external_call(global.__GmnSetMinimumFrameRate__,argument0,argument1);

#define GmnUpdateFPS
// GMNewton 1.00
//
//Function: Update the simulation with the given fps
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - fps
//call GmnUpdateFPS(dWorld,fps);
//return: 
return external_call(global.__GmnUpdateFPS__,argument0,argument1);

#define GmnUpdate
// GMNewton 1.00
//
//Function: Update simulation by given number of seconds
//Notes:  1/room_speed will update at same fps as game
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - timestep
//call GmnUpdate(dWorld,timestep);
//return: 
return external_call(global.__GmnUpdate__,argument0,argument1);

#define GmnDestroyAllBodies
// GMNewton 1.00
//
//Function:  Destroys all bodies in a newton world
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//call GmnDestroyAllBodies(dWorld);
//return: 
return external_call(global.__GmnDestroyAllBodies__,argument0);

#define GmnSetWorldSize
// GMNewton 1.00
//
//Function:  Sets the size of the Newton world
//Notes:  Bodies and raycasts will not be processed when outside of the world
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - x1
//   Argument2 - y1
//   Argument3 - z1
//   Argument4 - x2
//   Argument5 - y2
//   Argument6 - z2
//call GmnSetWorldSize(dWorld,x1,y1,z1,x2,y2,z2);
//return: 
return external_call(global.__GmnSetWorldSize__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnWorldGetBodyCount
// GMNewton 1.00
//
//Function:  Returns the number of bodies in the Newton world
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//call GmnWorldGetBodyCount(dWorld);
//return: 
return external_call(global.__GmnWorldGetBodyCount__,argument0);

#define GmnBodyLinkObject
// GMNewton 1.00
//
//Function:  Links a GM object and a Newton body together
//Notes:  This makes it possible to do two things:
//          1) Generate correct collision responses in Game Maker
//          2) Allow GMNewton to automatically update transformation of object
//        Setting the body to auto-update is optional
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - objid
//   Argument2 - autoupdate
//call GmnBodyLinkObject(dBody,objid,autoupdate);
//return: 
return external_call(global.__GmnBodyLinkObject__,argument0,argument1,argument2);

#define GmnBodyUnlinkObject
// GMNewton 1.00
//
//Function:  Unlinks a GM object and the Newton body it is linked to
//Notes:  Until re-enabled, the object will not be automatically updated
//        and objects will not be identified in collisions for event generation
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyUnlinkObject(dBody);
//return: 
return external_call(global.__GmnBodyUnlinkObject__,argument0);

#define GmnBodyGetLinked
// GMNewton 1.00
//
//Function:  Check if a body is linked to an object
//Notes:
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyGetLinked(dBody);
//return: 
return external_call(global.__GmnBodyGetLinked__,argument0);

#define GmnBodyGetLinkedObject
// GMNewton 1.00
//
//Function:  Retrieves the id of the object a body is linked to
//Notes:
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyGetLinkedObject(dBody);
//return: 
return external_call(global.__GmnBodyGetLinkedObject__,argument0);

#define GmnBodyAutoGetPosRot
// GMNewton 1.00
//
//Function:  Calls the auto-update script with new position and orientation of given body
//Notes:  Body must be linked to an object
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyAutoGetPosRot(dBody);
//return: 
return external_call(global.__GmnBodyAutoGetPosRot__,argument0);

#define GmnBodySetLinearDamping
// GMNewton 1.00
//
//Function:  Sets linear damping of body
//Notes:  The dampening viscous friction force is added to the external force applied to the body every frame before going to the solver-integrator.
//        linearDamp is clamped between 0 and 1, default being .1
//        There is a non zero implicit attenuation value of 0.0001 assumed by the integrator
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - linearDamp
//call GmnBodySetLinearDamping(dBody,linearDamp);
//return: 
return external_call(global.__GmnBodySetLinearDamping__,argument0,argument1);

#define GmnBodyGetLinearDamping
// GMNewton 1.00
//
//Function:  Gets the linear damp setting of a body
//Notes:
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyGetLinearDamping(dBody);
//return: 
return external_call(global.__GmnBodyGetLinearDamping__,argument0);

#define GmnBodySetAngularDamping
// GMNewton 1.00
//
//Function:  Sets rotational damping of body
//Notes:  damping on each axis is clamped between 0 and 1
//        There is a non zero implicit attenuation value of 0.0001 assumed by the integrator
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - angularDampX
//   Argument2 - angularDampY
//   Argument3 - angularDampZ
//call GmnBodySetAngularDamping(dBody,angularDampX,angularDampY,angularDampZ);
//return: 
return external_call(global.__GmnBodySetAngularDamping__,argument0,argument1,argument2,argument3);

#define GmnBodyGetAngularDamping
// GMNewton 1.00
//
//Function:  Gets the rotational damping of body on given axis
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - axis
//call GmnBodyGetAngularDamping(dBody,axis);
//return: 
return external_call(global.__GmnBodyGetAngularDamping__,argument0,argument1);

#define GmnCreateBody
// GMNewton 1.00
//
//Function:  Creates a body in the newton world
//Notes:  The concept of bodies is quite simple.  If you understand GM, understanding bodies should be easy.
//        Bodies in Newton are as objects are in GM.
//        Collisions are as sprites or masks used for collision
//        Bodies must be created in a "world"
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - dCollision
//call GmnCreateBody(dWorld,dCollision);
//return: 
return external_call(global.__GmnCreateBody__,argument0,argument1);

#define GmnDestroyBody
// GMNewton 1.00
//
//Function:  Destroys a newton body
//Notes:  Call this to remove a body from the simulation
//        It is importaint to remember this when destroying objects
//         so that the body does not continue to be simulated
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - dBody
//call GmnDestroyBody(dWorld,dBody);
//return: 
return external_call(global.__GmnDestroyBody__,argument0,argument1);

#define GmnBodyGetWorld
// GMNewton 1.00
//
//Function:  Retrieves the world that a body exists in
//Notes:
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyGetWorld(dBody);
//return: 
return external_call(global.__GmnBodyGetWorld__,argument0);

#define GmnBodyGetCollision
// GMNewton 1.00
//
//Function:  Gets the collision shape assigned to the body
//Notes:
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyGetCollision(dBody);
//return: 
return external_call(global.__GmnBodyGetCollision__,argument0);

#define GmnBodySetMaterialGroupID
// GMNewton 1.00
//
//Function:  Applies given material to body
//Notes:  Materials define how bodies interact with each other.
//        This includes how bouncy, soft, friction, etc. of reaction to collisions
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - id
//call GmnBodySetMaterialGroupID(dBody,id);
//return: 
return external_call(global.__GmnBodySetMaterialGroupID__,argument0,argument1);

#define GmnBodySetAutoSleep
// GMNewton 1.00
//
//Function:  Sets if Newton may put a body to sleep after it is unactive for a time
//Notes:  Sleeping is a low-processing state that an unmoving body is placed in if allowed.
//        Bodies will automatically wake up and resume simulation if an outside force is applied
//        Or contact is made with another body
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - state (true/false)
//call GmnBodySetAutoSleep(dBody,state);
//return: 
return external_call(global.__GmnBodySetAutoSleep__,argument0,argument1);

#define GmnBodySetCentreOfMass
// GMNewton 1.00
//
//Function: Sets the center of mass of a body
//Notes:  By default, this is set to (0,0,0) local body space
//        New COM is given in offset from local origin ob body
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - Xoffset
//   Argument2 - Yoffset
//   Argument3 - Zoffset
//call GmnBodySetCentreOfMass(dBody,Xoffset,Yoffset,Zoffset);
//return: 
return external_call(global.__GmnBodySetCentreOfMass__,argument0,argument1,argument2,argument3);

#define GmnBodySetMassMatrix
// GMNewton 1.00
//
//Function:  Sets up the mass and moment of inertia
//Notes:  Mass defines the resistance to motion
//        Ixx, Iyy, and Izz are the resistance to rotation on the given axis
//        The function GmnBodySetAutoMassMatrix can calculate this automatically
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - mass
//   Argument2 - Ixx
//   Argument3 - Iyy
//   Argument4 - Izz
//call GmnBodySetMassMatrix(dBody,mass,Ixx,Iyy,Izz);
//return: 
return external_call(global.__GmnBodySetMassMatrix__,argument0,argument1,argument2,argument3,argument4);

#define GmnBodySetAutoMassMatrix
// GMNewton 1.00
//
//Function:  Automaticaly calculates moment of inertia values(resistance to rotation) for a convex hull
//Notes:  Only for use on convex collision, not collision trees
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - mass
//   Argument2 - doCom
//call GmnBodySetAutoMassMatrix(dBody,mass,doCom);
//return: 
return external_call(global.__GmnBodySetAutoMassMatrix__,argument0,argument1,argument2);

#define GmnBodySetContinuousCollisionMode
// GMNewton 1.00
//
//Function:  Turns CCD on or off for body
//Notes:  ContinuousCollisionDetection prevents small, fast-moving bodies from passing through other bodies
//        CCD is slower than normal processing, and should be applied only when needed to maintain simulation speed
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - state (true/false)
//call GmnBodySetContinuousCollisionMode(dBody,state);
//return: 
return external_call(global.__GmnBodySetContinuousCollisionMode__,argument0,argument1);

#define GmnBodySetJointRecursiveCollision
// GMNewton 1.00
//
//Function:  Sets if jointed bodies react to each other
//Notes:  Sometimes when two bodies are jointed together it is necessary to disable collisions between them to achieve desired effect
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - state
//call GmnBodySetJointRecursiveCollision(dBody,state);
//return: 
return external_call(global.__GmnBodySetJointRecursiveCollision__,argument0,argument1);

#define GmnBodySetFreezeState
// GMNewton 1.00
//
//Function:  Puts a body to sleep or wakes it up
//Notes:  Sleeping bodies are not simulated, but are wakened when acted on by outside force
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - state
//call GmnBodySetFreezeState(dBody,state);
//return: 
return external_call(global.__GmnBodySetFreezeState__,argument0,argument1);

#define GmnBodyAddImpulse
// GMNewton 1.00
//
//Function:  Adds an impulse to body at given position and magnitude
//Notes:  Applied in global space, with impulse representing change in velocity
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - xOrig
//   Argument2 - yOrig
//   Argument3 - zOrig
//   Argument4 - xImpulse
//   Argument5 - yImpulse
//   Argument6 - zImpulse
//call GmnBodyAddImpulse(dBody,xOrig,yOrig,zOrig,xImpulse,yImpulse,zImpulse);
//return: 
return external_call(global.__GmnBodyAddImpulse__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnBodyGetPointGlobalVelocity
// GMNewton 1.00
//
//Function:  Retrieves body's velocity at specific point in global space
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - x
//   Argument2 - y
//   Argument3 - z
//   Argument4 - axis
//call GmnBodyGetPointGlobalVelocity(dBody,x,y,z,axis);
//return: 
return external_call(global.__GmnBodyGetPointGlobalVelocity__,argument0,argument1,argument2,argument3,argument4);

#define GmnBodyGetPointLocalVelocity
// GMNewton 1.00
//
//Function:  Retrieves body's velocity at specific point in local space
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - x
//   Argument2 - y
//   Argument3 - z
//   Argument4 - axis
//call GmnBodyGetPointLocalVelocity(dBody,x,y,z,axis);
//return: 
return external_call(global.__GmnBodyGetPointLocalVelocity__,argument0,argument1,argument2,argument3,argument4);

#define GmnBodyAddPointGlobalForce
// GMNewton 1.00
//
//Function:  Adds force to body at a specified point in global space
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - x
//   Argument2 - y
//   Argument3 - z
//   Argument4 - xforce
//   Argument5 - yforce
//   Argument6 - zforce
//call GmnBodyAddPointGlobalForce(dBody,x,y,z,xforce,yforce,zforce);
//return: 
return external_call(global.__GmnBodyAddPointGlobalForce__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnBodyAddPointLocalForce
// GMNewton 1.00
//
//Function:  Adds force to body at a specified point in local space
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - x
//   Argument2 - y
//   Argument3 - z
//   Argument4 - xforce
//   Argument5 - yforce
//   Argument6 - zforce
//call GmnBodyAddPointLocalForce(dBody,x,y,z,xforce,yforce,zforce);
//return: 
return external_call(global.__GmnBodyAddPointLocalForce__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnBodyGetLocalOmega
// GMNewton 1.00
//
//Function:  Retrieves body's omega in local space
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - axis
//call GmnBodyGetLocalOmega(dBody,axis);
//return: 
return external_call(global.__GmnBodyGetLocalOmega__,argument0,argument1);

#define GmnBodySetTorque
// GMNewton 1.00
//
//Function:  Sets rotational torque to be applied next update
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - xTorque
//   Argument2 - yTorque
//   Argument3 - zTorque
//call GmnBodySetTorque(dBody,xTorque,yTorque,zTorque);
//return: 
return external_call(global.__GmnBodySetTorque__,argument0,argument1,argument2,argument3);

#define GmnBodyAddTorque
// GMNewton 1.00
//
//Function:  Adds torque to the accumulated amount to be applied next update
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - xTorque
//   Argument2 - yTorque
//   Argument3 - zTorque
//call GmnBodyAddTorque(dBody,xTorque,yTorque,zTorque);
//return: 
return external_call(global.__GmnBodyAddTorque__,argument0,argument1,argument2,argument3);

#define GmnBodyGetTorque
// GMNewton 1.00
//
//Function:  Retrieves the tourque to be applied next update for a given axis
//Notes:  axis is as follows:  x-0, y-1, z-2
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - axis
//call GmnBodyGetTorque(dBody,axis);
//return: 
return external_call(global.__GmnBodyGetTorque__,argument0,argument1);

#define GmnBodySetOmega
// GMNewton 1.00
//
//Function:  Sets rotational velocity(omega) of body
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - ox
//   Argument2 - oy
//   Argument3 - oz
//call GmnBodySetOmega(dBody,ox,oy,oz);
//return: 
return external_call(global.__GmnBodySetOmega__,argument0,argument1,argument2,argument3);

#define GmnBodyGetOmega
// GMNewton 1.00
//
//Function:  Retrieves the rotational speed of body on given axis
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - axis
//call GmnBodyGetOmega(dBody,axis);
//return: 
return external_call(global.__GmnBodyGetOmega__,argument0,argument1);

#define GmnBodySetOmegaAxis
// GMNewton 1.00
//
//Function:  Sets rotational velocity(omega) of body changing only the given axis
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - omega
//   Argument2 - axis
//call GmnBodySetOmegaAxis(dBody,omega,axis);
//return: 
return external_call(global.__GmnBodySetOmegaAxis__,argument0,argument1,argument2);

#define GmnBodyGetPosition
// GMNewton 1.00
//
//Function:  Gets position of body on given axis
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - axis
//call GmnBodyGetPosition(dBody,axis);
//return: 
return external_call(global.__GmnBodyGetPosition__,argument0,argument1);

#define GmnBodySetPosition
// GMNewton 1.00
//
//Function:  Sets position of body on given axis
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - x
//   Argument2 - y
//   Argument3 - z
//call GmnBodySetPosition(dBody,x,y,z);
//return: 
return external_call(global.__GmnBodySetPosition__,argument0,argument1,argument2,argument3);

#define GmnBodyGetRotation
// GMNewton 1.00
//
//Function:  Gets rotation of body on given axis
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - axis
//call GmnBodyGetRotation(dBody,axis);
//return: 
return external_call(global.__GmnBodyGetRotation__,argument0,argument1);

#define GmnBodySetRotation
// GMNewton 1.00
//
//Function:  Sets rotation of body on given axis
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - xrot
//   Argument2 - yrot
//   Argument3 - zrot
//call GmnBodySetRotation(dBody,xrot,yrot,zrot);
//return: 
return external_call(global.__GmnBodySetRotation__,argument0,argument1,argument2,argument3);

#define GmnBodySetForce
// GMNewton 1.00
//
//Function:  Sets the force to be applied to body next update
//Notes:   Given as a 3d vector, the force applied to each axis
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - xForce
//   Argument2 - yForce
//   Argument3 - zForce
//call GmnBodySetForce(dBody,xForce,yForce,zForce);
//return: 
return external_call(global.__GmnBodySetForce__,argument0,argument1,argument2,argument3);

#define GmnBodyAddForce
// GMNewton 1.00
//
//Function:  Adds force to the accumulated amount to be applied to body next update
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - xForce
//   Argument2 - yForce
//   Argument3 - zForce
//call GmnBodyAddForce(dBody,xForce,yForce,zForce);
//return: 
return external_call(global.__GmnBodyAddForce__,argument0,argument1,argument2,argument3);

#define GmnBodyGetForce
// GMNewton 1.00
//
//Function:  Gets the force to be applied to a body next update
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - axis
//call GmnBodyGetForce(dBody,axis);
//return: 
return external_call(global.__GmnBodyGetForce__,argument0,argument1);

#define GmnBodySetVelocity
// GMNewton 1.00
//
//Function:  Sets the velocity of a body
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - vx
//   Argument2 - vy
//   Argument3 - vz
//call GmnBodySetVelocity(dBody,vx,vy,vz);
//return: 
return external_call(global.__GmnBodySetVelocity__,argument0,argument1,argument2,argument3);

#define GmnBodySetVelocityAxis
// GMNewton 1.00
//
//Function:  Sets the velocity of an object modifying only the velocity on given axis
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - vel
//   Argument2 - axis
//call GmnBodySetVelocityAxis(dBody,vel,axis);
//return: 
return external_call(global.__GmnBodySetVelocityAxis__,argument0,argument1,argument2);

#define GmnBodyGetVelocity
// GMNewton 1.00
//
//Function:  Retrieves velocity of body on given axis
//Notes:
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - axis
//call GmnBodyGetVelocity(dBody,axis);
//return: 
return external_call(global.__GmnBodyGetVelocity__,argument0,argument1);

#define GmnBeginConstructCompoundCollision
// GMNewton 1.00
//
//Function:  Begins the construction of a compound collision
//Notes:  Convex shapes can be combined together in a compound collision to approximate a concave object
//
//Arguments:
//call GmnBeginConstructCompoundCollision();
//return: 
return external_call(global.__GmnBeginConstructCompoundCollision__);

#define GmnConstructCompoundCollisionAdd
// GMNewton 1.00
//
//Function:  Adds a collision shape to the compound collision
//Notes:  Convex shapes can be combined together in a compound collision to approximate a concave object
//
//Arguments:
//   Argument0 - dCol
//call GmnConstructCompoundCollisionAdd(dCol);
//return: 
return external_call(global.__GmnConstructCompoundCollisionAdd__,argument0);

#define GmnEndConstructCompoundCollision
// GMNewton 1.00
//
//Function:  Finalizes buffer into compound collision and returns the id
//Notes:  Clears all collisions from buffer
//        Convex shapes can be combined together in a compound collision to approximate a concave object
//
//Arguments:
//   Argument0 - dWorld
//call GmnEndConstructCompoundCollision(dWorld);
//return: 
return external_call(global.__GmnEndConstructCompoundCollision__,argument0);

#define GmnModelBufferClear
// GMNewton 1.00
//
//Function:  Clears the model buffer
//Notes:  GMNewton has a model buffer that is used to transfer models to it point by point or convex hull generation
//
//Arguments:
//call GmnModelBufferClear();
//return: 
return external_call(global.__GmnModelBufferClear__);

#define GmnModelBufferAdd
// GMNewton 1.00
//
//Function:  Adds a point to the model buffer
//Notes:  GMNewton has a model buffer that is used to transfer models to it point by point or convex hull generation
//
//Arguments:
//   Argument0 - x
//   Argument1 - y
//   Argument2 - z
//call GmnModelBufferAdd(x,y,z);
//return: 
return external_call(global.__GmnModelBufferAdd__,argument0,argument1,argument2);

#define GmnModelBufferAddFromList
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - list
//call GmnModelBufferAddFromList(list);
//return: number of points added
var pointcount;
pointcount=floor(ds_list_size(argument0)/3);
for(i=0;i<pointcount;i+=1){
   v_x=ds_list_find_value(argument0,i*3);
   v_y=ds_list_find_value(argument0,i*3+1);
   v_z=ds_list_find_value(argument0,i*3+2);
   //show_message(string(pointcount)+"##"+string(v_x)+"#"+string(v_y)+"#"+string(v_z));
   external_call(global.__GmnModelBufferAdd__,v_x,v_y,v_z);
}

return(pointcount); 

#define GmnModelBufferLoadMod
//Argument0 - path to model.
//Argument1 - scale.  Defaults to 1.
//
//returns model id
//Loades a model to dll from mod file.

var filetext,data,file,modelid,start,count,lines,i,point_count;

if(argument1=0){
   argument1=1;
}
point_count=0;

data=ds_list_create();


if(!file_exists(argument0)) return(-1);//return -1 if file not found

file=file_text_open_read(argument0);
GmnModelBufferClear()//Clear the model buffer
show_debug_message("start load model:"+argument0)
file_text_readln(file);
lines=file_text_read_real(file);
file_text_readln(file);
file_text_readln(file);//navigate to start of model data

for(i=0;i<lines-2;i+=1){
   filetext=file_text_read_string(file);
   if(string_count(" ",filetext)>=3){
      start=string_pos_ext(" " , filetext , 1)+1;
      count=string_pos_ext(" " , filetext , 4)-start
      filetext=string_copy(filetext,start,count);
      ds_list_clear(data);
      string_to_list_ext(filetext," ",data);
      scale_list(data,argument1);
      point_count+=1;
      GmnModelBufferAddFromList(data);
      ds_list_clear(data)
   }else{
      show_debug_message("not enough data in line : "+filetext);
   }
   if(i<lines-3){
      file_text_readln(file);
   }
}
ds_list_destroy(data);
file_text_close(file);
return(1);


#define GmnModelBufferCount
// GMNewton 1.00
//
//Function:  Returns the number of points in the model buffer
//Notes:  GMNewton has a model buffer that is used to transfer models to it point by point or convex hull generation
//
//Arguments:
//call GmnModelBufferCount();
//return: 
return external_call(global.__GmnModelBufferCount__);

#define GmnCreateConvexHull
// GMNewton 1.00
//
//Function:  Creates a convex hull collision shape from the points in the model buffer
//Notes:  Offets define position relative to origin
//        tolerance is a value between 0 and 1 telling Newton how much leeway it has in optimizing the hull.
//          0 yields the best representation, while 1 yields the fastest but least acurate representation
//        GMNewton has a model buffer that is used to transfer models to it point by point or convex hull generation
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - offset_x
//   Argument2 - offset_y
//   Argument3 - offset_z
//   Argument4 - tolerance
//call GmnCreateConvexHull(dWorld,offset_x,offset_y,offset_z,tolerance);
//return: 
return external_call(global.__GmnCreateConvexHull__,argument0,argument1,argument2,argument3,argument4);

#define GmnConvexCollisionCalculateVolume
// GMNewton 1.00
//
//Function:  Calculates the approximate volume of a convex collision
//Notes:  Useful to set the mass of an object based on density and volume
//        (Not to be used on collision trees, as they are not necessarily closed shapes)
//
//Arguments:
//   Argument0 - dCollision
//call GmnConvexCollisionCalculateVolume(dCollision);
//return: 
return external_call(global.__GmnConvexCollisionCalculateVolume__,argument0);

#define GmnReleaseCollision
// GMNewton 1.00
//
//Function:  Releases a collision shape returning control to Newton
//Notes:  Collision objects are reference counted objects. The application should call NewtonReleaseCollision in order to release references to the object. Neglecting to release references to collision primitives is a common cause of memory leaks.
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - dCollision
//call GmnReleaseCollision(dWorld,dCollision);
//return: 
return external_call(global.__GmnReleaseCollision__,argument0,argument1);

#define GmnCollisionSetAsTriggerVolume
// GMNewton 1.00
//
//Function:  Turns the collision into a trigger volume or vice versa
//Notes:  Trigger volumes are different from normal collisions in that they don't generate contacts. They are useful to trigger events if a body hits the trigger volume.
//        Only convex collision primitives can be used as trigger volumes.
//
//Arguments:
//   Argument0 - dCollision
//   Argument1 - trigger
//call GmnCollisionSetAsTriggerVolume(dCollision,trigger);
//return: 
return external_call(global.__GmnCollisionSetAsTriggerVolume__,argument0,argument1);

#define GmnCreateNull
// GMNewton 1.00
//
//Function:  Creates a Null collision shape
//Notes:  Does not collide with anything, but may be useful for say controlling another body or the neck of a ragdoll
//
//Arguments:
//   Argument0 - dWorld
//call GmnCreateNull(dWorld);
//return: 
return external_call(global.__GmnCreateNull__,argument0);

#define GmnCreateBox
// GMNewton 1.00
//
//Function:  Creates a box collision shape
//Notes:  dx, dy, and dz define the length of box on x, y, and z axi
//        Offset moves collision shape from origin by given amount
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - dx
//   Argument2 - dy
//   Argument3 - dz
//   Argument4 - offset_x
//   Argument5 - offset_y
//   Argument6 - offset_z
//call GmnCreateBox(dWorld,dx,dy,dz,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateBox__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnCreateSphere
// GMNewton 1.00
//
//Function:  Creates a spherical collision shape
//Notes:  Define the radius of box on x, y, and z axi
//        Offset moves collision shape from origin by given amount
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - radiusX
//   Argument2 - radiusY
//   Argument3 - radiusZ
//   Argument4 - offset_x
//   Argument5 - offset_y
//   Argument6 - offset_z
//call GmnCreateSphere(dWorld,radiusX,radiusY,radiusZ,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateSphere__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnCreateCone
// GMNewton 1.00
//
//Function:  Creates a cone collision shape
//Notes:  'radius' defines base, and 'height' the height
//        Offset moves collision shape from origin
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - radius
//   Argument2 - height
//   Argument3 - offset_x
//   Argument4 - offset_y
//   Argument5 - offset_z
//call GmnCreateCone(dWorld,radius,height,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateCone__,argument0,argument1,argument2,argument3,argument4,argument5);

#define GmnCreateCapsule
// GMNewton 1.00
//
//Function:  Creates a capsule collision shape
//Notes:  A cylinder with rounded ends
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - radius
//   Argument2 - height
//   Argument3 - offset_x
//   Argument4 - offset_y
//   Argument5 - offset_z
//call GmnCreateCapsule(dWorld,radius,height,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateCapsule__,argument0,argument1,argument2,argument3,argument4,argument5);

#define GmnCreateCylinder
// GMNewton 1.00
//
//Function:  Creates a cylinder collision shape
//Notes:  "radius" defines the radius of the cylinder, and "height" the height.
//        This was really a useful note eh?
//        Offsets shift the shape from the origin
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - radius
//   Argument2 - height
//   Argument3 - offset_x
//   Argument4 - offset_y
//   Argument5 - offset_z
//call GmnCreateCylinder(dWorld,radius,height,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateCylinder__,argument0,argument1,argument2,argument3,argument4,argument5);

#define GmnCreateChamferCylinder
// GMNewton 1.00
//
//Function:  Creates a ChamferCylinder shape
//Notes:  Radius, height define size
//        Offsets displace from origin
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - radius
//   Argument2 - height
//   Argument3 - offset_x
//   Argument4 - offset_y
//   Argument5 - offset_z
//call GmnCreateChamferCylinder(dWorld,radius,height,offset_x,offset_y,offset_z);
//return: 
return external_call(global.__GmnCreateChamferCylinder__,argument0,argument1,argument2,argument3,argument4,argument5);

#define GmnWorldRayCastDist
// GMNewton 1.00
//
//Function:  Casts a ray and returns distance to nearest hit
//Notes:  ray is of finite distance, a line segment from (x1,y1,z1) to (x2,y2,z2)
//        Negative value returned if no hit
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - x1
//   Argument2 - y1
//   Argument3 - z1
//   Argument4 - x2
//   Argument5 - y2
//   Argument6 - z2
//call GmnWorldRayCastDist(dWorld,x1,y1,z1,x2,y2,z2);
//return: 
return external_call(global.__GmnWorldRayCastDist__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnWorldRayCastObject
// GMNewton 1.00
//
//Function:  Casts a ray and returns id of object linked to the nearest body hit
//Notes:  ray is of finite distance, a line segment from (x1,y1,z1) to (x2,y2,z2)
//        Negative value returned if no hit
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - x1
//   Argument2 - y1
//   Argument3 - z1
//   Argument4 - x2
//   Argument5 - y2
//   Argument6 - z2
//call GmnWorldRayCastObject(dWorld,x1,y1,z1,x2,y2,z2);
//return: 
return external_call(global.__GmnWorldRayCastObject__,argument0,argument1,argument2,argument3,argument4,argument5,argument6);

#define GmnCreateTreeCollision
// GMNewton 1.00
//
//Function:  Creates a tre collision
//Notes:  Tree collisions can be concave, but must be static(mass == 0)
//        Excellent for enviroment mesh
//
//Arguments:
//   Argument0 - dWorld
//call GmnCreateTreeCollision(dWorld);
//return: 
return external_call(global.__GmnCreateTreeCollision__,argument0);

#define GmnTreeCollisionBeginBuild
// GMNewton 1.00
//
//Function:  Set up to begin the construction of Tree Collision
//Notes:
//
//Arguments:
//   Argument0 - dCollision
//call GmnTreeCollisionBeginBuild(dCollision);
//return: 
return external_call(global.__GmnTreeCollisionBeginBuild__,argument0);

#define GmnTreeCollisionAddFace
// GMNewton 1.00
//
//Function:  Adds a face to a tree collision
//Notes:
//
//Arguments:
//   Argument0 - dCollision
//   Argument1 - x1
//   Argument2 - y1
//   Argument3 - z1
//   Argument4 - x2
//   Argument5 - y2
//   Argument6 - z2
//   Argument7 - x3
//   Argument8 - y3
//   Argument9 - z3
//   Argument10 - id
//call GmnTreeCollisionAddFace(dCollision,x1,y1,z1,x2,y2,z2,x3,y3,z3,id);
//return: 
return external_call(global.__GmnTreeCollisionAddFace__,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7,argument8,argument9,argument10);

#define GmnTreeCollisionAddMesh
//  GMNewton
//
//argument0 - TreeCollision
//argument1 - path to model.
//argument2 - scale.  Defaults to 1.
//
//returns model id
//Loades a model to dll from mod file.

var filetext,data,file,start,count,lines,i,facesadded,collision,triangles;

if(argument2=0){
   argument2=1;
}

triangles=ds_list_create();
facesadded=0;

data=ds_list_create();

if(!file_exists(argument1)) return(-1);//return -1 if file not found

file=file_text_open_read(argument1);
show_debug_message("start load model:"+argument1)
file_text_readln(file);
lines=file_text_read_real(file);
file_text_readln(file);
file_text_readln(file);//navigate to start of model data
global.debug=0;
for(i=0;i<lines-2;i+=1){
   filetext=file_text_read_string(file);
   if(string_count(" ",filetext)>=3){
      start=string_pos_ext(" " , filetext , 1)+1;
      count=string_pos_ext(" " , filetext , 4)-start
      filetext=string_copy(filetext,start,count);
      ds_list_clear(data);
      string_to_list_ext(filetext," ",data);
      scale_list(data,argument2);
      ds_list_add_list(triangles,data)
      ds_list_clear(data)
   }else{
      show_debug_message("not enough data in line : "+filetext+"  id:"+string(modelid));
   }
   if(i<lines-3){
      file_text_readln(file);
   }
}
ds_list_destroy(data);
file_text_close(file);

for(i=0;i<ds_list_size(triangles);i+=9){
   facesadded=ds_list_size(triangles)/3;
   GmnTreeCollisionAddFace(argument0, ds_list_find_value(triangles,i), ds_list_find_value(triangles,i+1), ds_list_find_value(triangles,i+2),
   ds_list_find_value(triangles,i+3), ds_list_find_value(triangles,i+4), ds_list_find_value(triangles,i+5),
   ds_list_find_value(triangles,i+6), ds_list_find_value(triangles,i+7), ds_list_find_value(triangles,i+8),
   1);
}
ds_list_destroy(triangles);

return(facesadded);

#define GmnTreeCollisionEndBuild
// GMNewton 1.00
//
//Function:  Finalizes the tree collision into a usable collision shape
//Notes:
//
//Arguments:
//   Argument0 - dCollision
//   Argument1 - optimize (true/false)
//call GmnTreeCollisionEndBuild(dCollision,optimize);
//return: 
return external_call(global.__GmnTreeCollisionEndBuild__,argument0,argument1);

#define GmnConstraintCreateBall
// GMNewton 1.00
//
//Function:  reates a ball and socket joint
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - px
//   Argument2 - py
//   Argument3 - pz
//   Argument4 - dChildBody
//   Argument5 - dParentBody
//call GmnConstraintCreateBall(dWorld,px,py,pz,dChildBody,dParentBody);
//return: 
return external_call(global.__GmnConstraintCreateBall__,argument0,argument1,argument2,argument3,argument4,argument5);

#define GmnBallGetJointForce
// GMNewton 1.00
//
//Function:  Gets the force applied by joint
//Notes:
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - axis
//call GmnBallGetJointForce(dJoint,axis);
//return: 
return external_call(global.__GmnBallGetJointForce__,argument0,argument1);

#define GmnBallGetJointForceMag
// GMNewton 1.00
//
//Function:  Gets the magnitude of force applied by joint
//Notes:
//
//Arguments:
//   Argument0 - dJoint
//call GmnBallGetJointForceMag(dJoint);
//return: 
return external_call(global.__GmnBallGetJointForceMag__,argument0);

#define GmnDestroyJoint
// GMNewton 1.00
//
//Function: Destroys a basic joint
//Notes:  For custom joints, use GmnCustomDestroyJoint
//        Joints are automatically destroyed when one of the connected bodies is
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - dJoint
//call GmnDestroyJoint(dWorld,dJoint);
//return: 
return external_call(global.__GmnDestroyJoint__,argument0,argument1);

#define GmnCustomDestroyJoint
// GMNewton 1.00
//
//Function:  Destroys a custom joint
//Notes:
//
//Arguments:
//   Argument0 - dJoint
//call GmnCustomDestroyJoint(dJoint);
//return: 
return external_call(global.__GmnCustomDestroyJoint__,argument0);

#define GmnJointSetCollisionState
// GMNewton 1.00
//
//Function:  Sets the if bodies connected by joint can collide with eachother
//Notes:  Use GmnCustomJointSetCollisionState for custom joints
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - state
//call GmnJointSetCollisionState(dJoint,state);
//return: 
return external_call(global.__GmnJointSetCollisionState__,argument0,argument1);

#define GmnCustomJointSetCollisionState
// GMNewton 1.00
//
//Function:  Sets if bodies connected by joint can collide with eachother
//Notes:  Use only for joints identified as "custom"
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - state
//call GmnCustomJointSetCollisionState(dJoint,state);
//return: 
return external_call(global.__GmnCustomJointSetCollisionState__,argument0,argument1);

#define GmnConstraintCreateHinge
// GMNewton 1.00
//
//Function:  Creates a basic hinge
//Notes:  Reccomended to use the CustomHinge instead as it supports more options such as breaking
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - xOrig
//   Argument2 - yOrig
//   Argument3 - zOrig
//   Argument4 - xPin
//   Argument5 - yPin
//   Argument6 - zPin
//   Argument7 - dChildBody
//   Argument8 - dParentBody
//call GmnConstraintCreateHinge(dWorld,xOrig,yOrig,zOrig,xPin,yPin,zPin,dChildBody,dParentBody);
//return: 
return external_call(global.__GmnConstraintCreateHinge__,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7,argument8);

#define GmnCreateCustomHinge
// GMNewton 1.00
//
//Function:  Creates a custom hinge joint
//Notes:  position and pin.  pin is a vector around which hinge rotation is allowed
//
//Arguments:
//   Argument0 - xOrig
//   Argument1 - yOrig
//   Argument2 - zOrig
//   Argument3 - xPin
//   Argument4 - yPin
//   Argument5 - zPin
//   Argument6 - dChildBody
//   Argument7 - dParentBody
//call GmnCreateCustomHinge(xOrig,yOrig,zOrig,xPin,yPin,zPin,dChildBody,dParentBody);
//return: 
return external_call(global.__GmnCreateCustomHinge__,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7);

#define GmnCustomHingeSetLimits
// GMNewton 1.00
//
//Function:  Sets the limits of a hinge joint
//Notes:  in degrees, the min and max angle
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - min
//   Argument2 - max
//call GmnCustomHingeSetLimits(dHinge,min,max);
//return: 
return external_call(global.__GmnCustomHingeSetLimits__,argument0,argument1,argument2);

#define GmnCustomHingeGetForceMagnitude
// GMNewton 1.00
//
//Function:  Gets the magnitude of force hinge is applying
//Notes:
//
//Arguments:
//   Argument0 - dHinge
//call GmnCustomHingeGetForceMagnitude(dHinge);
//return: 
return external_call(global.__GmnCustomHingeGetForceMagnitude__,argument0);

#define GmnCustomHingeGetTorqueMagnitude
// GMNewton 1.00
//
//Function:  Gets the magnitude of torque hinge is applying
//Notes:
//
//Arguments:
//   Argument0 - dHinge
//call GmnCustomHingeGetTorqueMagnitude(dHinge);
//return: 
return external_call(global.__GmnCustomHingeGetTorqueMagnitude__,argument0);

#define GmnCustomHingeSetSeverCallscript
// GMNewton 1.00
//
//Function:  Set the script to be called when joint is severed
//Notes:  must have initiated gmi for this to work
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - script
//call GmnCustomHingeSetSeverCallscript(dHinge,script);
//return: 
return external_call(global.__GmnCustomHingeSetSeverCallscript__,argument0,argument1);

#define GmnCustomHingeSetBreakCallscript
// GMNewton 1.00
//
//Function:  Sets the script called when joint brakes
//Notes:  gmi must be inited for this to work
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - script
//call GmnCustomHingeSetBreakCallscript(dHinge,script);
//return: 
return external_call(global.__GmnCustomHingeSetBreakCallscript__,argument0,argument1);

#define GmnCustomHingeSetSeverTolerance
// GMNewton 1.00
//
//Function:  Sets the force at which joint severs
//Notes:
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - forceTolerance
//   Argument2 - torqueTolerance
//call GmnCustomHingeSetSeverTolerance(dHinge,forceTolerance,torqueTolerance);
//return: 
return external_call(global.__GmnCustomHingeSetSeverTolerance__,argument0,argument1,argument2);

#define GmnCustomHingeSetSeverable
// GMNewton 1.00
//
//Function:  Sets if joint is severable
//Notes:
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - severable
//call GmnCustomHingeSetSeverable(dHinge,severable);
//return: 
return external_call(global.__GmnCustomHingeSetSeverable__,argument0,argument1);

#define GmnCustomHingeSetLimitsBreakTolerance
// GMNewton 1.00
//
//Function:  Sets force needed to break joint
//Notes:
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - tolerance
//call GmnCustomHingeSetLimitsBreakTolerance(dHinge,tolerance);
//return: 
return external_call(global.__GmnCustomHingeSetLimitsBreakTolerance__,argument0,argument1);

#define GmnCustomHingeSetLimitsBreakable
// GMNewton 1.00
//
//Function:  Sets if joint is breakable
//Notes:
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//   Argument1 - breakable
//call GmnCustomHingeSetLimitsBreakable(dHinge,breakable);
//return: 
return external_call(global.__GmnCustomHingeSetLimitsBreakable__,argument0,argument1);

#define GmnCustomHingeGetLimitsBreakTolerance
// GMNewton 1.00
//
//Function:  Gets force required to break joint
//Notes:
//        breaking is the removal of limits
//        severing is the removal of joint
//
//Arguments:
//   Argument0 - dHinge
//call GmnCustomHingeGetLimitsBreakTolerance(dHinge);
//return: 
return external_call(global.__GmnCustomHingeGetLimitsBreakTolerance__,argument0);

#define GmnCreateCustomKinematicController
// GMNewton 1.00
//
//Function:  Creates a kinematic controller and ataches to body
//Notes:  Used to control objects directly by position and rotation while still influenced by physics
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - xp
//   Argument2 - yp
//   Argument3 - zp
//call GmnCreateCustomKinematicController(dBody,xp,yp,zp);
//return: 
return external_call(global.__GmnCreateCustomKinematicController__,argument0,argument1,argument2,argument3);

#define GmnCustomKinematicControllerSetMaxAngularFriction
// GMNewton 1.00
//
//Function:  Sets the amount of force required to overcome rotational constraint of joint
//Notes:  "alpha" is the amount of force required to overpower joint
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - alpha
//call GmnCustomKinematicControllerSetMaxAngularFriction(dJoint,alpha);
//return: 
return external_call(global.__GmnCustomKinematicControllerSetMaxAngularFriction__,argument0,argument1);

#define GmnCustomKinematicControllerSetMaxLinearFriction
// GMNewton 1.00
//
//Function:  Sets the amount of force required to overcome position constraint of joint
//Notes:  "alpha" is strength of control, or amount of outside force required to overcome the control
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - alpha
//call GmnCustomKinematicControllerSetMaxLinearFriction(dJoint,alpha);
//return: 
return external_call(global.__GmnCustomKinematicControllerSetMaxLinearFriction__,argument0,argument1);

#define GmnCustomKinematicControllerSetPickMode
// GMNewton 1.00
//
//Function:  Toggles "pickmode" for kinematic joint
//Notes:
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - mode
//call GmnCustomKinematicControllerSetPickMode(dJoint,mode);
//return: 
return external_call(global.__GmnCustomKinematicControllerSetPickMode__,argument0,argument1);

#define GmnCustomKinematicControllerSetTargetPosit
// GMNewton 1.00
//
//Function:  Sets target position of kinematic joint
//Notes:
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - xp
//   Argument2 - yp
//   Argument3 - zp
//call GmnCustomKinematicControllerSetTargetPosit(dJoint,xp,yp,zp);
//return: 
return external_call(global.__GmnCustomKinematicControllerSetTargetPosit__,argument0,argument1,argument2,argument3);

#define GmnCustomKinematicControllerSetTargetRotation
// GMNewton 1.00
//
//Function:  Sets target rotation of kinematic joint.
//Notes:  I don't recall if this takes radians or degrees....  Experiment for now and will eventually take degrees for sure
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - xr
//   Argument2 - yr
//   Argument3 - zr
//call GmnCustomKinematicControllerSetTargetRotation(dJoint,xr,yr,zr);
//return: 
return external_call(global.__GmnCustomKinematicControllerSetTargetRotation__,argument0,argument1,argument2,argument3);

#define GmnCreateCustomPlayerController
// GMNewton 1.00
//
//Function:  Creates a player controller joint
//Notes:  Stair is the height a player can step up.  It is 0 - 1 and is percentage of player height
//        Padding is padding around player
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - dStair
//   Argument2 - dPadding
//call GmnCreateCustomPlayerController(dBody,dStair,dPadding);
//return: 
return external_call(global.__GmnCreateCustomPlayerController__,argument0,argument1,argument2);

#define GmnCustomPlayerControllerSetMaxSlope
// GMNewton 1.00
//
//Function:  Sets max slope player controller can climb
//Notes: in degrees
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - dSlope
//call GmnCustomPlayerControllerSetMaxSlope(dJoint,dSlope);
//return: 
return external_call(global.__GmnCustomPlayerControllerSetMaxSlope__,argument0,argument1);

#define GmnCustomPlayerControllerSetVelocity
// GMNewton 1.00
//
//Function:  Sets velocity of player controller for next step.
//Notes:
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - dVelocity - forward velocity
//   Argument2 - dStrafeVelocity - sideways velocity
//   Argument3 - dHeadinAngle - direction in degrees
//call GmnCustomPlayerControllerSetVelocity(dJoint,dVelocity,dStrafeVelocity,dHeadinAngle);
//return: 
return external_call(global.__GmnCustomPlayerControllerSetVelocity__,argument0,argument1,argument2,argument3);

#define GmnCreateCustomRigid
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - xOrig
//   Argument1 - yOrig
//   Argument2 - zOrig
//   Argument3 - dChildBody
//   Argument4 - dParentBody
//call GmnCreateCustomRigid(xOrig,yOrig,zOrig,dChildBody,dParentBody);
//return: 
return external_call(global.__GmnCreateCustomRigid__,argument0,argument1,argument2,argument3,argument4);

#define GmnCustomRigidGetForceMagnitude
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - dRigid
//call GmnCustomRigidGetForceMagnitude(dRigid);
//return: 
return external_call(global.__GmnCustomRigidGetForceMagnitude__,argument0);

#define GmnCustomRigidGetTorqueMagnitude
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - dRigid
//call GmnCustomRigidGetTorqueMagnitude(dRigid);
//return: 
return external_call(global.__GmnCustomRigidGetTorqueMagnitude__,argument0);

#define GmnCustomRigidSetSeverCallscript
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - dRigid
//   Argument1 - script
//call GmnCustomRigidSetSeverCallscript(dRigid,script);
//return: 
return external_call(global.__GmnCustomRigidSetSeverCallscript__,argument0,argument1);

#define GmnCustomRigidSetSeverTolerance
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - dRigid
//   Argument1 - forceTolerance
//   Argument2 - torqueTolerance
//call GmnCustomRigidSetSeverTolerance(dRigid,forceTolerance,torqueTolerance);
//return: 
return external_call(global.__GmnCustomRigidSetSeverTolerance__,argument0,argument1,argument2);

#define GmnCustomRigidSetSeverable
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - dRigid
//   Argument1 - severable
//call GmnCustomRigidSetSeverable(dRigid,severable);
//return: 
return external_call(global.__GmnCustomRigidSetSeverable__,argument0,argument1);

#define GmnCreateCustomSlider
// GMNewton 1.00
//
//Function:  Creates a slider joint
//Notes:  Allows body to slide along pin without rotating
//        (Similar to motion of a drawer in a desk)
//
//Arguments:
//   Argument0 - xOrig
//   Argument1 - yOrig
//   Argument2 - zOrig
//   Argument3 - xPin
//   Argument4 - yPin
//   Argument5 - zPin
//   Argument6 - dChildBody
//   Argument7 - dParentBody
//call GmnCreateCustomSlider(xOrig,yOrig,zOrig,xPin,yPin,zPin,dChildBody,dParentBody);
//return: 
return external_call(global.__GmnCreateCustomSlider__,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7);

#define GmnSliderEnableLimits
// GMNewton 1.00
//
//Function:  Enables/disables limits on a slider joint
//Notes:
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - enabled
//call GmnSliderEnableLimits(dJoint,enabled);
//return: 
return external_call(global.__GmnSliderEnableLimits__,argument0,argument1);

#define GmnSliderSetLimits
// GMNewton 1.00
//
//Function:  Sets the limits of a slider joint
//Notes:
//
//Arguments:
//   Argument0 - dJoint
//   Argument1 - minDist
//   Argument2 - maxDist
//call GmnSliderSetLimits(dJoint,minDist,maxDist);
//return: 
return external_call(global.__GmnSliderSetLimits__,argument0,argument1,argument2);

#define GmnConstraintCreateUpVector
// GMNewton 1.00
//
//Function:  Creates an up-vector constraint.  This limits rotation to around pin
//Notes:  xUp, yUp, and zUp construct a 3d vector representing pin that body may pivot about
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - xUp
//   Argument2 - yUp
//   Argument3 - zUp
//   Argument4 - dBody
//call GmnConstraintCreateUpVector(dWorld,xUp,yUp,zUp,dBody);
//return: 
return external_call(global.__GmnConstraintCreateUpVector__,argument0,argument1,argument2,argument3,argument4);

#define GmnCustomConstraintCreateDryRollingFriction
// GMNewton 1.00
//
//Function:  Creates a dry rolling friction joint
//Notes:  Simulates friction so rolling spheres come to halt eventually.
//        Because of the nature of mathematical approximation of a spherical object, only one point of contact generates friction
//          This joint simulates the slight flattening at bottom of a rolling sphere that adds friction
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - radius
//   Argument2 - friction
//call GmnCustomConstraintCreateDryRollingFriction(dBody,radius,friction);
//return: 
return external_call(global.__GmnCustomConstraintCreateDryRollingFriction__,argument0,argument1,argument2);

#define createBuoyancyDefine
// GMNewton 1.00
//
//Function:  Defines properties of buoyancy to apply to a buoyancy field
//Notes:
//
//Arguments:
//   Argument0 - fluidDensity
//   Argument1 - fluidLinearViscosity
//   Argument2 - fluidAngularViscosity
//   Argument3 - gravityX
//   Argument4 - gravityY
//   Argument5 - gravityZ
//call createBuoyancyDefine(fluidDensity,fluidLinearViscosity,fluidAngularViscosity,gravityX,gravityY,gravityZ);
//return: 
return external_call(global.__createBuoyancyDefine__,argument0,argument1,argument2,argument3,argument4,argument5);

#define GmnMaterialSetBuoyancyCallback
// GMNewton 1.00
//
//Function:  Sets interactions between to materials to be buoyant
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - mat0
//   Argument2 - mat1
//   Argument3 - buoyancyDefine
//   Argument4 - precise
//call GmnMaterialSetBuoyancyCallback(dWorld,mat0,mat1,buoyancyDefine,precise);
//return: 
return external_call(global.__GmnMaterialSetBuoyancyCallback__,argument0,argument1,argument2,argument3,argument4);

#define GmnMaterialGetDefaultGroupID
// GMNewton 1.00
//
//Function:  Gets the id of material assigned to objects by default
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//call GmnMaterialGetDefaultGroupID(dWorld);
//return: 
return external_call(global.__GmnMaterialGetDefaultGroupID__,argument0);

#define GmnMaterialCreateGroupId
// GMNewton 1.00
//
//Function:  Creates a new material type and returns id
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//call GmnMaterialCreateGroupId(dWorld);
//return: 
return external_call(global.__GmnMaterialCreateGroupId__,argument0);

#define GmnMaterialDestroyAllGroupID
// GMNewton 1.00
//
//Function:  Destroys all materials in world
//Notes:
//        This function removes all groups ID from the Newton world
//        It is useful when you wish to reset the newton world completely to create a new simulation.
//        Only call after there are no more bodies in world
//
//Arguments:
//   Argument0 - dWorld
//call GmnMaterialDestroyAllGroupID(dWorld);
//return: 
return external_call(global.__GmnMaterialDestroyAllGroupID__,argument0);

#define GmnMaterialSetDefaultCollidable
// GMNewton 1.00
//
//Function:  Enables/disable collision between two material types
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - id0
//   Argument2 - id1
//   Argument3 - state
//call GmnMaterialSetDefaultCollidable(dWorld,id0,id1,state);
//return: 
return external_call(global.__GmnMaterialSetDefaultCollidable__,argument0,argument1,argument2,argument3);

#define GmnMaterialSetContinuousCollisionMode
// GMNewton 1.00
//
//Function:  Enables/disables CCD between material types
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - id0
//   Argument2 - id1
//   Argument3 - state
//call GmnMaterialSetContinuousCollisionMode(dWorld,id0,id1,state);
//return: 
return external_call(global.__GmnMaterialSetContinuousCollisionMode__,argument0,argument1,argument2,argument3);

#define GmnMaterialSetDefaultFriction
// GMNewton 1.00
//
//Function: Sets friction between material types
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - id0
//   Argument2 - id1
//   Argument3 - coesta
//   Argument4 - coedyn
//call GmnMaterialSetDefaultFriction(dWorld,id0,id1,coesta,coedyn);
//return: 
return external_call(global.__GmnMaterialSetDefaultFriction__,argument0,argument1,argument2,argument3,argument4);

#define GmnMaterialSetDefaultElasticity
// GMNewton 1.00
//
//Function:  Sets elasticity between material types
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - id0
//   Argument2 - id1
//   Argument3 - elasticCoef
//call GmnMaterialSetDefaultElasticity(dWorld,id0,id1,elasticCoef);
//return: 
return external_call(global.__GmnMaterialSetDefaultElasticity__,argument0,argument1,argument2,argument3);

#define GmnMaterialSetDefaultSoftness
// GMNewton 1.00
//
//Function:  Sets softness between material types
//Notes:
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - id0
//   Argument2 - id1
//   Argument3 - softnessCoef
//call GmnMaterialSetDefaultSoftness(dWorld,id0,id1,softnessCoef);
//return: 
return external_call(global.__GmnMaterialSetDefaultSoftness__,argument0,argument1,argument2,argument3);

#define GmnMaterialSetCollisionCallback
// GMNewton 1.00
//
//Function:  Sets material type interaction to store collision information
//Notes: Must enable this to catch collision events
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - mat0
//   Argument2 - mat1
//call GmnMaterialSetCollisionCallback(dWorld,mat0,mat1);
//return: 
return external_call(global.__GmnMaterialSetCollisionCallback__,argument0,argument1,argument2);

#define GmnMaterialSetResponseType
// GMNewton 1.00
//
//Function:  Sets response type between two materials
//Notes:  0 - normal
//        2 - ignore
//        Actually, just disregard this function.  It's not much use
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - mat0
//   Argument2 - mat1
//   Argument3 - action
//call GmnMaterialSetResponseType(dWorld,mat0,mat1,action);
//return: 
return external_call(global.__GmnMaterialSetResponseType__,argument0,argument1,argument2,argument3);

