#ifndef __GMB_TRIMESH_SHAPE__
#define __GMB_TRIMESH_SHAPE__

#include "btBulletDynamicsCommon.h"
#include "btGImpactShape.h"

class gmbIndexedTriangleMesh : public btTriangleMesh
{
/*	bool use32bitindices,use4componentvertices;

	btAlignedObjectArray<btScalar> m_3componentVertices;
	btAlignedObjectArray<btVector3> m_4componentVertices;

	btAlignedObjectArray<unsigned short> m_16bitIndices;
	btAlignedObjectArray<unsigned int> m_32bitIndices;*/
public:
	gmbIndexedTriangleMesh (bool use32bitIndices=true,bool use4componentVertices=true):btTriangleMesh(use32bitIndices,use4componentVertices)
	{;}
	~gmbIndexedTriangleMesh(){;}
	void setNumTris(int numTris)
	{
		m_indexedMeshes[0].m_numTriangles=numTris;
	}
	/*gmbIndexedTriangleMesh(bool use32bitIndices,bool use4componentVertices)
	{
		use32bitindices=use32bitIndices;
		use4componentvertices=use4componentVertices;

		btIndexedMesh meshIndex;

		if(use32bitindices)
		{
			meshIndex.m_indexType=PHY_INTEGER;
			meshIndex.m_triangleIndexBase=(unsigned char*)&m_32bitIndices[0];
			meshIndex.m_triangleIndexStride=3*sizeof(int);
		}
		else
		{
			meshIndex.m_indexType=PHY_SHORT;
			meshIndex.m_triangleIndexBase=(unsigned char*)&m_16bitIndices[0];
			meshIndex.m_triangleIndexStride=3*sizeof(short);
		}

		if(use4componentvertices)
		{
			meshIndex.m_vertexBase=(unsigned char*)&m_4componentVertices[0];
			meshIndex.m_vertexStride=sizeof(btVector3);
		}
		else
		{
			meshIndex.m_vertexBase=(unsigned char*)&m_3componentVertices[0];
			meshIndex.m_vertexStride=3*sizeof(btScalar);
		}
		m_indexedMeshes.push_back(meshIndex);
	}

	virtual ~gmbIndexedTriangleMesh()
	{;}

	virtual void preallocateVertices(int numverts)
	{
		if(use4componentvertices)
			m_4componentVertices.reserve(numverts);
		else
			m_3componentVertices.reserve(numverts);
	}
	virtual void preallocateIndices(int numindices)
	{
		if(use32bitindices)
			m_32bitIndices.reserve(numindices);
		else
			m_16bitIndices.reserve(numindices);
	}

	virtual void addVertex3(btVector3 &vert)
	{
		m_3componentVertices.push_back(vert.getX());
		m_3componentVertices.push_back(vert.getY());
		m_3componentVertices.push_back(vert.getZ());
		m_indexedMeshes[0].m_numVertices=m_3componentVertices.size();
		m_indexedMeshes[0].m_vertexBase=(unsigned char*)&m_3componentVertices[0];
		m_indexedMeshes[0].m_vertexStride=3*sizeof(btScalar);
	}
	virtual void addVertex4(btVector3 &vert)
	{
		m_4componentVertices.push_back(vert);
		m_indexedMeshes[0].m_numVertices=m_4componentVertices.size();
		m_indexedMeshes[0].m_vertexBase=(unsigned char*)&m_4componentVertices[0];
		m_indexedMeshes[0].m_vertexStride=sizeof(btVector3);
	}

	virtual void addIndex16(unsigned short ind)
	{
		m_16bitIndices.push_back(ind);
		m_indexedMeshes[0].m_indexType=PHY_SHORT;
		m_indexedMeshes[0].m_triangleIndexBase=(unsigned char*)&m_16bitIndices[0];
		m_indexedMeshes[0].m_triangleIndexStride=3*sizeof(short);
		m_indexedMeshes[0].m_numTriangles=m_16bitIndices.size()/3;
	}
	virtual void addIndex32(unsigned int ind)
	{
		m_32bitIndices.push_back(ind);
		m_indexedMeshes[0].m_indexType=PHY_INTEGER;
		m_indexedMeshes[0].m_triangleIndexBase=(unsigned char*)&m_32bitIndices[0];
		m_indexedMeshes[0].m_triangleIndexStride=3*sizeof(int);
		m_indexedMeshes[0].m_numTriangles=m_16bitIndices.size()/3;
	}*/


};

class gmbConvexTriangleMeshShape : public btConvexTriangleMeshShape
{
	public:
	gmbConvexTriangleMeshShape(btStridingMeshInterface* meshInterface, bool calcAabb = true):btConvexTriangleMeshShape(meshInterface,calcAabb)
	{
	}
	virtual ~gmbConvexTriangleMeshShape(void)
	{
		delete this->getMeshInterface();
	}
};

class gmbBvhTriangleMeshShape : public btBvhTriangleMeshShape
{
	public:
	gmbBvhTriangleMeshShape(btStridingMeshInterface* meshInterface, bool useQuantizedAabbCompression, bool buildBvh = true):btBvhTriangleMeshShape(meshInterface,useQuantizedAabbCompression,buildBvh)
	{
	}
	virtual ~gmbBvhTriangleMeshShape(void)
	{
		delete this->getMeshInterface();
	}
};

class gmbGImpactMeshShape : public btGImpactMeshShape
{
	public:
	gmbGImpactMeshShape(btStridingMeshInterface * meshInterface):btGImpactMeshShape(meshInterface)
	{

	}
	virtual ~gmbGImpactMeshShape(void)
	{
		delete this->getMeshPart(0)->getTrimeshPrimitiveManager()->m_meshInterface;
	}
};

/*class gmbModelExMeshInterface : public btTriangleIndexVertexArray
{
	#define POINTFROMMODEL(___m,___i) (facepoint*)((( ___m) + (sizeof(facepoint)*___i)+sizeof(int)))
	#define POINTMODELSIZE(___m) *((int*) ___m)

	struct vector3d
	{
		double x;
		double y;
		double z;
	};
	struct vector2d
	{
		double x;
		double y;
	};
	struct facepoint 
	{
		vector3d v;
		vector2d uv;
		vector3d vn;

		double alpha;
		double color;
	};
	unsigned char* m_indices;
	gmbModelExMeshInterface(void* mesh)
	{
		btTriangleIndexVertexArray((POINTMODELSIZE(mesh)/3),m_indices,3,POINTMODELSIZE(mesh),POINTFROMMODEL(mesh,0),);
	}
	~gmbModelExMeshInterface()
	{
		if(m_indices)
			delete [] m_indices;
	}
}*/
#endif //__GMB_TRIMESH_SHAPE__