#ifndef __GMB_SHAPE_EXPORTS__
#define __GMB_SHAPE_EXPORTS__

#include "gmbCommon.h"
#include "gmbShape.h"
#include "gmbIndexedList.h"

extern gmbIndexedList<gmbShape*> gmbGlobal_ShapeList;

GM_export GM_Real GMBULLET_CreateBoxShape(GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_CreateCylinderShape(GM_Real x,GM_Real y,GM_Real z,GM_Real dir);
GM_export GM_Real GMBULLET_CreateConeShape(GM_Real rad,GM_Real height,GM_Real dir);
GM_export GM_Real GMBULLET_CreateSphereShape(GM_Real rad);
GM_export GM_Real GMBULLET_CreateCompoundShape();
GM_export GM_Real GMBULLET_AddChildToCompoundShape(GM_Real IDparent,GM_Real IDchild,GM_Real x,GM_Real y,GM_Real z,GM_Real r1,GM_Real r2,GM_Real r3);
GM_export GM_Real GMBULLET_GetNumCompoundChildShapes(GM_Real ID);
GM_export GM_Real GMBULLET_GetCompoundChildShape(GM_Real ID,GM_Real index);
GM_export GM_Real GMBULLET_RemoveCompoundChildShape(GM_Real ID,GM_Real index);
GM_export GM_Real GMBULLET_StartTriMeshShape();
GM_export GM_Real GMBULLET_AddTriangle(GM_Real x1,GM_Real y1,GM_Real z1,GM_Real x2,GM_Real y2,GM_Real z2,GM_Real x3,GM_Real y3,GM_Real z3);
GM_export GM_Real GMBULLET_FinishTriMeshShape(GM_Real convextype);
GM_export GM_Real GMBULLET_CreateTriMeshShapeFromQueue(GM_Real queueID,GM_Real convextype,GM_Real makeIndexed);
GM_export GM_Real GMBULLET_CreateIndexedTriMeshShapeFromQueue(GM_Real vertQueue,GM_Real indexQueue,GM_Real convextype);
GM_export GM_Real GMBULLET_CreateTriMeshShapeFrom3DSFile(GM_String filename,GM_Real convextype);
GM_export GM_Real GMBULLET_CreateTriMeshShapeFrom3DSFileList(GM_Real listID,GM_Real convextype);
GM_export GM_Real GMBULLET_CreateTriMeshShapeFromModelEx(GM_Real model,GM_Real convextype,GM_Real makeIndexed);
GM_export GM_Real GMBULLET_CreateShapesFromBSP(GM_String filename,GM_Real scaling,GM_Real listID);
GM_export GM_Real GMBULLET_DeleteShape(GM_Real ID);
GM_export GM_Real GMBULLET_DeleteShapesFromStack(GM_Real stackID);
GM_export GM_Real GMBULLET_DeleteShapesFromList(GM_Real listID);
GM_export GM_Real GMBULLET_DeleteAllShapes();
GM_export GM_Real GMBULLET_SetShapeScaling(GM_Real ID,GM_Real x,GM_Real y, GM_Real z);
GM_export GM_Real GMBULLET_CreateUniformScalingShape(GM_Real ID,GM_Real scaling);
GM_export GM_Real GMBULLET_AddToMultiSphere(GM_Real x,GM_Real y,GM_Real z,GM_Real radius);
GM_export GM_Real GMBULLET_FinishMultiSphereShape(GM_Real x,GM_Real y,GM_Real z);

#endif //__GMB_SHAPE_EXPORTS__