#include "gmbShapeExports.h"

#include "btBulletDynamicsCommon.h"
#include "gmbCompoundShape.h"
#include "gmbUniformScalingShape.h"
#include "gmbTrimeshShape.h"
#include "gmbBSPLoader.h"
#include "gmb3DSMeshLoader.h"
#include "GMFunctions.h"

#include <string>

gmbIndexedList<gmbShape*> gmbGlobal_ShapeList;

btAlignedObjectArray<btScalar> gmbLocalGlobal_MultiSphereRadii;
btAlignedObjectArray<btVector3> gmbLocalGlobal_MultiSpherePositions;
btTriangleMesh* gmbLocalGlobal_TempTriMesh=NULL;

gmbShape* makeTriMeshgmbShape(btStridingMeshInterface* tmesh,int convextype)
{
    btCollisionShape* tshape;
    btGImpactMeshShape* tm;
    switch (convextype)
    {
    case 1: //Static concave
        tshape=new gmbBvhTriangleMeshShape(tmesh,0); //Maby set to 1 ???
        break;
    case 2: //Moving concave
        tm=new gmbGImpactMeshShape(tmesh);
        tm->updateBound();
        tshape=tm;
        break;
    default: //Convex
        tshape=new gmbConvexTriangleMeshShape(tmesh);
        break;
    }
    return new gmbShape(tshape);
}

GM_export GM_Real GMBULLET_CreateBoxShape(GM_Real x,GM_Real y,GM_Real z)
{
    btCollisionShape* tColShape=new btBoxShape(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
    gmbShape* tShape=new gmbShape(tColShape);
    return gmbGlobal_ShapeList.AddInstance(tShape);
}
GM_export GM_Real GMBULLET_CreateCylinderShape(GM_Real x,GM_Real y,GM_Real z,GM_Real dir)
{
    btCollisionShape* tColShape;
    switch (int(dir))
    {
    case 0:
        tColShape=new btCylinderShapeX(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
        break;
    case 2:
        tColShape=new btCylinderShapeZ(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
        break;
    case 1:
    default:
        tColShape=new btCylinderShape(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
        break;

    }
    gmbShape* tShape=new gmbShape(tColShape);
    return gmbGlobal_ShapeList.AddInstance(tShape);
}
GM_export GM_Real GMBULLET_CreateConeShape(GM_Real rad,GM_Real height,GM_Real dir)
{
    btCollisionShape* tColShape;
    switch (int(dir))
    {
    case 0:
        tColShape=new btConeShape(btScalar(rad)*invDistanceScale,btScalar(height)*invDistanceScale);
        break;
    case 2:
        tColShape=new btConeShape(btScalar(rad)*invDistanceScale,btScalar(height)*invDistanceScale);
        break;
    case 1:
    default:
        tColShape=new btConeShape(btScalar(rad)*invDistanceScale,btScalar(height)*invDistanceScale);
        break;

    }
    gmbShape* tShape=new gmbShape(tColShape);
    return gmbGlobal_ShapeList.AddInstance(tShape);
}
GM_export GM_Real GMBULLET_CreateSphereShape(GM_Real rad)
{
    btCollisionShape* tColShape=new btSphereShape(btScalar(rad)*invDistanceScale);
    gmbShape* tShape=new gmbShape(tColShape);
    return gmbGlobal_ShapeList.AddInstance(tShape);
}

GM_export GM_Real GMBULLET_CreateCompoundShape()
{
    btCollisionShape* tColShape=new gmbCompoundShape();
    gmbShape* tShape=new gmbShape(tColShape);
    return gmbGlobal_ShapeList.AddInstance(tShape);
}
GM_export GM_Real GMBULLET_AddChildToCompoundShape(GM_Real IDparent,GM_Real IDchild,GM_Real x,GM_Real y,GM_Real z,GM_Real r1,GM_Real r2,GM_Real r3)
{
    gmbShape* tChildShape=gmbGlobal_ShapeList.GetInstance(unsigned int(IDchild));
    gmbShape* tParentShape=gmbGlobal_ShapeList.GetInstance(unsigned int(IDparent));
    if (!tChildShape||!tParentShape)
        return -1;
    if (tParentShape->getShape()->getShapeType()!=COMPOUND_SHAPE_PROXYTYPE)
        return -1;
    gmbCompoundShape* tComShape=dynamic_cast<gmbCompoundShape*>(tParentShape->getShape());
    if (!tComShape)
        return -1;

    btTransform tTransform;
    tTransform.setIdentity();
    tTransform.setBasis(RotationWithFlags(btScalar(r1),btScalar(r2),btScalar(r3)));
    tTransform.setOrigin(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);

    tComShape->addGmbChildShape(tTransform,tChildShape);

    return 0;
}

GM_export GM_Real GMBULLET_GetNumCompoundChildShapes(GM_Real ID)
{
    gmbShape* tShape=gmbGlobal_ShapeList.GetInstance(unsigned int(ID));
    if (!tShape)
        return -1;

    if (tShape->getShape()->getShapeType()!=COMPOUND_SHAPE_PROXYTYPE)
        return -1;
    gmbCompoundShape* tComShape=dynamic_cast<gmbCompoundShape*>(tShape->getShape());
    if (!tComShape)
        return -1;
    return tComShape->getNumChildShapes();
}

GM_export GM_Real GMBULLET_GetCompoundChildShape(GM_Real ID,GM_Real index)
{
    gmbShape* tShape=gmbGlobal_ShapeList.GetInstance(unsigned int(ID));
    if (!tShape||index<0)
        return -1;

    if (tShape->getShape()->getShapeType()!=COMPOUND_SHAPE_PROXYTYPE)
        return -1;
    gmbCompoundShape* tComShape=dynamic_cast<gmbCompoundShape*>(tShape->getShape());
    if (!tComShape)
        return -1;
    if (index>=tComShape->getNumChildShapes())
        return -1;
    gmbShape* tgmbShape = tComShape->getGmbChildShape(unsigned int(index));
    return (GM_Real)gmbGlobal_ShapeList.m_indexArray.findLinearSearch(tgmbShape);
}

GM_export GM_Real GMBULLET_RemoveCompoundChildShape(GM_Real ID,GM_Real index)
{
    gmbShape* tShape=gmbGlobal_ShapeList.GetInstance(unsigned int(ID));
    if (!tShape||index<0)
        return -1;

    if (tShape->getShape()->getShapeType()!=COMPOUND_SHAPE_PROXYTYPE)
        return -1;
    gmbCompoundShape* tComShape=dynamic_cast<gmbCompoundShape*>(tShape->getShape());
    if (!tComShape)
        return -1;
    if (index>=tComShape->getNumChildShapes())
        return -1;
    tComShape->removeGmbChildShapeByIndex(unsigned int(index));
    return 0;
}

GM_export GM_Real GMBULLET_StartTriMeshShape()
{
    if (gmbLocalGlobal_TempTriMesh)
        return -1;
    gmbLocalGlobal_TempTriMesh=new btTriangleMesh(false,false);
    return 0;
}
GM_export GM_Real GMBULLET_AddTriangle(GM_Real x1,GM_Real y1,GM_Real z1,GM_Real x2,GM_Real y2,GM_Real z2,GM_Real x3,GM_Real y3,GM_Real z3)
{
    if (!gmbLocalGlobal_TempTriMesh)
        return -1;
    gmbLocalGlobal_TempTriMesh->addTriangle(btVector3(float(x1),float(y1),float(z1)),btVector3(float(x2),float(y2),float(z2)),btVector3(float(x3),float(y3),float(z3)));
    return 0;
}
GM_export GM_Real GMBULLET_FinishTriMeshShape(GM_Real convextype)
{
    if (!gmbLocalGlobal_TempTriMesh)
        return -1;
    gmbShape* tShape=makeTriMeshgmbShape(gmbLocalGlobal_TempTriMesh,int(convextype));
    gmbLocalGlobal_TempTriMesh=NULL;
    return gmbGlobal_ShapeList.AddInstance(tShape);
}

GM_export GM_Real GMBULLET_CreateTriMeshShapeFromQueue(GM_Real queueID,GM_Real convextype,GM_Real makeIndexed)
{
    btTriangleMesh* ttm=new btTriangleMesh(true,false);
    while (ds_queue_size(queueID)>=9)
    {
        btVector3 tv1,tv2,tv3;
        tv1.setX((float)ds_queue_dequeue(queueID));
        tv1.setY((float)ds_queue_dequeue(queueID));
        tv1.setZ((float)ds_queue_dequeue(queueID));
        tv2.setX((float)ds_queue_dequeue(queueID));
        tv2.setY((float)ds_queue_dequeue(queueID));
        tv2.setZ((float)ds_queue_dequeue(queueID));
        tv3.setX((float)ds_queue_dequeue(queueID));
        tv3.setY((float)ds_queue_dequeue(queueID));
        tv3.setZ((float)ds_queue_dequeue(queueID));
        ttm->addTriangle(tv1,tv2,tv3,bool(makeIndexed));
    }
    return gmbGlobal_ShapeList.AddInstance(makeTriMeshgmbShape(ttm,int(convextype)));
}
GM_export GM_Real GMBULLET_CreateIndexedTriMeshShapeFromQueue(GM_Real vertQueue,GM_Real indexQueue,GM_Real convextype)
{
    gmbIndexedTriangleMesh* ttm=new gmbIndexedTriangleMesh(true,false);
    ttm->preallocateVertices(int(ds_queue_size(vertQueue)/3));
    ttm->preallocateIndices(int(ds_queue_size(indexQueue)));
    while (ds_queue_size(vertQueue)>=3)
    {
        btVector3 tv1;
        tv1.setX((float)ds_queue_dequeue(vertQueue));
        tv1.setY((float)ds_queue_dequeue(vertQueue));
        tv1.setZ((float)ds_queue_dequeue(vertQueue));
		ttm->findOrAddVertex(tv1,false);
    }
	ttm->setNumTris(ds_queue_size(indexQueue)/3);
    while (!ds_queue_empty(indexQueue))
    {
        ttm->addIndex(int(double(ds_queue_dequeue(indexQueue))));
    }

    return gmbGlobal_ShapeList.AddInstance(makeTriMeshgmbShape(ttm,int(convextype)));
}
GM_export GM_Real GMBULLET_CreateTriMeshShapeFrom3DSFile(const GM_String filename,GM_Real convextype)
{
	/*char tf[1000];
	memcpy(tf,filename,strlen(filename));
	tf[strlen(filename)]='\0';*/
	gmb3DSMeshLoader tml;

	if (tml.LoadFile(filename)==0 && tml.meshlist.size()>0)
	{
	   return (double)gmbGlobal_ShapeList.AddInstance(makeTriMeshgmbShape(tml.meshlist[0],int(convextype)));
	}
	else
	{
		return -1;
	}
}
GM_export GM_Real GMBULLET_CreateTriMeshShapeFrom3DSFileList(GM_Real listID,GM_Real convextype)
{
    for (int i=0;i<ds_list_size(listID);i++)
    {
        GMVariable tgv=ds_list_find_value(listID,i);
        if (tgv.isString())
        {
            gmb3DSMeshLoader tml;
            if (tml.LoadFile(tgv)==0)
            {
                for (int j=0;j<tml.meshlist.size();j++)
                {
                    ds_list_insert(listID,++i,(double)gmbGlobal_ShapeList.AddInstance(makeTriMeshgmbShape(tml.meshlist[j],
																										int(convextype))));
                }
            }
        }
    }
    return 0;
}
//--------------------
#define POINTFROMMODEL(___m,___i) (facepoint*)((((DWORD) ___m) + (sizeof(facepoint) * (DWORD) ___i) + sizeof(int)))
#define POINTMODELSIZE(___m) *((int*)(DWORD) ___m)
struct vector3d
{
	double x;
	double y;
	double z;
};
struct vector2d
{
	double x;
	double y;
};
struct facepoint 
{
	vector3d v;
	vector2d uv;
	vector3d vn;

	double alpha;
	double color;
};
GM_export GM_Real GMBULLET_CreateTriMeshShapeFromModelEx(GM_Real model,GM_Real convextype,GM_Real makeIndexed)
{
	if(model<=0)
	{
		return -1;
	}

    int size = int(POINTMODELSIZE(model))/3;
    if(size<=0) 
	{
		return -1;
	}

	btTriangleMesh* ttm=new btTriangleMesh(true,false);
	for(int i=0;i<size;i++)
	{
		facepoint *tfp1 = POINTFROMMODEL(model,(3*i));
		facepoint *tfp2 = POINTFROMMODEL(model,(3*i)+1);
		facepoint *tfp3 = POINTFROMMODEL(model,(3*i)+2);
		ttm->addTriangle(btVector3(float(tfp1->v.x),float(tfp1->v.y),float(tfp1->v.z)),
				btVector3(float(tfp2->v.x),float(tfp2->v.y),float(tfp2->v.z)),
				btVector3(float(tfp3->v.x),float(tfp3->v.y),float(tfp3->v.z)),bool(makeIndexed));
	}
    return gmbGlobal_ShapeList.AddInstance(makeTriMeshgmbShape(ttm,int(convextype)));
}
GM_export GM_Real GMBULLET_CreateShapesFromBSP(GM_String filename,GM_Real scaling,GM_Real listID)
{
	gmbBSPConverter tbspc;
	btAlignedObjectArray<unsigned int>* tshapeIDs=tbspc.LoadBSP(filename,float(scaling));
	for(int i=0;i<tshapeIDs->size();i++)
	{
		ds_list_add(listID,(*tshapeIDs)[i]);
	}
	delete tshapeIDs;
	return ds_list_size(listID);
}
GM_export GM_Real GMBULLET_DeleteShape(GM_Real ID)
{
    gmbGlobal_ShapeList.RemoveInstance(unsigned int(ID));
    return 0;
}
GM_export GM_Real GMBULLET_DeleteShapesFromStack(GM_Real stackID)
{
	while(!ds_stack_empty(stackID))
	{
		 gmbGlobal_ShapeList.RemoveInstance(unsigned int(ds_stack_pop(stackID)));
	}
	return 0;
}
GM_export GM_Real GMBULLET_DeleteShapesFromList(GM_Real listID)
{
	for(int i=0;i<ds_list_size(listID);i++)
	{
		 gmbGlobal_ShapeList.RemoveInstance(unsigned int(ds_list_find_value(listID,i)));
	}
	return 0;
}
GM_export GM_Real GMBULLET_DeleteAllShapes()
{
	gmbGlobal_ShapeList.Clear();
	return 0;
}
GM_export GM_Real GMBULLET_SetShapeScaling(GM_Real ID,GM_Real x,GM_Real y, GM_Real z)
{
    gmbShape* tShape=gmbGlobal_ShapeList.GetInstance(unsigned int(ID));
    if (!tShape)
        return -1;
    tShape->SetScaling(btVector3(btScalar(x),btScalar(y),btScalar(z)));
    return 0;
}
GM_export GM_Real GMBULLET_CreateUniformScalingShape(GM_Real ID,GM_Real scaling)
{
    gmbShape* tShape=gmbGlobal_ShapeList.GetInstance(unsigned int(ID));
    if (!tShape)
        return -1;
    if (tShape->getShape()->isConcave())
        return 0;
    btConvexShape* tConShape=reinterpret_cast<btConvexShape*>(tShape->getShape());
    btCollisionShape* tUShape=new gmbUniformScalingShape(tShape,tConShape,btScalar(scaling));
    return gmbGlobal_ShapeList.AddInstance(new gmbShape(tUShape));
}
GM_export GM_Real GMBULLET_AddToMultiSphere(GM_Real x,GM_Real y,GM_Real z,GM_Real radius)
{
    gmbLocalGlobal_MultiSphereRadii.push_back(btScalar(radius)*invDistanceScale);
    gmbLocalGlobal_MultiSpherePositions.push_back(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
    return 0;
}
GM_export GM_Real GMBULLET_FinishMultiSphereShape(GM_Real x,GM_Real y,GM_Real z)
{
    btCollisionShape* tColShape=new btMultiSphereShape(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale,&gmbLocalGlobal_MultiSpherePositions[0],&gmbLocalGlobal_MultiSphereRadii[0],gmbLocalGlobal_MultiSpherePositions.size());
    gmbLocalGlobal_MultiSphereRadii.clear();
    gmbLocalGlobal_MultiSpherePositions.clear();
    gmbShape* tShape=new gmbShape(tColShape);
    return gmbGlobal_ShapeList.AddInstance(tShape);
}
