#ifndef __GMB_RIGID_BODY_EXPORTS__
#define __GMB_RIGID_BODY_EXPORTS__

#include "gmbCommon.h"
#include "gmbIndexedList.h"
#include "gmbRigidBody.h"

extern gmbIndexedList<gmbRigidBody*> gmbGlobal_RigidBodies;

//Basic Body Functions 
GM_export GM_Real GMBULLET_AddRigidBody(GM_Real mass,GM_Real type,GM_Real shapeID,GM_Real x,GM_Real y,GM_Real z,GM_Real r1,GM_Real r2,GM_Real r3);
GM_export GM_Real GMBULLET_AddRigidBodiesFromList(GM_Real mass,GM_Real type,GM_Real shapeListID,GM_Real bodyListID,GM_Real gmID,GM_Real x,GM_Real y,GM_Real z,GM_Real r1,GM_Real r2,GM_Real r3);
GM_export GM_Real GMBULLET_DeleteRigidBody(GM_Real ID);
GM_export GM_Real GMBULLET_DeleteRigidBodiesFromStack(GM_Real stackID);
GM_export GM_Real GMBULLET_DeleteRigidBodiesFromList(GM_Real listID);
GM_export GM_Real GMBULLET_SetFriction(GM_Real ID,GM_Real friction);
GM_export GM_Real GMBULLET_SetAllFriction(GM_Real friction);
GM_export GM_Real GMBULLET_DisableDeactivation(GM_Real ID,GM_Real deactivate);
GM_export GM_Real GMBULLET_ActivateBody(GM_Real ID,GM_Real forceActivation);
GM_export GM_Real GMBULLET_SetCollisionGroupMask(GM_Real ID,GM_Real cGroup,GM_Real cMask);
GM_export GM_Real GMBULLET_AssociateBodyWithInstance(GM_Real ID,GM_Real Instance);
GM_export GM_Real GMBULLET_SetMass(GM_Real ID,GM_Real mass);
GM_export GM_Real GMBULLET_SetDeactivationThresholds(GM_Real ID,GM_Real lin,GM_Real ang);
GM_export GM_Real GMBULLET_SetDeactivationTime(GM_Real ID,GM_Real time);
GM_export GM_Real GMBULLET_SetHitFraction(GM_Real ID,GM_Real HitFraction);
GM_export GM_Real GMBULLET_SetDamping(GM_Real ID,GM_Real linDamping,GM_Real angDamping);
GM_export GM_Real GMBULLET_SetRestitution(GM_Real ID,GM_Real rest);
//Kinetmatic Body Functions
GM_export GM_Real GMBULLET_SetPosition(GM_Real ID,GM_Real x, GM_Real y, GM_Real z);
GM_export GM_Real GMBULLET_SetPositionX(GM_Real ID,GM_Real x);
GM_export GM_Real GMBULLET_SetPositionY(GM_Real ID,GM_Real y);
GM_export GM_Real GMBULLET_SetPositionZ(GM_Real ID,GM_Real z);
GM_export GM_Real GMBULLET_SetRelativePosition(GM_Real ID,GM_Real x, GM_Real y, GM_Real z);
GM_export GM_Real GMBULLET_ClearRotation(GM_Real ID);
GM_export GM_Real GMBULLET_AddArbitraryRotation(GM_Real ID,GM_Real x,GM_Real y,GM_Real z,GM_Real angle);
GM_export GM_Real GMBULLET_AddRotationWithFlags(GM_Real ID,GM_Real r1,GM_Real r2,GM_Real r3);
GM_export GM_Real GMBULLET_AddRotationQuaternion(GM_Real ID,GM_Real x,GM_Real y,GM_Real z,GM_Real w);
GM_export GM_Real GMBULLET_AddRotationSLERP(GM_Real ID,GM_Real x2,GM_Real y2,GM_Real z2,GM_Real w2,GM_Real amount);
GM_export GM_Real GMBULLET_AddRotationSLERPEuler(GM_Real ID,GM_Real rx2,GM_Real ry2,GM_Real rz2,GM_Real amount);
GM_export GM_Real GMBULLET_SetArbitraryRotation(GM_Real ID,GM_Real x,GM_Real y,GM_Real z,GM_Real angle);
GM_export GM_Real GMBULLET_SetRotationWithFlags(GM_Real ID,GM_Real r1,GM_Real r2,GM_Real r3);
GM_export GM_Real GMBULLET_SetRotationQuaternion(GM_Real ID,GM_Real x,GM_Real y,GM_Real z,GM_Real w);
GM_export GM_Real GMBULLET_SetRotationSLERP(GM_Real ID,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real w1,GM_Real x2,GM_Real y2,GM_Real z2,GM_Real w2,GM_Real amount);
GM_export GM_Real GMBULLET_SetRotationSLERPEuler(GM_Real ID,GM_Real rx1,GM_Real ry1,GM_Real rz1,GM_Real rx2,GM_Real ry2,GM_Real rz2,GM_Real amount);
GM_export GM_Real GMBULLET_SetBodyPosFromStack(GM_Real stackID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyRotWFFromStack(GM_Real stackID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyPosRotWFFromStack(GM_Real stackID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyPosFromList(GM_Real listID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyRotWFFromList(GM_Real listID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyPosRotWFFromList(GM_Real listID,GM_Real relative);
//Dynamic Body Functions
GM_export GM_Real GMBULLET_SetAngularFactor(GM_Real ID,GM_Real angFact);
GM_export GM_Real GMBULLET_SetAngularVelocityX(GM_Real ID,GM_Real x);
GM_export GM_Real GMBULLET_SetAngularVelocityY(GM_Real ID,GM_Real y);
GM_export GM_Real GMBULLET_SetAngularVelocityZ(GM_Real ID,GM_Real z);
GM_export GM_Real GMBULLET_SetAngularVelocity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_AddAngularVelocity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_ApplyTorqueImpulse(GM_Real ID,GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_SetLinearVelocityX(GM_Real ID,GM_Real x);
GM_export GM_Real GMBULLET_SetLinearVelocityY(GM_Real ID,GM_Real y);
GM_export GM_Real GMBULLET_SetLinearVelocityZ(GM_Real ID,GM_Real z);
GM_export GM_Real GMBULLET_SetLinearVelocity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_AddLinearVelocity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_ApplyCentralImpulse(GM_Real ID,GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_ApplyImpulse(GM_Real ID,GM_Real impulse_x,GM_Real impulse_y,GM_Real impulse_z,GM_Real posx,GM_Real posy,GM_Real posz,GM_Real relative);
GM_export GM_Real GMBULLET_ApplyImpulseFromSpeedAndMass(GM_Real ID,GM_Real velocity_x,GM_Real velocity_y,GM_Real velocity_z,GM_Real mass,GM_Real posx,GM_Real posy,GM_Real posz,GM_Real relative);
GM_export GM_Real GMBULLET_AddVelocityAtPoint(GM_Real ID,GM_Real velocity_x,GM_Real velocity_y,GM_Real velocity_z,GM_Real posx,GM_Real posy,GM_Real posz,GM_Real relative);
GM_export GM_Real GMBULLET_SetGravityX(GM_Real ID,GM_Real x);
GM_export GM_Real GMBULLET_SetGravityY(GM_Real ID,GM_Real y);
GM_export GM_Real GMBULLET_SetGravityZ(GM_Real ID,GM_Real z);
GM_export GM_Real GMBULLET_SetGravity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_AddGravity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_SetBodyLinVelFromStack(GM_Real stackID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyAngVelFromStack(GM_Real stackID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyLinAngVelFromStack(GM_Real stackID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyGravityFromStack(GM_Real stackID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyLinVelFromList(GM_Real listID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyAngVelFromList(GM_Real listID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyLinAngVelFromList(GM_Real listID,GM_Real relative);
GM_export GM_Real GMBULLET_SetBodyGravityFromList(GM_Real listID,GM_Real relative);
// 'Get'Body property Functions
GM_export GM_Real GMBULLET_GetFriction(GM_Real ID);
GM_export GM_Real GMBULLET_IsStatic(GM_Real ID);
GM_export GM_Real GMBULLET_IsKinematic(GM_Real ID);
GM_export GM_Real GMBULLET_IsStaticOrKinematic(GM_Real ID);
GM_export GM_Real GMBULLET_IsActive(GM_Real ID);
GM_export GM_Real GMBULLET_HasCollided(GM_Real ID);
GM_export GM_Real GMBULLET_GetDeactivationTime(GM_Real ID);
GM_export GM_Real GMBULLET_GetAssociatedInstance(GM_Real ID);
GM_export GM_Real GMBULLET_GetAngularFactor(GM_Real ID);
GM_export GM_Real GMBULLET_GetGravityX(GM_Real ID);
GM_export GM_Real GMBULLET_GetGravityY(GM_Real ID);
GM_export GM_Real GMBULLET_GetGravityZ(GM_Real ID);
GM_export GM_Real GMBULLET_GetPositionX(GM_Real ID);
GM_export GM_Real GMBULLET_GetPositionY(GM_Real ID);
GM_export GM_Real GMBULLET_GetPositionZ(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationAngleAxisX(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationAngleAxisY(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationAngleAxisZ(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationAngleAxisTheta(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationEulerX(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationEulerY(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationEulerZ(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationQuaternionX(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationQuaternionY(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationQuaternionZ(GM_Real ID);
GM_export GM_Real GMBULLET_GetRotationQuaternionW(GM_Real ID);
GM_export GM_Real GMBULLET_GetAngularVelocityX(GM_Real ID);
GM_export GM_Real GMBULLET_GetAngularVelocityY(GM_Real ID);
GM_export GM_Real GMBULLET_GetAngularVelocityZ(GM_Real ID);
GM_export GM_Real GMBULLET_GetLinearVelocityX(GM_Real ID);
GM_export GM_Real GMBULLET_GetLinearVelocityY(GM_Real ID);
GM_export GM_Real GMBULLET_GetLinearVelocityZ(GM_Real ID);
GM_export GM_Real GMBULLET_GetCollisionMask(GM_Real ID);
GM_export GM_Real GMBULLET_GetCollisionGroup(GM_Real ID);
GM_export GM_Real GMBULLET_GetMass(GM_Real ID);
GM_export GM_Real GMBULLET_GetHitFraction(GM_Real ID);
GM_export GM_Real GMBULLET_GetRestitution(GM_Real ID);
GM_export GM_Real GMBULLET_DeactivationTime(GM_Real ID);
GM_export GM_Real GMBULLET_GetDistanceToPoint(GM_Real ID,GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_GetDistanceToBody(GM_Real ID1,GM_Real ID2);
GM_export GM_Real GMBULLET_GetBodyPositionsToStack(GM_Real stackBodyIDs,GM_Real stackReturnVals);
GM_export GM_Real GMBULLET_GetBodyRotationsToStack(GM_Real stackBodyIDs,GM_Real stackReturnVals);
GM_export GM_Real GMBULLET_GetBodyTransformsToStack(GM_Real stackBodyIDs,GM_Real stackReturnVals);
GM_export GM_Real GMBULLET_GetBodyLinVelocitiesToStack(GM_Real stackBodyIDs,GM_Real stackReturnVals);
GM_export GM_Real GMBULLET_GetBodyAngVelocitiesToStack(GM_Real stackBodyIDs,GM_Real stackReturnVals);
GM_export GM_Real GMBULLET_GetBodyVelocitiesToStack(GM_Real stackBodyIDs,GM_Real stackReturnVals);
GM_export GM_Real GMBULLET_GetBodyPositionsToList(GM_Real listID);
GM_export GM_Real GMBULLET_GetBodyRotationsToList(GM_Real listID);
GM_export GM_Real GMBULLET_GetBodyTransformsToList(GM_Real listID);
GM_export GM_Real GMBULLET_GetBodyLinVelocitiesToList(GM_Real listID);
GM_export GM_Real GMBULLET_GetBodyAngVelocitiesToList(GM_Real listID);
GM_export GM_Real GMBULLET_GetBodyVelocitiesToList(GM_Real listID);
#endif //__GMB_RIGID_BODY_EXPORTS__
