#ifndef __GMB_MISC_EXPORTS__
#define __GMB_MISC_EXPORTS__

#include "gmbCommon.h"
#include "btBulletDynamicsCommon.h"
#include "btGImpactShape.h"
#include "btGImpactCollisionAlgorithm.h"
#include "gmbMyOverlappingPairCallback.h"

//Bullet class variables
extern btDiscreteDynamicsWorld* gmbGlobal_World;
extern btCollisionDispatcher* gmbGlobal_Dispatcher;
extern btBroadphaseInterface* gmbGlobal_Broadphase;
extern btSequentialImpulseConstraintSolver* gmbGlobal_ConstraintSolver;

extern gmbMyOverlappingPairCallback* gmbGlobal_myOverPairCall;

extern btScalar DistanceScale; //Scaling
extern btScalar invDistanceScale;
extern btScalar AngleMultiplier; //Convert to left/right coordinate system and deg/rad
extern btScalar invAngleMultiplier;

extern bool gmbGlobal_IsInitialized;

//Helper Functions
btMatrix3x3 RotationWithFlags(btScalar r1,btScalar r2,btScalar r3,btMatrix3x3 &tm=btMatrix3x3(btQuaternion(0,0,0)));
//-----------------------
//World Functions
GM_export GM_Real GMBULLET_CreateBulletWorld(GM_Real minx,GM_Real miny,GM_Real minz,GM_Real maxx,GM_Real maxy,GM_Real maxz,GM_Real broadphaseType);
GM_export GM_Real GMBULLET_DestroyBulletWorld();
GM_export GM_Real GMBULLET_StepSimulationTime(GM_Real timestep,GM_Real maxsteps,GM_Real fixedTimestep);
GM_export GM_Real GMBULLET_SetWorldGravity(GM_Real x,GM_Real y,GM_Real z);
GM_export GM_Real GMBULLET_SetWorldScale(GM_Real scale);
GM_export GM_Real GMBULLET_SetAngleProperties(GM_Real isDegrees,GM_Real isLeftHanded);
GM_export GM_Real GMBULLET_SetRotationFlags(GM_Real axis1,GM_Real axis2,GM_Real axis3);
//-----------------------
//Collision Tests
//Ray Tests
GM_export GM_Real GMBULLET_RayTestClosestHit(GM_Real xfrom,GM_Real yfrom,GM_Real zfrom,GM_Real xto,GM_Real yto,GM_Real zto,GM_Real cMask,GM_Real cGroup,GM_Real retInfo,GM_Real ignore_ID);
GM_export GM_Real GMBULLET_RayTestAllHit(GM_Real xfrom,GM_Real yfrom,GM_Real zfrom,GM_Real xto,GM_Real yto,GM_Real zto,GM_Real cMask,GM_Real cGroup,GM_Real ignore_ID);
GM_export GM_Real GMBULLET_RayTestSingle(GM_Real ID,GM_Real ShapeID,GM_Real xfrom,GM_Real yfrom,GM_Real zfrom,GM_Real xto,GM_Real yto,GM_Real zto);
//Convex Tests
GM_export GM_Real GMBULLET_ConvexSweepOrientation(GM_Real rx1,GM_Real ry1,GM_Real rz1,GM_Real rx2,GM_Real ry2,GM_Real rz2);
GM_export GM_Real GMBULLET_ConvexSweepClosestHit(GM_Real ShapeID,GM_Real xfrom,GM_Real yfrom,GM_Real zfrom,GM_Real xto,GM_Real yto,GM_Real zto,GM_Real cMask,GM_Real cGroup,GM_Real retInfo,GM_Real ignore_ID);
GM_export GM_Real GMBULLET_ConvexSweepAllHit(GM_Real ShapeID,GM_Real xfrom,GM_Real yfrom,GM_Real zfrom,GM_Real xto,GM_Real yto,GM_Real zto,GM_Real cMask,GM_Real cGroup,GM_Real ignore_ID);
GM_export GM_Real GMBULLET_ConvexSweepSingle(GM_Real ShapeID,GM_Real BodyID,GM_Real ShapeID2,GM_Real xfrom,GM_Real yfrom,GM_Real zfrom,GM_Real xto,GM_Real yto,GM_Real zto);
//Collision Test results
GM_export GM_Real GMBULLET_GetRayConvexTestHitPointX(GM_Real num);
GM_export GM_Real GMBULLET_GetRayConvexTestHitPointY(GM_Real num);
GM_export GM_Real GMBULLET_GetRayConvexTestHitPointZ(GM_Real num);
GM_export GM_Real GMBULLET_GetRayConvexTestHitNormalX(GM_Real num);
GM_export GM_Real GMBULLET_GetRayConvexTestHitNormalY(GM_Real num);
GM_export GM_Real GMBULLET_GetRayConvexTestHitNormalZ(GM_Real num);
GM_export GM_Real GMBULLET_GetRayConvexTestHitFraction(GM_Real num);
GM_export GM_Real GMBULLET_GetRayConvexTestObjectID(GM_Real num);
GM_export GM_Real GMBULLET_GetRayConvexTestGMID(GM_Real num);
GM_export GM_Real GMBULLET_ClearRayConvexTestResults();
//Test using Data Structures
GM_export GM_Real GMBULLET_PerformTestUsingDSStack(GM_Real inputQueueID,GM_Real resultsStackID);
GM_export GM_Real GMBULLET_PerformTestUsingDSList(GM_Real inputQueueID,GM_Real resultsListID);
//-----------------------
//Lists
GM_export GM_Real GMBULLET_GenerateActiveList(GM_Real excludeWantsDeactivation);
GM_export GM_Real GMBULLET_GenerateCollidedList();
GM_export GM_Real GMBULLET_GenerateCollideWithBodyList(GM_Real ID,GM_Real type);
GM_export GM_Real GMBULLET_ClearList();
GM_export GM_Real GMBULLET_GetListBodyID(GM_Real num,GM_Real idtype);
GM_export GM_Real GMBULLET_GetListBodyIDsToStack(GM_Real stackID,GM_Real idtype);
GM_export GM_Real GMBULLET_GetListBodyIDsToList(GM_Real listID,GM_Real idtype);
//Collision Pairs
GM_export GM_Real GMBULLET_GetNumNewCollisionPair();
GM_export GM_Real GMBULLET_GetNumOldCollisionPair();
GM_export GM_Real GMBULLET_GetNumCollisionPair();

GM_export GM_Real GMBULLET_GetNewCollisionPairBodyID(GM_Real num,GM_Real bodyB,GM_Real idtype);
GM_export GM_Real GMBULLET_GetOldCollisionPairBodyID(GM_Real num,GM_Real bodyB,GM_Real idtype);
GM_export GM_Real GMBULLET_GetCollisionPairBodyID(GM_Real num,GM_Real bodyB,GM_Real idtype);

GM_export GM_Real GMBULLET_GetOldCollisionPairToStack(GM_Real stackID,GM_Real idtype);
GM_export GM_Real GMBULLET_GetOldCollisionPairToList(GM_Real listID,GM_Real idtype);
GM_export GM_Real GMBULLET_GetNewCollisionPairToStack(GM_Real stackID,GM_Real idtype);
GM_export GM_Real GMBULLET_GetNewCollisionPairToList(GM_Real listID,GM_Real idtype);
GM_export GM_Real GMBULLET_GetCollisionPairToStack(GM_Real stackID,GM_Real idtype);
GM_export GM_Real GMBULLET_GetCollisionPairToList(GM_Real listID,GM_Real idtype);

GM_export GM_Real GMBULLET_GetCollisionPairNumContactPoints(GM_Real num);
GM_export GM_Real GMBULLET_GetCollisionPairContactPointX(GM_Real num,GM_Real point,GM_Real PointOnB);
GM_export GM_Real GMBULLET_GetCollisionPairContactPointY(GM_Real num,GM_Real point,GM_Real PointOnB);
GM_export GM_Real GMBULLET_GetCollisionPairContactPointZ(GM_Real num,GM_Real point,GM_Real PointOnB);
GM_export GM_Real GMBULLET_GetCollisionPairContactPointAverageX(GM_Real num);
GM_export GM_Real GMBULLET_GetCollisionPairContactPointAverageY(GM_Real num);
GM_export GM_Real GMBULLET_GetCollisionPairContactPointAverageZ(GM_Real num);

GM_export GM_Real GMBULLET_GetCollisionPairContactPointAverageToStack(GM_Real stackID,GM_Real idtype);
GM_export GM_Real GMBULLET_GetCollisionPairContactPointsToStack(GM_Real stackID,GM_Real idtype);
GM_export GM_Real GMBULLET_GetCollisionPairContactPointAverageToList(GM_Real listID,GM_Real idtype);
GM_export GM_Real GMBULLET_GetCollisionPairContactPointsToList(GM_Real listID,GM_Real idtype);
//-----------------------------------
#endif //__GMB_MISC_EXPORTS__