#ifndef __GMB_INDEXED_LIST__
#define __GMB_INDEXED_LIST__

#include "btBulletDynamicsCommon.h"

//This class is an array designed to hold pointers to objects,
//addressable by an index, which won't change if one is removed

template <class T> 
class gmbIndexedList
{
	btAlignedObjectArray<unsigned int> m_freeIndices;
public:
	btAlignedObjectArray<T> m_indexArray;

	gmbIndexedList(void)
	{
	}
	virtual ~gmbIndexedList(void)
	{
		Clear();
	}

	T GetInstance(unsigned int ID)
	{
		if(ID<unsigned int(0) || ID>=unsigned int(m_indexArray.size()))
			return NULL;
		return m_indexArray[ID];
	}
	unsigned int AddInstance(T inst)
	{
		if(m_freeIndices.size()==0)
		{
			m_indexArray.push_back(inst);
			return m_indexArray.size()-1;
		}
		else
		{
			int pos=m_freeIndices[m_freeIndices.size()-1];
			m_freeIndices.pop_back();
			m_indexArray[pos]=inst;
			return pos;
		}
	}
	void RemoveInstance(unsigned int ID)
	{
		if(ID<unsigned int(0) || ID>=unsigned int(m_indexArray.size()))
			return;
		if(m_indexArray[ID]==NULL)
			return;
		m_indexArray[ID]->Release();
		m_indexArray[ID]=NULL;
		m_freeIndices.push_back(ID);
		for(int i=m_freeIndices.size()-1;i>=1;i--)
		{
			if(m_freeIndices[i]>m_freeIndices[i-1])
			{
				m_freeIndices.swap(i,i-1);
				continue;
			}
			else
			{
				break;
			}
		}

		int k;
		for(k=0;m_freeIndices[k]==(m_indexArray.size()-1)&&m_freeIndices.size()>k;k++)
		{
			m_indexArray.pop_back();
		}
		if(k>0)
		{
			for(int j=k;j<m_freeIndices.size();j++)
			{
				m_freeIndices.swap(j-k,j);
			}
			for(int j=0;j<k;j++)
			{
				m_freeIndices.pop_back();
			}
		}
	}

	void Clear(void)
	{
		for(int i=m_indexArray.size()-1;i>=0;i--)
			RemoveInstance(i);
		m_freeIndices.clear();
		m_indexArray.clear();
	}
};

template <class T> 
class gmbIndexedListUnRef
{
	class gmbPointerSort
	{
		public:

			bool operator() ( unsigned int &a, unsigned int &b )
			{
				 return a>b; 
			}
	};
		
	btAlignedObjectArray<unsigned int> m_freeIndices;
public:
	btAlignedObjectArray<T> m_indexArray;

	gmbIndexedListUnRef(void)
	{
	}
	virtual ~gmbIndexedListUnRef(void)
	{
		Clear();
	}

	T GetInstance(unsigned int ID)
	{
		if(ID<unsigned int(0) || ID>=unsigned int(m_indexArray.size()))
			return NULL;
		return m_indexArray[ID];
	}
	unsigned int AddInstance(T inst)
	{
		if(m_freeIndices.size()==0)
		{
			m_indexArray.push_back(inst);
			return m_indexArray.size()-1;
		}
		else
		{
			int pos=m_freeIndices[0];
			m_freeIndices.pop_back();
			m_indexArray[pos]=inst;
			return pos;
		}
	}
	void RemoveInstance(unsigned int ID)
	{
		if(ID<unsigned int(0) || ID>=unsigned int(m_indexArray.size()))
			return;
		if(m_indexArray[ID]==NULL)
			return;
		delete m_indexArray[ID];
		m_indexArray[ID]=NULL;
		m_freeIndices.push_back(ID);
		m_freeIndices.heapSort(gmbPointerSort());

		while(m_freeIndices[m_freeIndices.size()-1]==(m_indexArray.size()-1))
		{
			m_freeIndices.pop_back();
			m_indexArray.pop_back();
			if(!m_freeIndices.size())
				break;
		}
	}

	void Clear(void)
	{
		for(int i=m_indexArray.size()-1;i>=0;i--)
			RemoveInstance(i);
		m_freeIndices.clear();
		m_indexArray.clear();
	}
};

#endif //__GMB_INDEXED_LIST__
