#ifndef __GMB_CONSTRAINT_EXPORTS__
#define __GMB_CONSTRAINT_EXPORTS__

#include "gmbCommon.h"
#include "gmbConstraint.h"
#include "gmbIndexedList.h"

extern gmbIndexedList<gmbConstraint*> gmbGlobal_Constraints;

GM_export GM_Real GMBULLET_Prepare2BodyConstraint(GM_Real ID,GM_Real x,GM_Real y,GM_Real z,GM_Real r1,GM_Real r2,GM_Real r3);
GM_export GM_Real GMBULLET_Create1BodyBallConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1);
GM_export GM_Real GMBULLET_Create2BodyBallConstraint(GM_Real ID1,GM_Real ID2,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real x2,GM_Real y2,GM_Real z2,GM_Real disable);
GM_export GM_Real GMBULLET_SetBallConstraintPivot(GM_Real ID,GM_Real inA,GM_Real x, GM_Real y, GM_Real z);
GM_export GM_Real GMBULLET_Create1BodyHingeConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3);
GM_export GM_Real GMBULLET_Create2BodyHingeConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3,GM_Real disable);
GM_export GM_Real GMBULLET_EnableHingeAngularMotor(GM_Real ID,GM_Real enable, GM_Real velocity, GM_Real impulse);
GM_export GM_Real GMBULLET_SetHingeLimit(GM_Real ID,GM_Real low,GM_Real high,GM_Real softness,GM_Real bias,GM_Real relaxation);
GM_export GM_Real GMBULLET_Create1BodyConeConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3);
GM_export GM_Real GMBULLET_Create2BodyConeConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3,GM_Real disable);
GM_export GM_Real GMBULLET_SetConeLimit(GM_Real ID,GM_Real swingSpan1,GM_Real swingSpan2,GM_Real twistSpan,GM_Real softness,GM_Real bias,GM_Real relaxation);
GM_export GM_Real GMBULLET_SetHingeConeAngularOnly(GM_Real ID,GM_Real angularOnly);
GM_export GM_Real GMBULLET_Create2Body6DOFConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3,GM_Real useLinearReferenceFrameA,GM_Real disable);
GM_export GM_Real GMBULLET_Set6DOFLimit(GM_Real ID,GM_Real axis,GM_Real lo,GM_Real hi);
GM_export GM_Real GMBULLET_DeleteConstraint(GM_Real ID);
GM_export GM_Real GMBULLET_Create2DConstraint(GM_Real ID1,GM_Real zLowerLim,GM_Real zUpperLim);
GM_export GM_Real GMBULLET_Create2BodySliderConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3,GM_Real useLinearReferenceFrameA,GM_Real disable);
GM_export GM_Real GMBULLET_SetSliderLimits(GM_Real ID,GM_Real linLow,GM_Real angLow,GM_Real linHi,GM_Real angHi);
GM_export GM_Real GMBULLET_SetSliderMotor(GM_Real ID,GM_Real linOn,GM_Real angOn,GM_Real linSpeed,GM_Real angSpeed,GM_Real linForce,GM_Real angForce);
GM_export GM_Real GMBULLET_SetSliderRestitution(GM_Real ID,GM_Real dirLin,GM_Real dirAng,GM_Real limLin,GM_Real limAng,GM_Real orthoLin,GM_Real orthoAng);
GM_export GM_Real GMBULLET_SetSliderSoftness(GM_Real ID,GM_Real dirLin,GM_Real dirAng,GM_Real limLin,GM_Real limAng,GM_Real orthoLin,GM_Real orthoAng);
GM_export GM_Real GMBULLET_SetSliderDamping(GM_Real ID,GM_Real dirLin,GM_Real dirAng,GM_Real limLin,GM_Real limAng,GM_Real orthoLin,GM_Real orthoAng);
//Vehicle constraint

GM_export GM_Real GMBULLET_SetCurrentTuning(GM_Real frictionSlip,GM_Real maxSuspensionTravel,GM_Real suspensionCompression,GM_Real suspensionDamping,GM_Real suspensionStiffness);
GM_export GM_Real GMBULLET_CreateVehicle(GM_Real ID1,GM_Real rightAxis,GM_Real upAxis,GM_Real forwardAxis);
GM_export GM_Real GMBULLET_SetUpWheel(GM_Real dirx,GM_Real diry,GM_Real dirz,GM_Real axelx,GM_Real axely,GM_Real axelz);
GM_export GM_Real GMBULLET_AddWheel(GM_Real ID,GM_Real attachx,GM_Real attachy,GM_Real attachz,GM_Real suspensionRestLength,GM_Real radius,GM_Real isfront);
GM_export GM_Real GMBULLET_ApplyEngineForce(GM_Real ID,GM_Real wheelindex,GM_Real force);
GM_export GM_Real GMBULLET_SetBrake(GM_Real ID,GM_Real wheelindex,GM_Real brake);
GM_export GM_Real GMBULLET_SetSteering(GM_Real ID,GM_Real wheelindex,GM_Real steering);
GM_export GM_Real GMBULLET_ChangeWheelProperties(GM_Real ID,GM_Real wheelindex,GM_Real attachx,GM_Real attachy,GM_Real attachz,GM_Real suspensionRestLength,GM_Real radius,GM_Real isfront);
GM_export GM_Real GMBULLET_GetCurrentSpeed(GM_Real ID);
#endif //__GMB_CONSTRAINT_EXPORTS__