#include "gmbConstraintExports.h"

#include "btBulletDynamicsCommon.h"
#include "BulletCollision/CollisionDispatch/btGhostObject.h"
#include "gmbRigidBody.h"
#include "gmbShape.h"

gmbIndexedList<gmbConstraint*> gmbGlobal_Constraints;

unsigned int gmbLocalGlobal_ConstraintRigidBody2ID;
btTransform gmbLocalGlobal_ConstraintRigidBody2Transform;
btRaycastVehicle::btVehicleTuning gmbLocalGlobal_Tuning;
btDefaultVehicleRaycaster* gmbLocalGlobal_VRay=NULL;
btVector3 gmbLocalGlobal_wheelDir;
btVector3 gmbLocalGlobal_wheelAxel;
static btRigidBody gmbLocalGlobal_fixed(0,0,0);

GM_export GM_Real GMBULLET_Prepare2BodyConstraint(GM_Real ID,GM_Real x,GM_Real y,GM_Real z,GM_Real r1,GM_Real r2,GM_Real r3)
{
	gmbLocalGlobal_ConstraintRigidBody2ID=unsigned int(ID);
	gmbLocalGlobal_ConstraintRigidBody2Transform.setOrigin(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
	gmbLocalGlobal_ConstraintRigidBody2Transform.setBasis(RotationWithFlags(btScalar(r1),btScalar(r2),btScalar(r3)));
	return 0;
}

GM_export GM_Real GMBULLET_Create1BodyBallConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1)
{
	if(!gmbGlobal_IsInitialized)
		return -1;

	btRigidBody* tb1;
	if(!(tb1=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID1))))
		return -2;
	btTypedConstraint* tc=new btPoint2PointConstraint(*tb1,btVector3(btScalar(x1),btScalar(y1),btScalar(z1))*invDistanceScale);
	gmbGlobal_World->addConstraint(tc);
	return gmbGlobal_Constraints.AddInstance(new gmbConstraint(tc));
}

GM_export GM_Real GMBULLET_Create2BodyBallConstraint(GM_Real ID1,GM_Real ID2,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real x2,GM_Real y2,GM_Real z2,GM_Real disable)
{
	if(!gmbGlobal_IsInitialized)
		return -1;

	btRigidBody* tb1,*tb2;
	if(!(tb1=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID1)))||!(tb2=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID2))))
		return -2;

	btTypedConstraint* tc=new btPoint2PointConstraint(*tb1,*tb2,btVector3(btScalar(x1),btScalar(y1),btScalar(z1))*invDistanceScale,btVector3(btScalar(x2),btScalar(y2),btScalar(z2))*invDistanceScale);
	gmbGlobal_World->addConstraint(tc,bool(disable));
	return gmbGlobal_Constraints.AddInstance(new gmbConstraint(tc));
}

GM_export GM_Real GMBULLET_SetBallConstraintPivot(GM_Real ID,GM_Real inA,GM_Real x, GM_Real y, GM_Real z)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btPoint2PointConstraint* tpc = dynamic_cast<btPoint2PointConstraint*>(tc);
	if(!tpc)
		return -1;
	if(inA)
		tpc->setPivotA(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
	else
		tpc->setPivotB(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
	return 0;
}

GM_export GM_Real GMBULLET_Create1BodyHingeConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3)
{
	if(!gmbGlobal_IsInitialized)
		return -1;

	btRigidBody* tb1;
	if(!(tb1=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID1))))
		return -2;
	
	btTransform b1trans(RotationWithFlags(btScalar(r1),btScalar(r2),btScalar(r3)),btVector3(btScalar(x1),btScalar(y1),btScalar(z1))*invDistanceScale);
	btTypedConstraint* tc=new btHingeConstraint(*tb1,b1trans);
	gmbGlobal_World->addConstraint(tc);
	return gmbGlobal_Constraints.AddInstance(new gmbConstraint(tc));
}

GM_export GM_Real GMBULLET_Create2BodyHingeConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3,GM_Real disable)
{
	if(!gmbGlobal_IsInitialized)
		return -1;

	btRigidBody* tb1,*tb2;
	if(!(tb1=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID1)))||!(tb2=gmbGlobal_RigidBodies.GetInstance(unsigned int(gmbLocalGlobal_ConstraintRigidBody2ID))))
		return -2;
	
	btTransform b1trans(RotationWithFlags(btScalar(r1),btScalar(r2),btScalar(r3)),btVector3(btScalar(x1),btScalar(y1),btScalar(z1))*invDistanceScale);
	btTypedConstraint* tc=new btHingeConstraint(*tb1,*tb2,b1trans,gmbLocalGlobal_ConstraintRigidBody2Transform);
	gmbGlobal_World->addConstraint(tc,bool(disable));
	return gmbGlobal_Constraints.AddInstance(new gmbConstraint(tc));
}

GM_export GM_Real GMBULLET_EnableHingeAngularMotor(GM_Real ID,GM_Real enable, GM_Real velocity, GM_Real impulse)
{

	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btHingeConstraint* tpc = dynamic_cast<btHingeConstraint*>(tc);
	if(!tpc)
		return -1;
	
	tpc->enableAngularMotor(bool(enable),btScalar(velocity),btScalar(impulse));
	return 0;
}
GM_export GM_Real GMBULLET_SetHingeLimit(GM_Real ID,GM_Real low,GM_Real high,GM_Real softness,GM_Real bias,GM_Real relaxation)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btHingeConstraint* tpc = dynamic_cast<btHingeConstraint*>(tc);
	if(!tpc)
		return -1;
	
	tpc->setLimit(btScalar(low),btScalar(high),btScalar(softness),btScalar(bias),btScalar(relaxation));
	return 0;
}

GM_export GM_Real GMBULLET_Create1BodyConeConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3)
{
	if(!gmbGlobal_IsInitialized)
		return -1;

	btRigidBody* tb1;
	if(!(tb1=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID1))))
		return -2;
	
	btTransform b1trans(RotationWithFlags(btScalar(r1),btScalar(r2),btScalar(r3)),btVector3(btScalar(x1),btScalar(y1),btScalar(z1))*invDistanceScale);
	btTypedConstraint* tc=new btConeTwistConstraint(*tb1,b1trans);
	gmbGlobal_World->addConstraint(tc);
	return gmbGlobal_Constraints.AddInstance(new gmbConstraint(tc));
}

GM_export GM_Real GMBULLET_Create2BodyConeConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3,GM_Real disable)
{
	if(!gmbGlobal_IsInitialized)
		return -1;

	btRigidBody* tb1,*tb2;
	if(!(tb1=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID1)))||!(tb2=gmbGlobal_RigidBodies.GetInstance(unsigned int(gmbLocalGlobal_ConstraintRigidBody2ID))))
		return -2;
	
	btTransform b1trans(RotationWithFlags(btScalar(r1),btScalar(r2),btScalar(r3)),btVector3(btScalar(x1),btScalar(y1),btScalar(z1))*invDistanceScale);
	btTypedConstraint* tc=new btConeTwistConstraint(*tb1,*tb2,b1trans,gmbLocalGlobal_ConstraintRigidBody2Transform);
	gmbGlobal_World->addConstraint(tc,bool(disable));
	return gmbGlobal_Constraints.AddInstance(new gmbConstraint(tc));
}

GM_export GM_Real GMBULLET_SetConeLimit(GM_Real ID,GM_Real swingSpan1,GM_Real swingSpan2,GM_Real twistSpan,GM_Real softness,GM_Real bias,GM_Real relaxation)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btConeTwistConstraint* tpc = dynamic_cast<btConeTwistConstraint*>(tc);
	if(!tpc)
		return -1;
	
	tpc->setLimit(btScalar(swingSpan1),btScalar(swingSpan2),btScalar(twistSpan),btScalar(softness),btScalar(bias),btScalar(relaxation));
	return 0;
}

GM_export GM_Real GMBULLET_SetHingeConeAngularOnly(GM_Real ID,GM_Real angularOnly)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	switch(tc->getConstraintType())
	{
	case HINGE_CONSTRAINT_TYPE:
			reinterpret_cast<btHingeConstraint*>(tc)->setAngularOnly(angularOnly);
			return 0;
			break;
	case CONETWIST_CONSTRAINT_TYPE:
			reinterpret_cast<btConeTwistConstraint*>(tc)->setAngularOnly(angularOnly);
			return 0;
			break;
	}
	return -1;
}

GM_export GM_Real GMBULLET_Create2Body6DOFConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3,GM_Real useLinearReferenceFrameA,GM_Real disable)
{
	if(!gmbGlobal_IsInitialized)
		return -1;

	btRigidBody* tb1,*tb2;
	if(!(tb1=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID1)))||!(tb2=gmbGlobal_RigidBodies.GetInstance(unsigned int(gmbLocalGlobal_ConstraintRigidBody2ID))))
		return -2;
	
	btTransform b1trans(RotationWithFlags(btScalar(r1),btScalar(r2),btScalar(r3)),btVector3(btScalar(x1),btScalar(y1),btScalar(z1))*invDistanceScale);
	btTypedConstraint* tc=new btGeneric6DofConstraint(*tb1,*tb2,b1trans,gmbLocalGlobal_ConstraintRigidBody2Transform,bool(useLinearReferenceFrameA));
	gmbGlobal_World->addConstraint(tc,bool(disable));
	return gmbGlobal_Constraints.AddInstance(new gmbConstraint(tc));
}

GM_export GM_Real GMBULLET_Set6DOFLimit(GM_Real ID,GM_Real axis,GM_Real lo,GM_Real hi)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btGeneric6DofConstraint* tpc = dynamic_cast<btGeneric6DofConstraint*>(tc);
	if(!tpc)
		return -1;
	if(int(axis)<6&&int(axis)>=0)
	{
		tpc->setLimit(int(axis),btScalar(lo),btScalar(hi));
		return 0;
	}
	else
		return -1;
}

GM_export GM_Real GMBULLET_Create2DConstraint(GM_Real ID1,GM_Real zLowerLim,GM_Real zUpperLim)
{
	if(!gmbGlobal_IsInitialized)
		return -1;

	btRigidBody* tb1;
	if(!(tb1=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID1))))
		return -2;
	btGeneric6DofConstraint* tc=new btGeneric6DofConstraint(*tb1,gmbLocalGlobal_fixed,btTransform(btQuaternion(0,0,1,0)),btTransform(btQuaternion(0,0,1,0)),0);
	tc->setLinearLowerLimit(btVector3(1,1,0));
	tc->setLinearUpperLimit(btVector3(0,0,0));
	tc->setAngularLowerLimit(btVector3(0,0,btScalar(zLowerLim)));
	tc->setAngularUpperLimit(btVector3(0,0,btScalar(zUpperLim)));
	gmbGlobal_World->addConstraint(tc,false);
	return gmbGlobal_Constraints.AddInstance(new gmbConstraint(tc));
}
GM_export GM_Real GMBULLET_DeleteConstraint(GM_Real ID)
{
	if(!gmbGlobal_IsInitialized)
		return -1;

	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	if(tc->getConstraintType()==VEHICLE_CONSTRAINT_TYPE)
		gmbGlobal_World->removeVehicle(reinterpret_cast<btRaycastVehicle*>(tc));
	else
		gmbGlobal_World->removeConstraint(tc);

	gmbGlobal_Constraints.RemoveInstance(unsigned int(ID));
	return 0;
}
GM_export GM_Real GMBULLET_Create2BodySliderConstraint(GM_Real ID1,GM_Real x1,GM_Real y1,GM_Real z1,GM_Real r1,GM_Real r2,GM_Real r3,GM_Real useLinearReferenceFrameA,GM_Real disable)
{
	if(!gmbGlobal_IsInitialized)
		return -1;

	btRigidBody* tb1,*tb2;
	if(!(tb1=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID1)))||!(tb2=gmbGlobal_RigidBodies.GetInstance(unsigned int(gmbLocalGlobal_ConstraintRigidBody2ID))))
		return -2;
	
	btTransform b1trans(RotationWithFlags(btScalar(r1),btScalar(r2),btScalar(r3)),btVector3(btScalar(x1),btScalar(y1),btScalar(z1))*invDistanceScale);
	btTypedConstraint* tc=new btSliderConstraint(*tb1,*tb2,b1trans,gmbLocalGlobal_ConstraintRigidBody2Transform,bool(useLinearReferenceFrameA));
	gmbGlobal_World->addConstraint(tc,bool(disable));
	return gmbGlobal_Constraints.AddInstance(new gmbConstraint(tc));
}
GM_export GM_Real GMBULLET_SetSliderLimits(GM_Real ID,GM_Real linLow,GM_Real angLow,GM_Real linHi,GM_Real angHi)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btSliderConstraint* tpc = dynamic_cast<btSliderConstraint*>(tc);
	if(!tpc)
		return -1;
	tpc->setLowerAngLimit(btScalar(angLow));
	tpc->setUpperAngLimit(btScalar(angHi));
	tpc->setLowerLinLimit(btScalar(linLow));
	tpc->setUpperLinLimit(btScalar(linHi));
	return 0;
}
GM_export GM_Real GMBULLET_SetSliderMotor(GM_Real ID,GM_Real linOn,GM_Real angOn,GM_Real linSpeed,GM_Real angSpeed,GM_Real linForce,GM_Real angForce)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btSliderConstraint* tpc = dynamic_cast<btSliderConstraint*>(tc);
	if(!tpc)
		return -1;
	tpc->setPoweredLinMotor(bool(linOn));
	tpc->setPoweredAngMotor(bool(angOn));
	tpc->setMaxLinMotorForce(btScalar(linForce));
	tpc->setMaxAngMotorForce(btScalar(angForce));
	tpc->setTargetLinMotorVelocity(btScalar(linSpeed));
	tpc->setTargetAngMotorVelocity(btScalar(angSpeed));
	
	return 0;
}
GM_export GM_Real GMBULLET_SetSliderRestitution(GM_Real ID,GM_Real dirLin,GM_Real dirAng,GM_Real limLin,GM_Real limAng,GM_Real orthoLin,GM_Real orthoAng)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btSliderConstraint* tpc = dynamic_cast<btSliderConstraint*>(tc);
	if(!tpc)
		return -1;
	tpc->setRestitutionDirLin(btScalar(dirLin));
	tpc->setRestitutionDirAng(btScalar(dirAng));
	tpc->setRestitutionLimLin(btScalar(limLin));
	tpc->setRestitutionLimAng(btScalar(limAng));
	tpc->setRestitutionOrthoLin(btScalar(orthoLin));
	tpc->setRestitutionOrthoAng(btScalar(orthoAng));
	return 0;
}
GM_export GM_Real GMBULLET_SetSliderSoftness(GM_Real ID,GM_Real dirLin,GM_Real dirAng,GM_Real limLin,GM_Real limAng,GM_Real orthoLin,GM_Real orthoAng)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btSliderConstraint* tpc = dynamic_cast<btSliderConstraint*>(tc);
	if(!tpc)
		return -1;
	tpc->setSoftnessDirLin(btScalar(dirLin));
	tpc->setSoftnessDirAng(btScalar(dirAng));
	tpc->setSoftnessLimLin(btScalar(limLin));
	tpc->setSoftnessLimAng(btScalar(limAng));
	tpc->setSoftnessOrthoLin(btScalar(orthoLin));
	tpc->setSoftnessOrthoAng(btScalar(orthoAng));
	return 0;
}
GM_export GM_Real GMBULLET_SetSliderDamping(GM_Real ID,GM_Real dirLin,GM_Real dirAng,GM_Real limLin,GM_Real limAng,GM_Real orthoLin,GM_Real orthoAng)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btSliderConstraint* tpc = dynamic_cast<btSliderConstraint*>(tc);
	if(!tpc)
		return -1;
	tpc->setDampingDirLin(btScalar(dirLin));
	tpc->setDampingDirAng(btScalar(dirAng));
	tpc->setDampingLimLin(btScalar(limLin));
	tpc->setDampingLimAng(btScalar(limAng));
	tpc->setDampingOrthoLin(btScalar(orthoLin));
	tpc->setDampingOrthoAng(btScalar(orthoAng));
	return 0;
}
//Vehicle constraint

GM_export GM_Real GMBULLET_SetCurrentTuning(GM_Real frictionSlip,GM_Real maxSuspensionTravel,GM_Real suspensionCompression,GM_Real suspensionDamping,GM_Real suspensionStiffness)
{
	gmbLocalGlobal_Tuning.m_frictionSlip=btScalar(frictionSlip);
	gmbLocalGlobal_Tuning.m_maxSuspensionTravelCm=btScalar(maxSuspensionTravel)*.01f*invDistanceScale;
	gmbLocalGlobal_Tuning.m_suspensionCompression=btScalar(suspensionCompression);
	gmbLocalGlobal_Tuning.m_suspensionDamping=btScalar(suspensionDamping);
	gmbLocalGlobal_Tuning.m_suspensionStiffness=btScalar(suspensionStiffness);
	return 0;
}
GM_export GM_Real GMBULLET_CreateVehicle(GM_Real ID1,GM_Real rightAxis,GM_Real upAxis,GM_Real forwardAxis)
{
	if(!gmbGlobal_IsInitialized)
		return -1;
	if(!gmbLocalGlobal_VRay)
		gmbLocalGlobal_VRay=new btDefaultVehicleRaycaster(gmbGlobal_World);

	btRigidBody* tb1;
	if(!(tb1=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID1))))
		return -2;
	
	btRaycastVehicle* tVehicle=new btRaycastVehicle(gmbLocalGlobal_Tuning,tb1,gmbLocalGlobal_VRay);	
	tVehicle->setCoordinateSystem(int(rightAxis),int(upAxis),int(forwardAxis));
	gmbGlobal_World->addVehicle(tVehicle);
	return gmbGlobal_Constraints.AddInstance(new gmbConstraint(tVehicle));
}
GM_export GM_Real GMBULLET_SetUpWheel(GM_Real dirx,GM_Real diry,GM_Real dirz,GM_Real axelx,GM_Real axely,GM_Real axelz)
{
	gmbLocalGlobal_wheelDir=btVector3(btScalar(dirx),btScalar(diry),btScalar(dirz));
	gmbLocalGlobal_wheelAxel=btVector3(btScalar(axelx),btScalar(axely),btScalar(axelz));
	return 0;
}
GM_export GM_Real GMBULLET_AddWheel(GM_Real ID,GM_Real attachx,GM_Real attachy,GM_Real attachz,GM_Real suspensionRestLength,GM_Real radius,GM_Real isfront)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btRaycastVehicle* tv = dynamic_cast<btRaycastVehicle*>(tc);
	if(!tv)
		return -1;
	if(tv->getNumWheels()>31)
		return -3;
	tv->addWheel(btVector3(btScalar(attachx),btScalar(attachy),btScalar(attachz))*invDistanceScale,gmbLocalGlobal_wheelDir,gmbLocalGlobal_wheelAxel,btScalar(suspensionRestLength)*invDistanceScale,btScalar(radius)*invDistanceScale,gmbLocalGlobal_Tuning,isfront);
	return pow(GM_Real(2),(GM_Real)tv->getNumWheels()-1);
}
GM_export GM_Real GMBULLET_ApplyEngineForce(GM_Real ID,GM_Real wheelindex,GM_Real force)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btRaycastVehicle* tv = dynamic_cast<btRaycastVehicle*>(tc);
	if(!tv)
		return -1;
	DWORD wind=(DWORD)wheelindex;
	for(int i=0;i<tv->getNumWheels();i++)
	{
		if(wind&(1<<i))
			tv->applyEngineForce(btScalar(force)*invDistanceScale,i);
	}
	return 0;
}

GM_export GM_Real GMBULLET_SetBrake(GM_Real ID,GM_Real wheelindex,GM_Real brake)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btRaycastVehicle* tv = dynamic_cast<btRaycastVehicle*>(tc);
	if(!tv)
		return -1;
	DWORD wind=(DWORD)wheelindex;
	for(int i=0;i<tv->getNumWheels();i++)
	{
		if(wind&(1<<i))
			tv->setBrake((btScalar)brake*invDistanceScale,i);
	}
	return 0;
}
GM_export GM_Real GMBULLET_SetSteering(GM_Real ID,GM_Real wheelindex,GM_Real steering)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btRaycastVehicle* tv = dynamic_cast<btRaycastVehicle*>(tc);
	if(!tv)
		return -1;
	DWORD wind=(DWORD)wheelindex;
	for(int i=0;i<tv->getNumWheels();i++)
	{
		if(wind&(1<<i))
			tv->setSteeringValue(btScalar(steering)*invAngleMultiplier,i);
	}
	return 0;
}
GM_export GM_Real GMBULLET_ChangeWheelProperties(GM_Real ID,GM_Real wheelindex,GM_Real attachx,GM_Real attachy,GM_Real attachz,GM_Real suspensionRestLength,GM_Real radius,GM_Real isfront)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btRaycastVehicle* tv = dynamic_cast<btRaycastVehicle*>(tc);
	if(!tv)
		return -1;
	DWORD wind=(DWORD)wheelindex;
	for(int i=0;i<tv->getNumWheels();i++)
	{
		btWheelInfo* ti;
		if(wind&(1<<i))
		{
			if(i<tv->getNumWheels())
			{
				ti=&tv->m_wheelInfo[i];
				ti->m_chassisConnectionPointCS=btVector3(btScalar(attachx),btScalar(attachy),btScalar(attachz))*invDistanceScale;
				ti->m_suspensionRestLength1=btScalar(suspensionRestLength)*invDistanceScale;
				ti->m_bIsFrontWheel=bool(isfront);
				ti->m_wheelsRadius=btScalar(radius)*invDistanceScale;
				ti->m_wheelAxleCS=gmbLocalGlobal_wheelAxel;
				ti->m_wheelDirectionCS=gmbLocalGlobal_wheelDir;
			}
		}
			
	}
	return 0;
}
GM_export GM_Real GMBULLET_GetCurrentSpeed(GM_Real ID)
{
	gmbConstraint* tgmbc=gmbGlobal_Constraints.GetInstance(unsigned int(ID));
	if(!tgmbc)
		return -1;
	btTypedConstraint* tc=tgmbc->GetConstraint();
	btRaycastVehicle* tv = dynamic_cast<btRaycastVehicle*>(tc);
	if(!tv)
		return -1;
	return tv->getCurrentSpeedKmHour()*DistanceScale;
}
