#include "gmbCompoundShape.h"

gmbCompoundShape::gmbCompoundShape(void)
{
}

gmbCompoundShape::~gmbCompoundShape(void)
{
	while(m_shapeList.size())
		removeGmbChildShapeByIndex(0);
}

void gmbCompoundShape::addGmbChildShape(const btTransform& localTransform,gmbShape* shape)
{
	m_shapeList.push_back(shape);
	shape->Grab();
	addChildShape(localTransform,shape->getShape());
}

gmbShape* gmbCompoundShape::getGmbChildShape(int childShapeIndex)
{
	return m_shapeList[childShapeIndex];
}

void gmbCompoundShape::removeGmbChildShapeByIndex(int childShapeIndex)
{
	removeChildShapeByIndex(childShapeIndex);
	m_shapeList[childShapeIndex]->Release();
	m_shapeList.swap(childShapeIndex,m_shapeList.size()-1);
	m_shapeList.pop_back();
}
